/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocol;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.net.NodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeDetails
extends NodeImpl
implements Comparable<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeDetails.class);
    private final UUID uuid;
    private final String uuidString;
    private String ipAddress;
    private String hostName;
    private List<Port> ports;
    private String certSerialId;
    private String version;
    private long setupTime;
    private String revision;
    private String buildDate;
    private HddsProtos.NodeOperationalState persistedOpState;
    private long persistedOpStateExpiryEpochSec = 0L;
    private int initialVersion;
    private int currentVersion;

    private DatanodeDetails(UUID uuid, String ipAddress, String hostName, String networkLocation, List<Port> ports, String certSerialId, String version, long setupTime, String revision, String buildDate, HddsProtos.NodeOperationalState persistedOpState, long persistedOpStateExpiryEpochSec, int initialVersion, int currentVersion) {
        super(hostName, networkLocation, 0);
        this.uuid = uuid;
        this.uuidString = uuid.toString();
        this.ipAddress = ipAddress;
        this.hostName = hostName;
        this.ports = ports;
        this.certSerialId = certSerialId;
        this.version = version;
        this.setupTime = setupTime;
        this.revision = revision;
        this.buildDate = buildDate;
        this.persistedOpState = persistedOpState;
        this.persistedOpStateExpiryEpochSec = persistedOpStateExpiryEpochSec;
        this.initialVersion = initialVersion;
        this.currentVersion = currentVersion;
    }

    public DatanodeDetails(DatanodeDetails datanodeDetails) {
        super(datanodeDetails.getHostName(), datanodeDetails.getNetworkLocation(), datanodeDetails.getCost());
        this.uuid = datanodeDetails.uuid;
        this.uuidString = this.uuid.toString();
        this.ipAddress = datanodeDetails.ipAddress;
        this.hostName = datanodeDetails.hostName;
        this.ports = datanodeDetails.ports;
        this.setNetworkName(datanodeDetails.getNetworkName());
        this.setParent(datanodeDetails.getParent());
        this.version = datanodeDetails.version;
        this.setupTime = datanodeDetails.setupTime;
        this.revision = datanodeDetails.revision;
        this.buildDate = datanodeDetails.buildDate;
        this.persistedOpState = datanodeDetails.getPersistedOpState();
        this.persistedOpStateExpiryEpochSec = datanodeDetails.getPersistedOpStateExpiryEpochSec();
        this.initialVersion = datanodeDetails.getInitialVersion();
        this.currentVersion = datanodeDetails.getCurrentVersion();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUuidString() {
        return this.uuidString;
    }

    public void setIpAddress(String ip) {
        this.ipAddress = ip;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(Port port) {
        this.ports.remove(port);
        this.ports.add(port);
    }

    public void setPort(Port.Name name, int port) {
        this.setPort(new Port(name, port));
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public HddsProtos.NodeOperationalState getPersistedOpState() {
        if (this.persistedOpState == null) {
            return HddsProtos.NodeOperationalState.IN_SERVICE;
        }
        return this.persistedOpState;
    }

    public void setPersistedOpState(HddsProtos.NodeOperationalState state) {
        this.persistedOpState = state;
    }

    public long getPersistedOpStateExpiryEpochSec() {
        return this.persistedOpStateExpiryEpochSec;
    }

    public void setPersistedOpStateExpiryEpochSec(long expiry) {
        this.persistedOpStateExpiryEpochSec = expiry;
    }

    public Port getPort(Port.Name name) {
        for (Port port : this.ports) {
            if (!port.getName().equals((Object)name)) continue;
            return port;
        }
        if (name == Port.Name.RATIS_ADMIN || name == Port.Name.RATIS_SERVER) {
            return this.getPort(Port.Name.RATIS);
        }
        return null;
    }

    public static Builder newBuilder(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        Builder builder = DatanodeDetails.newBuilder();
        if (datanodeDetailsProto.hasUuid128()) {
            HddsProtos.UUID uuid = datanodeDetailsProto.getUuid128();
            builder.setUuid(new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits()));
        } else if (datanodeDetailsProto.hasUuid()) {
            builder.setUuid(UUID.fromString(datanodeDetailsProto.getUuid()));
        }
        if (datanodeDetailsProto.hasIpAddress()) {
            builder.setIpAddress(datanodeDetailsProto.getIpAddress());
        }
        if (datanodeDetailsProto.hasHostName()) {
            builder.setHostName(datanodeDetailsProto.getHostName());
        }
        if (datanodeDetailsProto.hasCertSerialId()) {
            builder.setCertSerialId(datanodeDetailsProto.getCertSerialId());
        }
        for (HddsProtos.Port port : datanodeDetailsProto.getPortsList()) {
            try {
                builder.addPort(Port.fromProto(port));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (datanodeDetailsProto.hasNetworkName()) {
            builder.setNetworkName(datanodeDetailsProto.getNetworkName());
        }
        if (datanodeDetailsProto.hasNetworkLocation()) {
            builder.setNetworkLocation(datanodeDetailsProto.getNetworkLocation());
        }
        if (datanodeDetailsProto.hasPersistedOpState()) {
            builder.setPersistedOpState(datanodeDetailsProto.getPersistedOpState());
        }
        if (datanodeDetailsProto.hasPersistedOpStateExpiry()) {
            builder.setPersistedOpStateExpiry(datanodeDetailsProto.getPersistedOpStateExpiry());
        }
        return builder;
    }

    public static DatanodeDetails getFromProtoBuf(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        return DatanodeDetails.newBuilder(datanodeDetailsProto).build();
    }

    public static DatanodeDetails getFromProtoBuf(HddsProtos.ExtendedDatanodeDetailsProto extendedDetailsProto) {
        Builder builder = extendedDetailsProto.hasDatanodeDetails() ? DatanodeDetails.newBuilder(extendedDetailsProto.getDatanodeDetails()) : DatanodeDetails.newBuilder();
        if (extendedDetailsProto.hasVersion()) {
            builder.setVersion(extendedDetailsProto.getVersion());
        }
        if (extendedDetailsProto.hasSetupTime()) {
            builder.setSetupTime(extendedDetailsProto.getSetupTime());
        }
        if (extendedDetailsProto.hasRevision()) {
            builder.setRevision(extendedDetailsProto.getRevision());
        }
        if (extendedDetailsProto.hasBuildDate()) {
            builder.setBuildDate(extendedDetailsProto.getBuildDate());
        }
        return builder.build();
    }

    @JsonIgnore
    public HddsProtos.DatanodeDetailsProto getProtoBufMessage() {
        return this.toProto(1);
    }

    public HddsProtos.DatanodeDetailsProto toProto(int clientVersion) {
        return this.toProtoBuilder(clientVersion).build();
    }

    public HddsProtos.DatanodeDetailsProto.Builder toProtoBuilder(int clientVersion) {
        HddsProtos.UUID uuid128 = HddsProtos.UUID.newBuilder().setMostSigBits(this.uuid.getMostSignificantBits()).setLeastSigBits(this.uuid.getLeastSignificantBits()).build();
        HddsProtos.DatanodeDetailsProto.Builder builder = HddsProtos.DatanodeDetailsProto.newBuilder().setUuid128(uuid128);
        builder.setUuid(this.getUuidString());
        if (this.ipAddress != null) {
            builder.setIpAddress(this.ipAddress);
        }
        if (this.hostName != null) {
            builder.setHostName(this.hostName);
        }
        if (this.certSerialId != null) {
            builder.setCertSerialId(this.certSerialId);
        }
        if (!Strings.isNullOrEmpty((String)this.getNetworkName())) {
            builder.setNetworkName(this.getNetworkName());
        }
        if (!Strings.isNullOrEmpty((String)this.getNetworkLocation())) {
            builder.setNetworkLocation(this.getNetworkLocation());
        }
        if (this.persistedOpState != null) {
            builder.setPersistedOpState(this.persistedOpState);
        }
        builder.setPersistedOpStateExpiry(this.persistedOpStateExpiryEpochSec);
        boolean handlesUnknownPorts = clientVersion >= 1;
        for (Port port : this.ports) {
            if (handlesUnknownPorts || Port.Name.V0_PORTS.contains((Object)port.getName())) {
                builder.addPorts(port.toProto());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skip adding {} port {} to proto message for client v{}", new Object[]{port.getName(), port.getValue(), clientVersion});
        }
        return builder;
    }

    @JsonIgnore
    public HddsProtos.ExtendedDatanodeDetailsProto getExtendedProtoBufMessage() {
        HddsProtos.ExtendedDatanodeDetailsProto.Builder extendedBuilder = HddsProtos.ExtendedDatanodeDetailsProto.newBuilder().setDatanodeDetails(this.getProtoBufMessage());
        if (!Strings.isNullOrEmpty((String)this.getVersion())) {
            extendedBuilder.setVersion(this.getVersion());
        }
        extendedBuilder.setSetupTime(this.getSetupTime());
        if (!Strings.isNullOrEmpty((String)this.getRevision())) {
            extendedBuilder.setRevision(this.getRevision());
        }
        if (!Strings.isNullOrEmpty((String)this.getBuildDate())) {
            extendedBuilder.setBuildDate(this.getBuildDate());
        }
        return extendedBuilder.build();
    }

    public int getInitialVersion() {
        return this.initialVersion;
    }

    public void setInitialVersion(int initialVersion) {
        this.initialVersion = initialVersion;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(int currentVersion) {
        this.currentVersion = currentVersion;
    }

    @Override
    public String toString() {
        return this.uuid.toString() + "{ip: " + this.ipAddress + ", host: " + this.hostName + ", ports: " + this.ports + ", networkLocation: " + this.getNetworkLocation() + ", certSerialId: " + this.certSerialId + ", persistedOpState: " + this.persistedOpState + ", persistedOpStateExpiryEpochSec: " + this.persistedOpStateExpiryEpochSec + "}";
    }

    @Override
    public int compareTo(DatanodeDetails that) {
        return this.getUuid().compareTo(that.getUuid());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DatanodeDetails && this.uuid.equals(((DatanodeDetails)obj).uuid);
    }

    @Override
    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Port newPort(Port.Name name, Integer value) {
        return new Port(name, value);
    }

    public String getCertSerialId() {
        return this.certSerialId;
    }

    public void setCertSerialId(String certSerialId) {
        this.certSerialId = certSerialId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getSetupTime() {
        return this.setupTime;
    }

    public void setSetupTime(long setupTime) {
        this.setupTime = setupTime;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String rev) {
        this.revision = rev;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(String date) {
        this.buildDate = date;
    }

    public static final class Port {
        private final Name name;
        private final Integer value;

        private Port(Name name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public Name getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Port) {
                return this.name.equals((Object)((Port)anObject).name);
            }
            return false;
        }

        public String toString() {
            return (Object)((Object)this.name) + "=" + this.value;
        }

        public HddsProtos.Port toProto() {
            return HddsProtos.Port.newBuilder().setName(this.name.name()).setValue(this.value.intValue()).build();
        }

        public static Port fromProto(HddsProtos.Port proto) {
            Name name = Name.valueOf(proto.getName().toUpperCase());
            return new Port(name, proto.getValue());
        }

        public static enum Name {
            STANDALONE,
            RATIS,
            REST,
            REPLICATION,
            RATIS_ADMIN,
            RATIS_SERVER;

            public static final Set<Name> ALL_PORTS;
            public static final Set<Name> V0_PORTS;

            static {
                ALL_PORTS = ImmutableSet.copyOf((Object[])Name.values());
                V0_PORTS = ImmutableSet.copyOf(EnumSet.of(STANDALONE, RATIS, REST));
            }
        }
    }

    public static final class Builder {
        private UUID id;
        private String ipAddress;
        private String hostName;
        private String networkName;
        private String networkLocation;
        private List<Port> ports = new ArrayList<Port>();
        private String certSerialId;
        private String version;
        private long setupTime;
        private String revision;
        private String buildDate;
        private HddsProtos.NodeOperationalState persistedOpState;
        private long persistedOpStateExpiryEpochSec = 0L;
        private int initialVersion;
        private int currentVersion = 1;

        private Builder() {
        }

        public Builder setDatanodeDetails(DatanodeDetails details) {
            this.id = details.getUuid();
            this.ipAddress = details.getIpAddress();
            this.hostName = details.getHostName();
            this.networkName = details.getNetworkName();
            this.networkLocation = details.getNetworkLocation();
            this.ports = details.getPorts();
            this.certSerialId = details.getCertSerialId();
            this.version = details.getVersion();
            this.setupTime = details.getSetupTime();
            this.revision = details.getRevision();
            this.buildDate = details.getBuildDate();
            this.persistedOpState = details.getPersistedOpState();
            this.persistedOpStateExpiryEpochSec = details.getPersistedOpStateExpiryEpochSec();
            return this;
        }

        public Builder setUuid(UUID uuid) {
            this.id = uuid;
            return this;
        }

        public Builder setIpAddress(String ip) {
            this.ipAddress = ip;
            return this;
        }

        public Builder setHostName(String host) {
            this.hostName = host;
            return this;
        }

        public Builder setNetworkName(String name) {
            this.networkName = name;
            return this;
        }

        public Builder setNetworkLocation(String loc) {
            this.networkLocation = loc;
            return this;
        }

        public Builder addPort(Port port) {
            this.ports.add(port);
            return this;
        }

        public Builder setCertSerialId(String certId) {
            this.certSerialId = certId;
            return this;
        }

        public Builder setVersion(String ver) {
            this.version = ver;
            return this;
        }

        public Builder setRevision(String rev) {
            this.revision = rev;
            return this;
        }

        public Builder setBuildDate(String date) {
            this.buildDate = date;
            return this;
        }

        public Builder setSetupTime(long time) {
            this.setupTime = time;
            return this;
        }

        public Builder setPersistedOpState(HddsProtos.NodeOperationalState state) {
            this.persistedOpState = state;
            return this;
        }

        public Builder setPersistedOpStateExpiry(long expiry) {
            this.persistedOpStateExpiryEpochSec = expiry;
            return this;
        }

        public Builder setInitialVersion(int v) {
            this.initialVersion = v;
            return this;
        }

        public Builder setCurrentVersion(int v) {
            this.currentVersion = v;
            return this;
        }

        public DatanodeDetails build() {
            Preconditions.checkNotNull((Object)this.id);
            if (this.networkLocation == null) {
                this.networkLocation = "/default-rack";
            }
            DatanodeDetails dn = new DatanodeDetails(this.id, this.ipAddress, this.hostName, this.networkLocation, this.ports, this.certSerialId, this.version, this.setupTime, this.revision, this.buildDate, this.persistedOpState, this.persistedOpStateExpiryEpochSec, this.initialVersion, this.currentVersion);
            if (this.networkName != null) {
                dn.setNetworkName(this.networkName);
            }
            return dn;
        }
    }
}

