/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight.scm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.ozone.insight.BaseInsightPoint;
import org.apache.hadoop.ozone.insight.Component;
import org.apache.hadoop.ozone.insight.LoggerSource;
import org.apache.hadoop.ozone.insight.MetricDisplay;
import org.apache.hadoop.ozone.insight.MetricGroupDisplay;

public class NodeManagerInsight
extends BaseInsightPoint {
    @Override
    public List<LoggerSource> getRelatedLoggers(boolean verbose, Map<String, String> filters) {
        ArrayList<LoggerSource> loggers = new ArrayList<LoggerSource>();
        loggers.add(new LoggerSource(Component.Type.SCM, SCMNodeManager.class, this.defaultLevel(verbose)));
        return loggers;
    }

    @Override
    public List<MetricGroupDisplay> getMetrics(Map<String, String> filters) {
        ArrayList<MetricGroupDisplay> display = new ArrayList<MetricGroupDisplay>();
        MetricGroupDisplay nodes = new MetricGroupDisplay(Component.Type.SCM, "Node counters");
        nodes.addMetrics(new MetricDisplay("Healthy Nodes", "scm_node_manager_healthy_nodes"));
        nodes.addMetrics(new MetricDisplay("Dead Nodes", "scm_node_manager_dead_nodes"));
        display.add(nodes);
        MetricGroupDisplay hb = new MetricGroupDisplay(Component.Type.SCM, "HB processing stats");
        hb.addMetrics(new MetricDisplay("HB processed", "scm_node_manager_num_hb_processed"));
        hb.addMetrics(new MetricDisplay("HB processing failed", "scm_node_manager_num_hb_processing_failed"));
        display.add(hb);
        return display;
    }

    @Override
    public String getDescription() {
        return "SCM Datanode management related information.";
    }
}

