/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight;

import java.util.Objects;

public class Component {
    private Type name;
    private String id;
    private String hostname;
    private int port;

    public Component(Type name) {
        this.name = name;
    }

    public Component(Type name, String id) {
        this.name = name;
        this.id = id;
    }

    public Component(Type name, String id, String hostname) {
        this.name = name;
        this.id = id;
        this.hostname = hostname;
    }

    public Component(Type name, String id, String hostname, int port) {
        this.name = name;
        this.id = id;
        this.hostname = hostname;
        this.port = port;
    }

    public Type getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component that = (Component)o;
        return Objects.equals((Object)this.name, (Object)that.name) && Objects.equals(this.id, that.id);
    }

    public String prefix() {
        return (Object)((Object)this.name) + (this.id != null && this.id.length() > 0 ? "-" + this.id : "");
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.id});
    }

    public static enum Type {
        SCM,
        OM,
        DATANODE,
        S3G,
        RECON;

    }
}

