#!/usr/bin/env bash

#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

set -e

cat > ${GITHUB_WORKSPACE}/common/scala/src/main/resources/reference.conf << EOL
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

include "s3-reference.conf"

whisk.spi {
  ArtifactStoreProvider = org.apache.openwhisk.core.database.CouchDbStoreProvider
  ActivationStoreProvider = org.apache.openwhisk.core.database.ArtifactActivationStoreProvider
  MessagingProvider = org.apache.openwhisk.connector.kafka.KafkaMessagingProvider
  ContainerFactoryProvider = org.apache.openwhisk.core.containerpool.docker.DockerContainerFactoryProvider
  LogStoreProvider = org.apache.openwhisk.core.containerpool.logging.DockerToActivationLogStoreProvider
  LoadBalancerProvider = org.apache.openwhisk.core.loadBalancer.ShardingContainerPoolBalancer
  EntitlementSpiProvider = org.apache.openwhisk.core.entitlement.LocalEntitlementProvider
  AuthenticationDirectiveProvider = org.apache.openwhisk.core.controller.BasicAuthenticationDirective
  InvokerProvider = org.apache.openwhisk.core.invoker.InvokerReactive
  InvokerServerProvider = org.apache.openwhisk.core.invoker.DefaultInvokerServer
  DurationCheckerProvider = org.apache.openwhisk.core.scheduler.queue.NoopDurationCheckerProvider
}

dispatchers {
  # Custom dispatcher for CouchDB Client. Tune as needed.
  couch-dispatcher {
    type = Dispatcher
    executor = "thread-pool-executor"

    # Underlying thread pool implementation is java.util.concurrent.ThreadPoolExecutor
    thread-pool-executor {
      # Min number of threads to cap factor-based corePoolSize number to
      core-pool-size-min = 2

      # The core-pool-size-factor is used to determine corePoolSize of the
      # ThreadPoolExecutor using the following formula:
      # ceil(available processors * factor).
      # Resulting size is then bounded by the core-pool-size-min and
      # core-pool-size-max values.
      core-pool-size-factor = 2.0

      # Max number of threads to cap factor-based corePoolSize number to
      core-pool-size-max = 32
    }
    # Throughput defines the number of messages that are processed in a batch
    # before the thread is returned to the pool. Set to 1 for as fair as possible.
    throughput = 5
  }

  # Custom dispatcher for Kafka client. Tune as needed.
  kafka-dispatcher {
    type = Dispatcher
    executor = "thread-pool-executor"

    # Underlying thread pool implementation is java.util.concurrent.ThreadPoolExecutor
    thread-pool-executor {
      # Min number of threads to cap factor-based corePoolSize number to
      core-pool-size-min = 2

      # The core-pool-size-factor is used to determine corePoolSize of the
      # ThreadPoolExecutor using the following formula:
      # ceil(available processors * factor).
      # Resulting size is then bounded by the core-pool-size-min and
      # core-pool-size-max values.
      core-pool-size-factor = 2.0

      # Max number of threads to cap factor-based corePoolSize number to
      core-pool-size-max = 32
    }

    # Throughput defines the number of messages that are processed in a batch
    # before the thread is returned to the pool. Set to 1 for as fair as possible.
    throughput = 5
  }
  lease-service-dispatcher {
    type = PinnedDispatcher
    executor = "thread-pool-executor"
  }
}
EOL
