/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.meecrowave;

import org.apache.cxf.helpers.FileUtils;
import org.apache.meecrowave.io.IO;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import static org.junit.Assert.fail;

// some in memory files to avoid to load them from the classpath and have tests working by luck (classpath leak actually)
// see meecrowave-core/src/test/third-party for sources
public class Classes {
    private static final byte[] OTHER_FILTER = new byte[]{
            -54,
            -2, -70, -66, 0, 0, 0, 52, 0, 75, 10,
            0, 12, 0, 46, 11, 0, 47, 0, 48, 7,
            0, 49, 10, 0, 3, 0, 46, 8, 0, 50,
            10, 0, 3, 0, 51, 9, 0, 11, 0, 52,
            10, 0, 53, 0, 54, 10, 0, 3, 0, 55,
            10, 0, 56, 0, 57, 7, 0, 58, 7, 0,
            59, 7, 0, 60, 1, 0, 10, 105, 110, 106,
            101, 99, 116, 97, 98, 108, 101, 1, 0, 29,
            76, 111, 114, 103, 47, 115, 117, 112, 101, 114,
            98, 105, 122, 47, 97, 112, 112, 47, 73, 110,
            106, 101, 99, 116, 97, 98, 108, 101, 59, 1,
            0, 25, 82, 117, 110, 116, 105, 109, 101, 86,
            105, 115, 105, 98, 108, 101, 65, 110, 110, 111,
            116, 97, 116, 105, 111, 110, 115, 1, 0, 21,
            76, 106, 97, 118, 97, 120, 47, 105, 110, 106,
            101, 99, 116, 47, 73, 110, 106, 101, 99, 116,
            59, 1, 0, 6, 60, 105, 110, 105, 116, 62,
            1, 0, 3, 40, 41, 86, 1, 0, 4, 67,
            111, 100, 101, 1, 0, 15, 76, 105, 110, 101,
            78, 117, 109, 98, 101, 114, 84, 97, 98, 108,
            101, 1, 0, 18, 76, 111, 99, 97, 108, 86,
            97, 114, 105, 97, 98, 108, 101, 84, 97, 98,
            108, 101, 1, 0, 4, 116, 104, 105, 115, 1,
            0, 30, 76, 111, 114, 103, 47, 115, 117, 112,
            101, 114, 98, 105, 122, 47, 97, 112, 112, 47,
            79, 116, 104, 101, 114, 70, 105, 108, 116, 101,
            114, 59, 1, 0, 4, 105, 110, 105, 116, 1,
            0, 31, 40, 76, 106, 97, 118, 97, 120, 47,
            115, 101, 114, 118, 108, 101, 116, 47, 70, 105,
            108, 116, 101, 114, 67, 111, 110, 102, 105, 103,
            59, 41, 86, 1, 0, 12, 102, 105, 108, 116,
            101, 114, 67, 111, 110, 102, 105, 103, 1, 0,
            28, 76, 106, 97, 118, 97, 120, 47, 115, 101,
            114, 118, 108, 101, 116, 47, 70, 105, 108, 116,
            101, 114, 67, 111, 110, 102, 105, 103, 59, 1,
            0, 10, 69, 120, 99, 101, 112, 116, 105, 111,
            110, 115, 7, 0, 61, 1, 0, 8, 100, 111,
            70, 105, 108, 116, 101, 114, 1, 0, 91, 40,
            76, 106, 97, 118, 97, 120, 47, 115, 101, 114,
            118, 108, 101, 116, 47, 83, 101, 114, 118, 108,
            101, 116, 82, 101, 113, 117, 101, 115, 116, 59,
            76, 106, 97, 118, 97, 120, 47, 115, 101, 114,
            118, 108, 101, 116, 47, 83, 101, 114, 118, 108,
            101, 116, 82, 101, 115, 112, 111, 110, 115, 101,
            59, 76, 106, 97, 118, 97, 120, 47, 115, 101,
            114, 118, 108, 101, 116, 47, 70, 105, 108, 116,
            101, 114, 67, 104, 97, 105, 110, 59, 41, 86,
            1, 0, 7, 114, 101, 113, 117, 101, 115, 116,
            1, 0, 30, 76, 106, 97, 118, 97, 120, 47,
            115, 101, 114, 118, 108, 101, 116, 47, 83, 101,
            114, 118, 108, 101, 116, 82, 101, 113, 117, 101,
            115, 116, 59, 1, 0, 8, 114, 101, 115, 112,
            111, 110, 115, 101, 1, 0, 31, 76, 106, 97,
            118, 97, 120, 47, 115, 101, 114, 118, 108, 101,
            116, 47, 83, 101, 114, 118, 108, 101, 116, 82,
            101, 115, 112, 111, 110, 115, 101, 59, 1, 0,
            5, 99, 104, 97, 105, 110, 1, 0, 27, 76,
            106, 97, 118, 97, 120, 47, 115, 101, 114, 118,
            108, 101, 116, 47, 70, 105, 108, 116, 101, 114,
            67, 104, 97, 105, 110, 59, 7, 0, 62, 1,
            0, 7, 100, 101, 115, 116, 114, 111, 121, 1,
            0, 10, 83, 111, 117, 114, 99, 101, 70, 105,
            108, 101, 1, 0, 16, 79, 116, 104, 101, 114,
            70, 105, 108, 116, 101, 114, 46, 106, 97, 118,
            97, 1, 0, 36, 76, 106, 97, 118, 97, 120,
            47, 115, 101, 114, 118, 108, 101, 116, 47, 97,
            110, 110, 111, 116, 97, 116, 105, 111, 110, 47,
            87, 101, 98, 70, 105, 108, 116, 101, 114, 59,
            1, 0, 5, 118, 97, 108, 117, 101, 1, 0,
            6, 47, 111, 116, 104, 101, 114, 12, 0, 18,
            0, 19, 7, 0, 63, 12, 0, 64, 0, 65,
            1, 0, 23, 106, 97, 118, 97, 47, 108, 97,
            110, 103, 47, 83, 116, 114, 105, 110, 103, 66,
            117, 105, 108, 100, 101, 114, 1, 0, 6, 102,
            105, 108, 116, 101, 114, 12, 0, 66, 0, 67,
            12, 0, 14, 0, 15, 7, 0, 68, 12, 0,
            69, 0, 70, 12, 0, 71, 0, 70, 7, 0,
            72, 12, 0, 73, 0, 74, 1, 0, 28, 111,
            114, 103, 47, 115, 117, 112, 101, 114, 98, 105,
            122, 47, 97, 112, 112, 47, 79, 116, 104, 101,
            114, 70, 105, 108, 116, 101, 114, 1, 0, 16,
            106, 97, 118, 97, 47, 108, 97, 110, 103, 47,
            79, 98, 106, 101, 99, 116, 1, 0, 20, 106,
            97, 118, 97, 120, 47, 115, 101, 114, 118, 108,
            101, 116, 47, 70, 105, 108, 116, 101, 114, 1,
            0, 30, 106, 97, 118, 97, 120, 47, 115, 101,
            114, 118, 108, 101, 116, 47, 83, 101, 114, 118,
            108, 101, 116, 69, 120, 99, 101, 112, 116, 105,
            111, 110, 1, 0, 19, 106, 97, 118, 97, 47,
            105, 111, 47, 73, 79, 69, 120, 99, 101, 112,
            116, 105, 111, 110, 1, 0, 29, 106, 97, 118,
            97, 120, 47, 115, 101, 114, 118, 108, 101, 116,
            47, 83, 101, 114, 118, 108, 101, 116, 82, 101,
            115, 112, 111, 110, 115, 101, 1, 0, 9, 103,
            101, 116, 87, 114, 105, 116, 101, 114, 1, 0,
            23, 40, 41, 76, 106, 97, 118, 97, 47, 105,
            111, 47, 80, 114, 105, 110, 116, 87, 114, 105,
            116, 101, 114, 59, 1, 0, 6, 97, 112, 112,
            101, 110, 100, 1, 0, 45, 40, 76, 106, 97,
            118, 97, 47, 108, 97, 110, 103, 47, 83, 116,
            114, 105, 110, 103, 59, 41, 76, 106, 97, 118,
            97, 47, 108, 97, 110, 103, 47, 83, 116, 114,
            105, 110, 103, 66, 117, 105, 108, 100, 101, 114,
            59, 1, 0, 27, 111, 114, 103, 47, 115, 117,
            112, 101, 114, 98, 105, 122, 47, 97, 112, 112,
            47, 73, 110, 106, 101, 99, 116, 97, 98, 108,
            101, 1, 0, 8, 105, 110, 106, 101, 99, 116,
            101, 100, 1, 0, 20, 40, 41, 76, 106, 97,
            118, 97, 47, 108, 97, 110, 103, 47, 83, 116,
            114, 105, 110, 103, 59, 1, 0, 8, 116, 111,
            83, 116, 114, 105, 110, 103, 1, 0, 19, 106,
            97, 118, 97, 47, 105, 111, 47, 80, 114, 105,
            110, 116, 87, 114, 105, 116, 101, 114, 1, 0,
            5, 119, 114, 105, 116, 101, 1, 0, 21, 40,
            76, 106, 97, 118, 97, 47, 108, 97, 110, 103,
            47, 83, 116, 114, 105, 110, 103, 59, 41, 86,
            0, 33, 0, 11, 0, 12, 0, 1, 0, 13,
            0, 1, 0, 2, 0, 14, 0, 15, 0, 1,
            0, 16, 0, 0, 0, 6, 0, 1, 0, 17,
            0, 0, 0, 4, 0, 1, 0, 18, 0, 19,
            0, 1, 0, 20, 0, 0, 0, 47, 0, 1,
            0, 1, 0, 0, 0, 5, 42, -73, 0, 1,
            -79, 0, 0, 0, 2, 0, 21, 0, 0, 0,
            6, 0, 1, 0, 0, 0, 32, 0, 22, 0,
            0, 0, 12, 0, 1, 0, 0, 0, 5, 0,
            23, 0, 24, 0, 0, 0, 1, 0, 25, 0,
            26, 0, 2, 0, 20, 0, 0, 0, 53, 0,
            0, 0, 2, 0, 0, 0, 1, -79, 0, 0,
            0, 2, 0, 21, 0, 0, 0, 6, 0, 1,
            0, 0, 0, 39, 0, 22, 0, 0, 0, 22,
            0, 2, 0, 0, 0, 1, 0, 23, 0, 24,
            0, 0, 0, 0, 0, 1, 0, 27, 0, 28,
            0, 1, 0, 29, 0, 0, 0, 4, 0, 1,
            0, 30, 0, 1, 0, 31, 0, 32, 0, 2,
            0, 20, 0, 0, 0, 111, 0, 3, 0, 4,
            0, 0, 0, 35, 44, -71, 0, 2, 1, 0,
            -69, 0, 3, 89, -73, 0, 4, 18, 5, -74,
            0, 6, 42, -76, 0, 7, -74, 0, 8, -74,
            0, 6, -74, 0, 9, -74, 0, 10, -79, 0,
            0, 0, 2, 0, 21, 0, 0, 0, 10, 0,
            2, 0, 0, 0, 43, 0, 34, 0, 44, 0,
            22, 0, 0, 0, 42, 0, 4, 0, 0, 0,
            35, 0, 23, 0, 24, 0, 0, 0, 0, 0,
            35, 0, 33, 0, 34, 0, 1, 0, 0, 0,
            35, 0, 35, 0, 36, 0, 2, 0, 0, 0,
            35, 0, 37, 0, 38, 0, 3, 0, 29, 0,
            0, 0, 6, 0, 2, 0, 39, 0, 30, 0,
            1, 0, 40, 0, 19, 0, 1, 0, 20, 0,
            0, 0, 43, 0, 0, 0, 1, 0, 0, 0,
            1, -79, 0, 0, 0, 2, 0, 21, 0, 0,
            0, 6, 0, 1, 0, 0, 0, 49, 0, 22,
            0, 0, 0, 12, 0, 1, 0, 0, 0, 1,
            0, 23, 0, 24, 0, 0, 0, 2, 0, 41,
            0, 0, 0, 2, 0, 42, 0, 16, 0, 0,
            0, 14, 0, 1, 0, 43, 0, 1, 0, 44,
            91, 0, 1, 115, 0, 45
    };
    private static final byte[] OTHER_ENDPOINT = new byte[]{
            -54,
            -2, -70, -66, 0, 0, 0, 52, 0, 48, 10,
            0, 8, 0, 33, 9, 0, 7, 0, 34, 10,
            0, 35, 0, 36, 10, 0, 37, 0, 38, 8,
            0, 20, 8, 0, 39, 7, 0, 40, 7, 0,
            41, 1, 0, 10, 105, 110, 106, 101, 99, 116,
            97, 98, 108, 101, 1, 0, 29, 76, 111, 114,
            103, 47, 115, 117, 112, 101, 114, 98, 105, 122,
            47, 97, 112, 112, 47, 73, 110, 106, 101, 99,
            116, 97, 98, 108, 101, 59, 1, 0, 25, 82,
            117, 110, 116, 105, 109, 101, 86, 105, 115, 105,
            98, 108, 101, 65, 110, 110, 111, 116, 97, 116,
            105, 111, 110, 115, 1, 0, 21, 76, 106, 97,
            118, 97, 120, 47, 105, 110, 106, 101, 99, 116,
            47, 73, 110, 106, 101, 99, 116, 59, 1, 0,
            6, 60, 105, 110, 105, 116, 62, 1, 0, 3,
            40, 41, 86, 1, 0, 4, 67, 111, 100, 101,
            1, 0, 15, 76, 105, 110, 101, 78, 117, 109,
            98, 101, 114, 84, 97, 98, 108, 101, 1, 0,
            18, 76, 111, 99, 97, 108, 86, 97, 114, 105,
            97, 98, 108, 101, 84, 97, 98, 108, 101, 1,
            0, 4, 116, 104, 105, 115, 1, 0, 32, 76,
            111, 114, 103, 47, 115, 117, 112, 101, 114, 98,
            105, 122, 47, 97, 112, 112, 47, 79, 116, 104,
            101, 114, 69, 110, 100, 112, 111, 105, 110, 116,
            59, 1, 0, 6, 115, 105, 109, 112, 108, 101,
            1, 0, 20, 40, 41, 76, 106, 97, 118, 97,
            47, 108, 97, 110, 103, 47, 83, 116, 114, 105,
            110, 103, 59, 1, 0, 13, 83, 116, 97, 99,
            107, 77, 97, 112, 84, 97, 98, 108, 101, 7,
            0, 42, 1, 0, 17, 76, 106, 97, 118, 97,
            120, 47, 119, 115, 47, 114, 115, 47, 71, 69,
            84, 59, 1, 0, 22, 76, 106, 97, 118, 97,
            120, 47, 119, 115, 47, 114, 115, 47, 80, 114,
            111, 100, 117, 99, 101, 115, 59, 1, 0, 5,
            118, 97, 108, 117, 101, 1, 0, 10, 116, 101,
            120, 116, 47, 112, 108, 97, 105, 110, 1, 0,
            10, 83, 111, 117, 114, 99, 101, 70, 105, 108,
            101, 1, 0, 18, 79, 116, 104, 101, 114, 69,
            110, 100, 112, 111, 105, 110, 116, 46, 106, 97,
            118, 97, 1, 0, 18, 76, 106, 97, 118, 97,
            120, 47, 119, 115, 47, 114, 115, 47, 80, 97,
            116, 104, 59, 1, 0, 5, 111, 116, 104, 101,
            114, 1, 0, 44, 76, 106, 97, 118, 97, 120,
            47, 101, 110, 116, 101, 114, 112, 114, 105, 115,
            101, 47, 99, 111, 110, 116, 101, 120, 116, 47,
            65, 112, 112, 108, 105, 99, 97, 116, 105, 111,
            110, 83, 99, 111, 112, 101, 100, 59, 12, 0,
            13, 0, 14, 12, 0, 9, 0, 10, 7, 0,
            43, 12, 0, 44, 0, 21, 7, 0, 45, 12,
            0, 46, 0, 47, 1, 0, 4, 102, 97, 105,
            108, 1, 0, 30, 111, 114, 103, 47, 115, 117,
            112, 101, 114, 98, 105, 122, 47, 97, 112, 112,
            47, 79, 116, 104, 101, 114, 69, 110, 100, 112,
            111, 105, 110, 116, 1, 0, 16, 106, 97, 118,
            97, 47, 108, 97, 110, 103, 47, 79, 98, 106,
            101, 99, 116, 1, 0, 16, 106, 97, 118, 97,
            47, 108, 97, 110, 103, 47, 83, 116, 114, 105,
            110, 103, 1, 0, 27, 111, 114, 103, 47, 115,
            117, 112, 101, 114, 98, 105, 122, 47, 97, 112,
            112, 47, 73, 110, 106, 101, 99, 116, 97, 98,
            108, 101, 1, 0, 8, 105, 110, 106, 101, 99,
            116, 101, 100, 1, 0, 17, 106, 97, 118, 97,
            47, 108, 97, 110, 103, 47, 66, 111, 111, 108,
            101, 97, 110, 1, 0, 12, 112, 97, 114, 115,
            101, 66, 111, 111, 108, 101, 97, 110, 1, 0,
            21, 40, 76, 106, 97, 118, 97, 47, 108, 97,
            110, 103, 47, 83, 116, 114, 105, 110, 103, 59,
            41, 90, 0, 33, 0, 7, 0, 8, 0, 0,
            0, 1, 0, 2, 0, 9, 0, 10, 0, 1,
            0, 11, 0, 0, 0, 6, 0, 1, 0, 12,
            0, 0, 0, 2, 0, 1, 0, 13, 0, 14,
            0, 1, 0, 15, 0, 0, 0, 47, 0, 1,
            0, 1, 0, 0, 0, 5, 42, -73, 0, 1,
            -79, 0, 0, 0, 2, 0, 16, 0, 0, 0,
            6, 0, 1, 0, 0, 0, 30, 0, 17, 0,
            0, 0, 12, 0, 1, 0, 0, 0, 5, 0,
            18, 0, 19, 0, 0, 0, 1, 0, 20, 0,
            21, 0, 2, 0, 15, 0, 0, 0, 76, 0,
            1, 0, 1, 0, 0, 0, 21, 42, -76, 0,
            2, -74, 0, 3, -72, 0, 4, -103, 0, 8,
            18, 5, -89, 0, 5, 18, 6, -80, 0, 0,
            0, 3, 0, 16, 0, 0, 0, 6, 0, 1,
            0, 0, 0, 37, 0, 17, 0, 0, 0, 12,
            0, 1, 0, 0, 0, 21, 0, 18, 0, 19,
            0, 0, 0, 22, 0, 0, 0, 7, 0, 2,
            18, 65, 7, 0, 23, 0, 11, 0, 0, 0,
            18, 0, 2, 0, 24, 0, 0, 0, 25, 0,
            1, 0, 26, 91, 0, 1, 115, 0, 27, 0,
            2, 0, 28, 0, 0, 0, 2, 0, 29, 0,
            11, 0, 0, 0, 15, 0, 2, 0, 30, 0,
            1, 0, 26, 115, 0, 31, 0, 32, 0, 0
    };

    public static void dump(final File file) {
        doDump(file, "OtherEndpoint", OTHER_ENDPOINT);
        doDump(file, "OtherFilter", OTHER_FILTER);
    }

    private static void doDump(final File base, final String name, final byte[] content) {
        final String target = "org/superbiz/app/" + name + ".class";
        final File targetFile = new File(base, target);
        FileUtils.mkDir(targetFile.getParentFile());
        try (final InputStream from = new ByteArrayInputStream(content);
             final OutputStream to = new FileOutputStream(targetFile)) {
            IO.copy(from, to);
        } catch (final IOException e) {
            fail();
        }
    }
}
