/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELUtils;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionFactory {
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "org.apache.el.ExpressionFactoryImpl";
    private static final String SYSTEM_PROPERTY_NAME = "javax.el.ExpressionFactory";
    private static final String JAVA_RUNTIME_PROPERTY_FILE_LOCATION = "lib" + File.separator + "el.properties";

    public abstract Object coerceToType(Object var1, Class<?> var2) throws ELException;

    public abstract ValueExpression createValueExpression(ELContext var1, String var2, Class<?> var3) throws NullPointerException, ELException;

    public abstract ValueExpression createValueExpression(Object var1, Class<?> var2);

    public abstract MethodExpression createMethodExpression(ELContext var1, String var2, Class<?> var3, Class<?>[] var4) throws ELException, NullPointerException;

    public static ExpressionFactory newInstance() {
        return ExpressionFactory.newInstance(null);
    }

    public static ExpressionFactory newInstance(Properties properties) {
        ExpressionFactory factory = ExpressionFactory.loadExpressionFactoryImpl();
        if (properties == null) {
            return factory;
        }
        try {
            Constructor<?> constructor = factory.getClass().getConstructor(Properties.class);
            try {
                return (ExpressionFactory)constructor.newInstance(properties);
            }
            catch (IllegalArgumentException e) {
                throw new ELException("Fail to create ExpressionFactory instance", e);
            }
            catch (InstantiationException e) {
                throw new ELException("Fail to create ExpressionFactory instance", e);
            }
            catch (IllegalAccessException e) {
                throw new ELException("Fail to create ExpressionFactory instance", e);
            }
            catch (InvocationTargetException e) {
                throw new ELException("Fail to create ExpressionFactory instance", e);
            }
        }
        catch (SecurityException e) {
            throw new ELException("Fail to get constuctor from ExpressionFactory implementation class", e);
        }
        catch (NoSuchMethodException e) {
            return factory;
        }
    }

    private static ExpressionFactory newInstance0(Class<?> implClass) {
        try {
            return (ExpressionFactory)implClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ELException("Fail to create ExpressionFactory instance", e);
        }
        catch (InstantiationException e) {
            throw new ELException("Fail to create ExpressionFactory instance", e);
        }
    }

    private static ExpressionFactory lookupExpressionFactoryImpl(ClassLoader cl) throws ClassNotFoundException {
        String implClassName = ExpressionFactory.lookupByJREPropertyFile();
        if (implClassName == null && (implClassName = System.getProperty(SYSTEM_PROPERTY_NAME)) == null) {
            implClassName = PLATFORM_DEFAULT_FACTORY_CLASS;
        }
        return ExpressionFactory.newInstance0(cl.loadClass(implClassName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExpressionFactory lookupByServiceEntryURL(ClassLoader cl) throws ClassNotFoundException {
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(cl);
            Iterator<ExpressionFactory> iterator = ServiceLoader.load(ExpressionFactory.class).iterator();
            if (iterator.hasNext()) {
                ExpressionFactory factory;
                ExpressionFactory expressionFactory = factory = iterator.next();
                return expressionFactory;
            }
        }
        finally {
            thread.setContextClassLoader(original);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String lookupByJREPropertyFile() {
        String string;
        String jreDirectory = System.getProperty("java.home");
        File configurationFile = new File(jreDirectory + File.separator + JAVA_RUNTIME_PROPERTY_FILE_LOCATION);
        if (!configurationFile.exists() || !configurationFile.canRead()) return null;
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(configurationFile);
            properties.load(in);
            string = properties.getProperty(SYSTEM_PROPERTY_NAME);
            if (in == null) return string;
        }
        catch (Throwable throwable) {
            try {
                if (in == null) throw throwable;
                try {
                    ((InputStream)in).close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ELException("Fail to read configuration file", e);
            }
        }
        try {
            ((InputStream)in).close();
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static ExpressionFactory loadExpressionFactoryImpl() {
        try {
            ExpressionFactory factory;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            if ((factory = ExpressionFactory.lookupByServiceEntryURL(cl)) != null) {
                return factory;
            }
            return ExpressionFactory.lookupExpressionFactoryImpl(cl);
        }
        catch (ClassNotFoundException e) {
            throw new ELException("Fail to load implementation class", e);
        }
    }

    static {
        try {
            ELUtils.setCachedExpressionFactory(ExpressionFactory.newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

