/*
 * Decompiled with CFR 0.152.
 */
package opennlp.morfologik.tagdict;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryMetadata;
import opennlp.morfologik.tagdict.MorfologikTagDictionary;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.ByteArraySerializer;

public class MorfologikPOSTaggerFactory
extends POSTaggerFactory {
    private static final String MORFOLOGIK_POSDICT_SUF = "morfologik_dict";
    private static final String MORFOLOGIK_DICT_INFO_SUF = "morfologik_info";
    private static final String MORFOLOGIK_POSDICT = "tagdict.morfologik_dict";
    private static final String MORFOLOGIK_DICT_INFO = "tagdict.morfologik_info";
    private TagDictionary dict;
    private byte[] dictInfo;
    private byte[] dictData;

    public TagDictionary createTagDictionary(File dictionary) throws IOException {
        if (!dictionary.canRead()) {
            throw new FileNotFoundException("Could not read dictionary: " + dictionary.getAbsolutePath());
        }
        Path dictionaryMeta = DictionaryMetadata.getExpectedMetadataLocation((Path)dictionary.toPath());
        if (dictionaryMeta == null || !dictionaryMeta.toFile().canRead()) {
            throw new FileNotFoundException("Could not read dictionary metadata: " + dictionaryMeta.getFileName());
        }
        this.dictData = Files.readAllBytes(dictionary.toPath());
        this.dictInfo = Files.readAllBytes(dictionaryMeta);
        return this.createMorfologikDictionary(this.dictData, this.dictInfo);
    }

    public TagDictionary getTagDictionary() {
        Object obj;
        if (this.dict == null && this.artifactProvider != null && (obj = this.artifactProvider.getArtifact(MORFOLOGIK_POSDICT)) != null) {
            byte[] data = (byte[])this.artifactProvider.getArtifact(MORFOLOGIK_POSDICT);
            byte[] info = (byte[])this.artifactProvider.getArtifact(MORFOLOGIK_DICT_INFO);
            try {
                this.dict = this.createMorfologikDictionary(data, info);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Could not load the dictionary files to Morfologik.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("IO error while reading the Morfologik dictionary files.", e);
            }
        }
        return this.dict;
    }

    public void setTagDictionary(TagDictionary dictionary) {
        this.dict = dictionary;
    }

    public TagDictionary createEmptyTagDictionary() {
        throw new UnsupportedOperationException("Morfologik POS Tagger factory does not support this operation");
    }

    public TagDictionary createTagDictionary(InputStream in) throws IOException {
        throw new UnsupportedOperationException("Morfologik POS Tagger factory does not support this operation");
    }

    public Map<String, ArtifactSerializer<?>> createArtifactSerializersMap() {
        Map serializers = super.createArtifactSerializersMap();
        serializers.put(MORFOLOGIK_POSDICT_SUF, new ByteArraySerializer());
        serializers.put(MORFOLOGIK_DICT_INFO_SUF, new ByteArraySerializer());
        return serializers;
    }

    public Map<String, Object> createArtifactMap() {
        Map artifactMap = super.createArtifactMap();
        artifactMap.put(MORFOLOGIK_POSDICT, this.dictData);
        artifactMap.put(MORFOLOGIK_DICT_INFO, this.dictInfo);
        return artifactMap;
    }

    private TagDictionary createMorfologikDictionary(byte[] data, byte[] info) throws IOException {
        Dictionary dict = Dictionary.read((InputStream)new ByteArrayInputStream(data), (InputStream)new ByteArrayInputStream(info));
        return new MorfologikTagDictionary(dict);
    }
}

