/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import opennlp.tools.commons.Sample;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.Span;

public class TokenSample
implements Sample {
    private static final long serialVersionUID = 8520715903833887047L;
    public static final String DEFAULT_SEPARATOR_CHARS = "<SPLIT>";
    private static final String separatorChars = "<SPLIT>";
    private final String text;
    private final List<Span> tokenSpans;

    public TokenSample(String text, Span[] tokenSpans) {
        Objects.requireNonNull(tokenSpans, "tokenSpans must not be null");
        this.text = Objects.requireNonNull(text, "text must not be null");
        this.tokenSpans = List.of(tokenSpans);
        for (Span tokenSpan : tokenSpans) {
            if (tokenSpan.getStart() >= 0 && tokenSpan.getStart() <= text.length() && tokenSpan.getEnd() <= text.length() && tokenSpan.getEnd() >= 0) continue;
            throw new IllegalArgumentException("Span " + tokenSpan + " is out of bounds, text length: " + text.length() + "!");
        }
    }

    public TokenSample(Detokenizer detokenizer, String[] tokens) {
        Objects.requireNonNull(detokenizer, "detokenizer must not be null");
        Objects.requireNonNull(tokens, "tokens must not be null");
        Detokenizer.DetokenizationOperation[] operations = detokenizer.detokenize(tokens);
        ArrayList<Span> mergedTokenSpans = new ArrayList<Span>();
        StringBuilder sentence = new StringBuilder();
        for (int i = 0; i < operations.length; ++i) {
            boolean isSeparateFromPreviousToken;
            boolean bl = isSeparateFromPreviousToken = i > 0 && !this.isMergeToRight(operations[i - 1]) && !this.isMergeToLeft(operations[i]);
            if (isSeparateFromPreviousToken) {
                sentence.append(' ');
            }
            int beginIndex = sentence.length();
            sentence.append(tokens[i]);
            mergedTokenSpans.add(new Span(beginIndex, sentence.length()));
        }
        this.text = sentence.toString();
        this.tokenSpans = Collections.unmodifiableList(mergedTokenSpans);
    }

    private boolean isMergeToRight(Detokenizer.DetokenizationOperation operation) {
        return Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT.equals((Object)operation) || Detokenizer.DetokenizationOperation.MERGE_BOTH.equals((Object)operation);
    }

    private boolean isMergeToLeft(Detokenizer.DetokenizationOperation operation) {
        return Detokenizer.DetokenizationOperation.MERGE_TO_LEFT.equals((Object)operation) || Detokenizer.DetokenizationOperation.MERGE_BOTH.equals((Object)operation);
    }

    public String getText() {
        return this.text;
    }

    public Span[] getTokenSpans() {
        return this.tokenSpans.toArray(new Span[0]);
    }

    public String toString() {
        StringBuilder sentence = new StringBuilder();
        int lastEndIndex = -1;
        for (Span token : this.tokenSpans) {
            if (lastEndIndex != -1) {
                String separator = lastEndIndex == token.getStart() ? "<SPLIT>" : " ";
                sentence.append(separator);
            }
            sentence.append(token.getCoveredText(this.text));
            lastEndIndex = token.getEnd();
        }
        return sentence.toString();
    }

    private static void addToken(StringBuilder sample, List<Span> tokenSpans, String token, boolean isNextMerged) {
        int tokenSpanStart = sample.length();
        sample.append(token);
        int tokenSpanEnd = sample.length();
        tokenSpans.add(new Span(tokenSpanStart, tokenSpanEnd));
        if (!isNextMerged) {
            sample.append(" ");
        }
    }

    public static TokenSample parse(String sampleString, String separatorChars) {
        Objects.requireNonNull(sampleString, "sampleString must not be null");
        Objects.requireNonNull(separatorChars, "separatorChars must not be null");
        Span[] whitespaceTokenSpans = WhitespaceTokenizer.INSTANCE.tokenizePos(sampleString);
        ArrayList<Span> realTokenSpans = new ArrayList<Span>((int)((double)whitespaceTokenSpans.length * 1.2));
        StringBuilder untaggedSampleString = new StringBuilder();
        for (Span whiteSpaceTokenSpan : whitespaceTokenSpans) {
            String token;
            int tokEnd;
            String whitespaceToken = whiteSpaceTokenSpan.getCoveredText(sampleString).toString();
            boolean wasTokenReplaced = false;
            int tokStart = 0;
            while ((tokEnd = whitespaceToken.indexOf(separatorChars, tokStart)) > -1) {
                token = whitespaceToken.substring(tokStart, tokEnd);
                TokenSample.addToken(untaggedSampleString, realTokenSpans, token, true);
                tokStart = tokEnd + separatorChars.length();
                wasTokenReplaced = true;
            }
            if (wasTokenReplaced) {
                token = whitespaceToken.substring(tokStart);
                TokenSample.addToken(untaggedSampleString, realTokenSpans, token, false);
                continue;
            }
            TokenSample.addToken(untaggedSampleString, realTokenSpans, whitespaceToken, false);
        }
        return new TokenSample(untaggedSampleString.toString(), realTokenSpans.toArray(new Span[0]));
    }

    public int hashCode() {
        return Objects.hash(this.getText(), Arrays.hashCode(this.getTokenSpans()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TokenSample) {
            TokenSample a = (TokenSample)obj;
            return this.getText().equals(a.getText()) && Arrays.equals(this.getTokenSpans(), a.getTokenSpans());
        }
        return false;
    }
}

