/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.Sequence;

@ThreadSafe
public class ThreadSafePOSTaggerME
implements POSTagger,
AutoCloseable {
    private final POSModel model;
    private final ThreadLocal<POSTaggerME> threadLocal = new ThreadLocal();

    public ThreadSafePOSTaggerME(POSModel model) {
        this.model = model;
    }

    private POSTaggerME getTagger() {
        POSTaggerME tagger = this.threadLocal.get();
        if (tagger == null) {
            tagger = new POSTaggerME(this.model);
            this.threadLocal.set(tagger);
        }
        return tagger;
    }

    @Override
    public String[] tag(String[] sentence) {
        return this.getTagger().tag(sentence);
    }

    @Override
    public String[] tag(String[] sentence, Object[] additionaContext) {
        return this.getTagger().tag(sentence, additionaContext);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence) {
        return this.getTagger().topKSequences(sentence);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, Object[] additionaContext) {
        return this.getTagger().topKSequences(sentence, additionaContext);
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

