/*
 * Decompiled with CFR 0.152.
 */
package opennlp.bratann;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import opennlp.bratann.NameFinderAnnService;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.Span;

@Path(value="/ner")
public class NameFinderResource {
    private SentenceDetector sentDetect = NameFinderAnnService.sentenceDetector;
    private Tokenizer tokenizer = NameFinderAnnService.tokenizer;
    private TokenNameFinder[] nameFinders = NameFinderAnnService.nameFinders;

    private static int findNextNonWhitespaceChar(CharSequence s, int beginOffset, int endOffset) {
        for (int i = beginOffset; i < endOffset; ++i) {
            if (Character.isSpaceChar(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Map<String, NameAnn> findNames(@QueryParam(value="model") String modelName, String text) {
        Span[] sentenceSpans = this.sentDetect.sentPosDetect((CharSequence)text);
        HashMap<String, NameAnn> map = new HashMap<String, NameAnn>();
        int indexCounter = 0;
        for (Span sentenceSpan : sentenceSpans) {
            String sentenceText = sentenceSpan.getCoveredText((CharSequence)text).toString();
            Span[] tokenSpans = this.tokenizer.tokenizePos(sentenceText);
            String[] tokens = Span.spansToStrings((Span[])tokenSpans, (CharSequence)sentenceText);
            for (TokenNameFinder nameFinder : this.nameFinders) {
                Span[] names;
                for (Span name : names = nameFinder.find(tokens)) {
                    int beginOffset = tokenSpans[name.getStart()].getStart() + sentenceSpan.getStart();
                    int endOffset = tokenSpans[name.getEnd() - 1].getEnd() + sentenceSpan.getStart();
                    ArrayList<Integer> newLineIndexes = new ArrayList<Integer>();
                    boolean inNewLineSequence = false;
                    for (int ci = beginOffset; ci < endOffset; ++ci) {
                        if (text.charAt(ci) == '\n' || text.charAt(ci) == '\r') {
                            if (!inNewLineSequence) {
                                newLineIndexes.add(ci);
                            }
                            inNewLineSequence = true;
                            continue;
                        }
                        inNewLineSequence = false;
                    }
                    ArrayList<String> textSegments = new ArrayList<String>();
                    ArrayList<int[]> spanSegments = new ArrayList<int[]>();
                    int segmentBegin = beginOffset;
                    Iterator iterator = newLineIndexes.iterator();
                    while (iterator.hasNext()) {
                        int newLineOffset = (Integer)iterator.next();
                        textSegments.add(text.substring(segmentBegin, newLineOffset));
                        spanSegments.add(new int[]{segmentBegin, newLineOffset});
                        segmentBegin = NameFinderResource.findNextNonWhitespaceChar(text, newLineOffset + 1, endOffset);
                        if (segmentBegin != -1) continue;
                        break;
                    }
                    if (segmentBegin != -1) {
                        textSegments.add(text.substring(segmentBegin, endOffset));
                        spanSegments.add(new int[]{segmentBegin, endOffset});
                    }
                    NameAnn ann = new NameAnn();
                    ann.texts = textSegments.toArray(new String[0]);
                    ann.offsets = (int[][])spanSegments.toArray((T[])new int[spanSegments.size()][]);
                    ann.type = name.getType();
                    map.put(Integer.toString(indexCounter++), ann);
                }
            }
        }
        return map;
    }

    public static class NameAnn {
        public int[][] offsets;
        public String[] texts;
        public String type;
    }
}

