/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddCacheConfigCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.AbstractAddConfigMessageTask;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import com.hazelcast.spi.impl.NodeEngine;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;

public class AddCacheConfigMessageTask
extends AbstractAddConfigMessageTask<DynamicConfigAddCacheConfigCodec.RequestParameters> {
    public AddCacheConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected AddCacheConfigMessageTask(ClientMessage clientMessage, ILogger logger, NodeEngine nodeEngine, InternalSerializationService serializationService, ClientEngine clientEngine, Connection connection, NodeExtension nodeExtension, BuildInfo buildInfo, Config config, ClusterServiceImpl clusterService) {
        super(clientMessage, logger, nodeEngine, serializationService, clientEngine, connection, nodeExtension, buildInfo, config, clusterService);
    }

    @Override
    protected DynamicConfigAddCacheConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return DynamicConfigAddCacheConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return DynamicConfigAddCacheConfigCodec.encodeResponse();
    }

    @Override
    protected IdentifiedDataSerializable getConfig() {
        CacheSimpleConfig config = new CacheSimpleConfig();
        config.setAsyncBackupCount(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).asyncBackupCount);
        config.setBackupCount(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).backupCount);
        config.setCacheEntryListeners(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).cacheEntryListeners);
        config.setCacheLoader(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).cacheLoader);
        config.setCacheLoaderFactory(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).cacheLoaderFactory);
        config.setCacheWriter(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).cacheWriter);
        config.setCacheWriterFactory(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).cacheWriterFactory);
        config.setDisablePerEntryInvalidationEvents(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).disablePerEntryInvalidationEvents);
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).evictionConfig != null) {
            config.setEvictionConfig(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).evictionConfig.asEvictionConfig(this.serializationService));
        }
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).expiryPolicyFactoryClassName != null) {
            config.setExpiryPolicyFactory(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).expiryPolicyFactoryClassName);
        } else if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).timedExpiryPolicyFactoryConfig != null) {
            CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).timedExpiryPolicyFactoryConfig);
            config.setExpiryPolicyFactoryConfig(expiryPolicyFactoryConfig);
        }
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).eventJournalConfig != null) {
            config.setEventJournalConfig(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).eventJournalConfig);
        }
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).hotRestartConfig != null) {
            config.setHotRestartConfig(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).hotRestartConfig);
        }
        config.setInMemoryFormat(InMemoryFormat.valueOf(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).inMemoryFormat));
        config.setKeyType(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).keyType);
        config.setManagementEnabled(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).managementEnabled);
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).mergePolicy != null) {
            config.setMergePolicyConfig(this.mergePolicyConfig(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).mergePolicy, ((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).mergeBatchSize));
        }
        config.setName(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).name);
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).partitionLostListenerConfigs != null && !((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).partitionLostListenerConfigs.isEmpty()) {
            List<ListenerConfig> listenerConfigs = this.adaptListenerConfigs(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).partitionLostListenerConfigs, ((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).userCodeNamespace);
            config.setPartitionLostListenerConfigs(listenerConfigs);
        } else {
            config.setPartitionLostListenerConfigs(new ArrayList<CachePartitionLostListenerConfig>());
        }
        config.setSplitBrainProtectionName(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).splitBrainProtectionName);
        config.setReadThrough(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).readThrough);
        config.setStatisticsEnabled(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).statisticsEnabled);
        config.setValueType(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).valueType);
        config.setWanReplicationRef(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).wanReplicationRef);
        config.setWriteThrough(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).writeThrough);
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).isMerkleTreeConfigExists && ((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).merkleTreeConfig != null) {
            config.setMerkleTreeConfig(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).merkleTreeConfig);
        }
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).isDataPersistenceConfigExists) {
            config.setDataPersistenceConfig(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).dataPersistenceConfig);
        }
        if (((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).isUserCodeNamespaceExists) {
            config.setUserCodeNamespace(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).userCodeNamespace);
        }
        return config;
    }

    @Override
    public String getMethodName() {
        return "addCacheConfig";
    }

    @Override
    public Permission getUserCodeNamespacePermission() {
        return ((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).userCodeNamespace != null ? new UserCodeNamespacePermission(((DynamicConfigAddCacheConfigCodec.RequestParameters)this.parameters).userCodeNamespace, "use") : null;
    }

    @Override
    protected boolean checkStaticConfigDoesNotExist(IdentifiedDataSerializable config) {
        DynamicConfigurationAwareConfig nodeConfig = (DynamicConfigurationAwareConfig)this.nodeEngine.getConfig();
        CacheSimpleConfig cacheConfig = (CacheSimpleConfig)config;
        return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(nodeConfig.getStaticConfig().getCacheConfigs(), cacheConfig.getName(), cacheConfig);
    }
}

