/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.server;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.kurento.client.internal.transport.serialization.ObjectRefsManager;
import org.kurento.commons.SecretGenerator;

public class RemoteObjectManager
implements ObjectRefsManager {
    private SecretGenerator secretGenerator = new SecretGenerator();
    private BiMap<String, ObjectHolder> remoteObjects = HashBiMap.create();

    public String putObject(Object object) {
        String nextSecret;
        while (this.remoteObjects.get((Object)(nextSecret = this.secretGenerator.nextSecret())) != null) {
        }
        this.remoteObjects.put((Object)nextSecret, (Object)new ObjectHolder(object));
        return nextSecret;
    }

    @Override
    public Object getObject(String objectRef) {
        return ((ObjectHolder)this.remoteObjects.get((Object)objectRef)).getObject();
    }

    public void releaseObject(String objectRef) {
        this.remoteObjects.remove((Object)objectRef);
    }

    public String getObjectRefFrom(Object object) {
        return (String)this.remoteObjects.inverse().get((Object)new ObjectHolder(object));
    }

    public static class ObjectHolder {
        private Object object;

        public ObjectHolder(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public int hashCode() {
            return this.object.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ObjectHolder other = (ObjectHolder)obj;
            return this.object == other.object;
        }
    }
}

