/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Debug;
import gov.nist.core.LexerCore;
import gov.nist.core.ParserCore;
import gov.nist.core.Token;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.TokenTypes;
import java.text.ParseException;

public abstract class Parser
extends ParserCore
implements TokenTypes {
    protected ParseException createParseException(String exceptionString) {
        return new ParseException(this.lexer.getBuffer() + ":" + exceptionString, this.lexer.getPtr());
    }

    protected Lexer getLexer() {
        return (Lexer)this.lexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sipVersion() throws ParseException {
        if (debug) {
            this.dbg_enter("sipVersion");
        }
        try {
            Token tok = this.lexer.match(2051);
            if (!tok.getTokenValue().equalsIgnoreCase("SIP")) {
                this.createParseException("Expecting SIP");
            }
            this.lexer.match(47);
            tok = this.lexer.match(4095);
            if (!tok.getTokenValue().equals("2.0")) {
                this.createParseException("Expecting SIP/2.0");
            }
            String string = "SIP/2.0";
            return string;
        }
        finally {
            if (debug) {
                this.dbg_leave("sipVersion");
            }
        }
    }

    protected String method() throws ParseException {
        try {
            Token[] tokens;
            Token token;
            if (debug) {
                this.dbg_enter("method");
            }
            if ((token = (tokens = this.lexer.peekNextToken(1))[0]).getTokenType() == 2053 || token.getTokenType() == 2054 || token.getTokenType() == 2056 || token.getTokenType() == 2055 || token.getTokenType() == 2052 || token.getTokenType() == 2057 || token.getTokenType() == 2101 || token.getTokenType() == 2102 || token.getTokenType() == 2115 || token.getTokenType() == 2118 || token.getTokenType() == 4095) {
                this.lexer.consume();
                String string = token.getTokenValue();
                return string;
            }
            throw this.createParseException("Invalid Method");
        }
        finally {
            if (Debug.debug) {
                this.dbg_leave("method");
            }
        }
    }

    public static final void checkToken(String token) throws ParseException {
        if (token == null || token.length() == 0) {
            throw new ParseException("null or empty token", -1);
        }
        for (int i = 0; i < token.length(); ++i) {
            if (LexerCore.isTokenChar(token.charAt(i))) continue;
            throw new ParseException("Invalid character(s) in string (not allowed in 'token')", i);
        }
    }
}

