/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureRequestContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureStatesEnum;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureParameter;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoredProcedureRequestGrammar
extends AbstractGrammar<StoredProcedureRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(StoredProcedureRequestGrammar.class);
    private static StoredProcedureRequestGrammar instance = new StoredProcedureRequestGrammar();

    private StoredProcedureRequestGrammar() {
        this.setName(StoredProcedureRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[StoredProcedureStatesEnum.LAST_STORED_PROCEDURE_STATE.ordinal()][256];
        this.transitions[StoredProcedureStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(StoredProcedureStatesEnum.START_STATE, StoredProcedureStatesEnum.STORED_PROCEDURE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[StoredProcedureStatesEnum.STORED_PROCEDURE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<StoredProcedureRequestContainer>(StoredProcedureStatesEnum.STORED_PROCEDURE_STATE, StoredProcedureStatesEnum.LANGUAGE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<StoredProcedureRequestContainer>("Stores the language"){

            @Override
            public void action(StoredProcedureRequestContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err(I18n.ERR_08207_SP_LANGUAGE_NULL, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                String language = Strings.utf8ToString(tlv.getValue().getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08213_SP_LANGUAGE_FOUND, language));
                }
                container.getStoredProcedure().setLanguage(language);
            }
        });
        this.transitions[StoredProcedureStatesEnum.LANGUAGE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<StoredProcedureRequestContainer>(StoredProcedureStatesEnum.LANGUAGE_STATE, StoredProcedureStatesEnum.PROCEDURE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<StoredProcedureRequestContainer>("Stores the procedure"){

            @Override
            public void action(StoredProcedureRequestContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err(I18n.ERR_08208_NULL_PROCEDURE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] procedure = tlv.getValue().getData();
                container.getStoredProcedure().setProcedure(procedure);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08212_PROCEDURE_FOUND, container.getStoredProcedure().getProcedureSpecification()));
                }
            }
        });
        this.transitions[StoredProcedureStatesEnum.PROCEDURE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<StoredProcedureRequestContainer>(StoredProcedureStatesEnum.PROCEDURE_STATE, StoredProcedureStatesEnum.PARAMETERS_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<StoredProcedureRequestContainer>("Stores the parameters"){

            @Override
            public void action(StoredProcedureRequestContainer container) {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETERS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(StoredProcedureStatesEnum.PARAMETERS_STATE, StoredProcedureStatesEnum.PARAMETER_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[StoredProcedureStatesEnum.PARAMETER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<StoredProcedureRequestContainer>(StoredProcedureStatesEnum.PARAMETER_STATE, StoredProcedureStatesEnum.PARAMETER_TYPE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<StoredProcedureRequestContainer>("Store parameter type"){

            @Override
            public void action(StoredProcedureRequestContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err(I18n.ERR_08209_NULL_PARAMETER_TYPE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                StoredProcedureParameter parameter = new StoredProcedureParameter();
                byte[] parameterType = tlv.getValue().getData();
                parameter.setType(parameterType);
                container.setCurrentParameter(parameter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08210_PARAMETER_TYPE_FOUND, Strings.dumpBytes(parameterType)));
                }
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETER_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<StoredProcedureRequestContainer>(StoredProcedureStatesEnum.PARAMETER_TYPE_STATE, StoredProcedureStatesEnum.PARAMETER_VALUE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<StoredProcedureRequestContainer>("Store parameter value"){

            @Override
            public void action(StoredProcedureRequestContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                StoredProcedureRequest storedProcedure = container.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err(I18n.ERR_08210_NULL_PARAMETER_VALUE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] parameterValue = tlv.getValue().getData();
                if (parameterValue.length != 0) {
                    StoredProcedureParameter parameter = container.getCurrentParameter();
                    parameter.setValue(parameterValue);
                    storedProcedure.addParameter(parameter);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08211_PARAMETER_VALUE_FOUND, Strings.dumpBytes(parameterValue)));
                    }
                } else {
                    String msg = I18n.err(I18n.ERR_08211_EMPTY_PARAMETER_VALUE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETER_VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(StoredProcedureStatesEnum.PARAMETER_VALUE_STATE, StoredProcedureStatesEnum.PARAMETER_STATE, UniversalTag.SEQUENCE.getValue(), null);
    }

    public static StoredProcedureRequestGrammar getInstance() {
        return instance;
    }
}

