/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.everit.json.schema;

import com.hazelcast.shaded.org.everit.json.schema.ArraySchema;
import com.hazelcast.shaded.org.everit.json.schema.BooleanSchema;
import com.hazelcast.shaded.org.everit.json.schema.CombinedSchema;
import com.hazelcast.shaded.org.everit.json.schema.ConditionalSchema;
import com.hazelcast.shaded.org.everit.json.schema.ConstSchema;
import com.hazelcast.shaded.org.everit.json.schema.EmptySchema;
import com.hazelcast.shaded.org.everit.json.schema.EnumSchema;
import com.hazelcast.shaded.org.everit.json.schema.FalseSchema;
import com.hazelcast.shaded.org.everit.json.schema.FormatValidator;
import com.hazelcast.shaded.org.everit.json.schema.NotSchema;
import com.hazelcast.shaded.org.everit.json.schema.NullSchema;
import com.hazelcast.shaded.org.everit.json.schema.NumberSchema;
import com.hazelcast.shaded.org.everit.json.schema.ObjectSchema;
import com.hazelcast.shaded.org.everit.json.schema.ReferenceSchema;
import com.hazelcast.shaded.org.everit.json.schema.Schema;
import com.hazelcast.shaded.org.everit.json.schema.StringSchema;
import com.hazelcast.shaded.org.everit.json.schema.regexp.Regexp;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class Visitor {
    Visitor() {
    }

    void visitSchema(Schema schema) {
    }

    void visitNumberSchema(NumberSchema numberSchema) {
        this.visitSchema(numberSchema);
        this.visitExclusiveMinimum(numberSchema.isExclusiveMinimum());
        this.visitMinimum(numberSchema.getMinimum());
        this.visitExclusiveMinimumLimit(numberSchema.getExclusiveMinimumLimit());
        this.visitExclusiveMaximum(numberSchema.isExclusiveMaximum());
        this.visitMaximum(numberSchema.getMaximum());
        this.visitExclusiveMaximumLimit(numberSchema.getExclusiveMaximumLimit());
        this.visitMultipleOf(numberSchema.getMultipleOf());
    }

    void visitMinimum(Number minimum) {
    }

    void visitExclusiveMinimum(boolean exclusiveMinimum) {
    }

    void visitExclusiveMinimumLimit(Number exclusiveMinimumLimit) {
    }

    void visitMaximum(Number maximum) {
    }

    void visitExclusiveMaximum(boolean exclusiveMaximum) {
    }

    void visitExclusiveMaximumLimit(Number exclusiveMaximumLimit) {
    }

    void visitMultipleOf(Number multipleOf) {
    }

    void visit(Schema schema) {
        schema.accept(this);
    }

    void visitArraySchema(ArraySchema arraySchema) {
        this.visitSchema(arraySchema);
        this.visitMinItems(arraySchema.getMinItems());
        this.visitMaxItems(arraySchema.getMaxItems());
        this.visitUniqueItems(arraySchema.needsUniqueItems());
        if (arraySchema.getAllItemSchema() != null) {
            this.visitAllItemSchema(arraySchema.getAllItemSchema());
        }
        this.visitAdditionalItems(arraySchema.permitsAdditionalItems());
        if (arraySchema.getItemSchemas() != null) {
            this.visitItemSchemas(arraySchema.getItemSchemas());
        }
        if (arraySchema.getSchemaOfAdditionalItems() != null) {
            this.visitSchemaOfAdditionalItems(arraySchema.getSchemaOfAdditionalItems());
        }
        if (arraySchema.getContainedItemSchema() != null) {
            this.visitContainedItemSchema(arraySchema.getContainedItemSchema());
        }
    }

    void visitItemSchemas(List<Schema> itemSchemas) {
        if (itemSchemas != null) {
            for (int i = 0; i < itemSchemas.size(); ++i) {
                this.visitItemSchema(i, itemSchemas.get(i));
            }
        }
    }

    void visitMinItems(Integer minItems) {
    }

    void visitMaxItems(Integer maxItems) {
    }

    void visitUniqueItems(boolean uniqueItems) {
    }

    void visitAllItemSchema(Schema allItemSchema) {
        this.visitSchema(allItemSchema);
    }

    void visitAdditionalItems(boolean additionalItems) {
    }

    void visitItemSchema(int index, Schema itemSchema) {
        this.visitSchema(itemSchema);
    }

    void visitSchemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
        this.visitSchema(schemaOfAdditionalItems);
    }

    void visitContainedItemSchema(Schema containedItemSchema) {
        this.visitSchema(containedItemSchema);
    }

    void visitBooleanSchema(BooleanSchema schema) {
        this.visitSchema(schema);
    }

    void visitNullSchema(NullSchema nullSchema) {
        this.visitSchema(nullSchema);
    }

    void visitEmptySchema(EmptySchema emptySchema) {
        this.visitSchema(emptySchema);
    }

    void visitConstSchema(ConstSchema constSchema) {
        this.visitSchema(constSchema);
    }

    void visitEnumSchema(EnumSchema enumSchema) {
        this.visitSchema(enumSchema);
    }

    void visitFalseSchema(FalseSchema falseSchema) {
        this.visitSchema(falseSchema);
    }

    void visitNotSchema(NotSchema notSchema) {
        this.visitSchema(notSchema);
        notSchema.getMustNotMatch().accept(this);
    }

    void visitReferenceSchema(ReferenceSchema referenceSchema) {
        this.visitSchema(referenceSchema);
    }

    void visitObjectSchema(ObjectSchema objectSchema) {
        Map<Regexp, Schema> patternProperties;
        this.visitSchema(objectSchema);
        this.visitRequiredProperties(objectSchema.getRequiredProperties());
        if (objectSchema.getPropertyNameSchema() != null) {
            this.visitPropertyNameSchema(objectSchema.getPropertyNameSchema());
        }
        this.visitMinProperties(objectSchema.getMinProperties());
        this.visitMaxProperties(objectSchema.getMaxProperties());
        for (Map.Entry<String, Set<String>> entry : objectSchema.getPropertyDependencies().entrySet()) {
            this.visitPropertyDependencies(entry.getKey(), entry.getValue());
        }
        this.visitAdditionalProperties(objectSchema.permitsAdditionalProperties());
        if (objectSchema.getSchemaOfAdditionalProperties() != null) {
            this.visitSchemaOfAdditionalProperties(objectSchema.getSchemaOfAdditionalProperties());
        }
        if ((patternProperties = objectSchema.getRegexpPatternProperties()) != null) {
            this.visitPatternProperties(patternProperties);
        }
        for (Map.Entry<String, Schema> entry : objectSchema.getSchemaDependencies().entrySet()) {
            this.visitSchemaDependency(entry.getKey(), entry.getValue());
        }
        Map<String, Schema> map = objectSchema.getPropertySchemas();
        if (map != null) {
            this.visitPropertySchemas(map);
        }
    }

    void visitRequiredProperties(List<String> requiredProperties) {
        for (String requiredPropName : requiredProperties) {
            this.visitRequiredPropertyName(requiredPropName);
        }
    }

    void visitPatternProperties(Map<Regexp, Schema> patternProperties) {
        for (Map.Entry<Regexp, Schema> entry : patternProperties.entrySet()) {
            this.visitPatternPropertySchema(entry.getKey(), entry.getValue());
        }
    }

    void visitPropertySchemas(Map<String, Schema> propertySchemas) {
        for (Map.Entry<String, Schema> entry : propertySchemas.entrySet()) {
            this.visitPropertySchema(entry.getKey(), entry.getValue());
        }
    }

    void visitPropertySchema(String properyName, Schema schema) {
        this.visitSchema(schema);
    }

    void visitSchemaDependency(String propKey, Schema schema) {
        this.visitSchema(schema);
    }

    void visitPatternPropertySchema(Regexp propertyNamePattern, Schema schema) {
        this.visitSchema(schema);
    }

    void visitSchemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
        this.visitSchema(schemaOfAdditionalProperties);
    }

    void visitAdditionalProperties(boolean additionalProperties) {
    }

    void visitPropertyDependencies(String ifPresent, Set<String> allMustBePresent) {
    }

    void visitMaxProperties(Integer maxProperties) {
    }

    void visitMinProperties(Integer minProperties) {
    }

    void visitPropertyNameSchema(Schema propertyNameSchema) {
        this.visitSchema(propertyNameSchema);
    }

    void visitRequiredPropertyName(String requiredPropName) {
    }

    void visitStringSchema(StringSchema stringSchema) {
        this.visitSchema(stringSchema);
        this.visitMinLength(stringSchema.getMinLength());
        this.visitMaxLength(stringSchema.getMaxLength());
        this.visitPattern(stringSchema.getRegexpPattern());
        this.visitFormat(stringSchema.getFormatValidator());
    }

    void visitFormat(FormatValidator formatValidator) {
    }

    void visitPattern(Regexp pattern) {
    }

    void visitMaxLength(Integer maxLength) {
    }

    void visitMinLength(Integer minLength) {
    }

    void visitCombinedSchema(CombinedSchema combinedSchema) {
        this.visitSchema(combinedSchema);
    }

    void visitConditionalSchema(ConditionalSchema conditionalSchema) {
        this.visitSchema(conditionalSchema);
        conditionalSchema.getIfSchema().ifPresent(this::visitIfSchema);
        conditionalSchema.getThenSchema().ifPresent(this::visitThenSchema);
        conditionalSchema.getElseSchema().ifPresent(this::visitElseSchema);
    }

    void visitIfSchema(Schema ifSchema) {
        this.visitSchema(ifSchema);
    }

    void visitThenSchema(Schema thenSchema) {
        this.visitSchema(thenSchema);
    }

    void visitElseSchema(Schema elseSchema) {
        this.visitSchema(elseSchema);
    }
}

