/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.protocol.http.FetchMetadataResourceIsolationPolicy;
import org.apache.wicket.protocol.http.IResourceIsolationPolicy;
import org.apache.wicket.protocol.http.OriginResourceIsolationPolicy;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceIsolationRequestCycleListener
implements IRequestCycleListener {
    private static final Logger log = LoggerFactory.getLogger(ResourceIsolationRequestCycleListener.class);
    public static final String ERROR_MESSAGE = "The request was blocked by a resource isolation policy";
    private CsrfAction unknownOutcomeAction = CsrfAction.ABORT;
    private CsrfAction disallowedOutcomeAction = CsrfAction.ABORT;
    private int errorCode = 403;
    private String errorMessage = "The request was blocked by a resource isolation policy";
    private final Set<String> exemptedPaths = new HashSet<String>();
    private final List<IResourceIsolationPolicy> resourceIsolationPolicies = new ArrayList<IResourceIsolationPolicy>();

    public ResourceIsolationRequestCycleListener(IResourceIsolationPolicy ... policies) {
        this.resourceIsolationPolicies.addAll(Arrays.asList(policies));
        if (policies.length == 0) {
            this.resourceIsolationPolicies.addAll(Arrays.asList(new FetchMetadataResourceIsolationPolicy(), new OriginResourceIsolationPolicy()));
        }
    }

    public ResourceIsolationRequestCycleListener setUnknownOutcomeAction(CsrfAction action) {
        this.unknownOutcomeAction = action;
        return this;
    }

    public ResourceIsolationRequestCycleListener setDisallowedOutcomeAction(CsrfAction action) {
        this.disallowedOutcomeAction = action;
        return this;
    }

    public ResourceIsolationRequestCycleListener setErrorCode(int errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public ResourceIsolationRequestCycleListener setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public void addExemptedPaths(String ... exemptions) {
        Arrays.stream(exemptions).filter(e -> !Strings.isEmpty((String)e)).forEach(this.exemptedPaths::add);
    }

    @Override
    public void onBeginRequest(RequestCycle cycle) {
        HttpServletRequest containerRequest = (HttpServletRequest)cycle.getRequest().getContainerRequest();
        log.debug("Processing request to: {}", (Object)containerRequest.getPathInfo());
    }

    protected boolean isEnabled() {
        return true;
    }

    protected boolean isChecked(IRequestablePage targetedPage) {
        return true;
    }

    protected boolean isChecked(IRequestHandler handler) {
        return handler instanceof IPageRequestHandler && !(handler instanceof RenderPageRequestHandler);
    }

    @Override
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        if (!this.isEnabled()) {
            log.trace("CSRF listener is disabled, no checks performed");
            return;
        }
        if (this.isChecked(handler = ResourceIsolationRequestCycleListener.unwrap(handler))) {
            IPageRequestHandler pageRequestHandler = (IPageRequestHandler)handler;
            IRequestablePage targetedPage = pageRequestHandler.getPage();
            HttpServletRequest containerRequest = (HttpServletRequest)cycle.getRequest().getContainerRequest();
            if (!this.isChecked(targetedPage)) {
                if (log.isDebugEnabled()) {
                    log.debug("Targeted page {} was opted out of resource isolation, allowed", (Object)targetedPage.getClass().getName());
                }
                return;
            }
            String pathInfo = containerRequest.getPathInfo();
            if (this.exemptedPaths.contains(pathInfo)) {
                if (log.isDebugEnabled()) {
                    log.debug("Allowing request to {} because it matches an exempted path", new Object[]{pathInfo});
                }
                return;
            }
            for (IResourceIsolationPolicy policy : this.resourceIsolationPolicies) {
                IResourceIsolationPolicy.ResourceIsolationOutcome outcome = policy.isRequestAllowed(containerRequest, targetedPage);
                if (IResourceIsolationPolicy.ResourceIsolationOutcome.DISALLOWED.equals((Object)outcome)) {
                    log.debug("Isolation policy {} has rejected a request to {}", (Object)Classes.simpleName(policy.getClass()), (Object)pathInfo);
                    this.disallowedOutcomeAction.apply(this, containerRequest, targetedPage);
                    return;
                }
                if (!IResourceIsolationPolicy.ResourceIsolationOutcome.ALLOWED.equals((Object)outcome)) continue;
                return;
            }
            this.unknownOutcomeAction.apply(this, containerRequest, targetedPage);
        } else if (log.isTraceEnabled()) {
            log.trace("Resolved handler {} is not checked, no CSRF check performed", (Object)handler.getClass().getName());
        }
    }

    @Override
    public void onEndRequest(RequestCycle cycle) {
        WebResponse webResponse;
        if (cycle.getResponse() instanceof WebResponse && (webResponse = (WebResponse)cycle.getResponse()).isHeaderSupported()) {
            for (IResourceIsolationPolicy resourceIsolationPolicy : this.resourceIsolationPolicies) {
                resourceIsolationPolicy.setHeaders((HttpServletResponse)webResponse.getContainerResponse());
            }
        }
    }

    protected void allowHandler(HttpServletRequest request, IRequestablePage page) {
        log.info("Possible CSRF attack, request URL: {}, action: allowed", (Object)request.getRequestURL());
    }

    protected void suppressHandler(HttpServletRequest request, IRequestablePage page) {
        log.info("Possible CSRF attack, request URL: {}, action: suppressed", (Object)request.getRequestURL());
        throw new RestartResponseException(page);
    }

    protected void abortHandler(HttpServletRequest request, IRequestablePage page) {
        log.info("Possible CSRF attack, request URL: {}, action: aborted with error {} {}", new Object[]{request.getRequestURL(), this.errorCode, this.errorMessage});
        throw new AbortWithHttpErrorCodeException(this.errorCode, this.errorMessage);
    }

    private static IRequestHandler unwrap(IRequestHandler handler) {
        while (handler instanceof IRequestHandlerDelegate) {
            handler = ((IRequestHandlerDelegate)handler).getDelegateHandler();
        }
        return handler;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CsrfAction {
        ABORT{

            public String toString() {
                return "aborted";
            }

            @Override
            void apply(ResourceIsolationRequestCycleListener listener, HttpServletRequest request, IRequestablePage page) {
                listener.abortHandler(request, page);
            }
        }
        ,
        SUPPRESS{

            public String toString() {
                return "suppressed";
            }

            @Override
            void apply(ResourceIsolationRequestCycleListener listener, HttpServletRequest request, IRequestablePage page) {
                listener.suppressHandler(request, page);
            }
        }
        ,
        ALLOW{

            public String toString() {
                return "allowed";
            }

            @Override
            void apply(ResourceIsolationRequestCycleListener listener, HttpServletRequest request, IRequestablePage page) {
                listener.allowHandler(request, page);
            }
        };


        abstract void apply(ResourceIsolationRequestCycleListener var1, HttpServletRequest var2, IRequestablePage var3);
    }
}

