/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.proxy;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.util.MapChangeTracker;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.proxy.ProxyMap;

public class ProxyMaps
extends Proxies {
    public static void beforeClear(ProxyMap map) {
        ProxyMaps.dirty(map, true);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            ProxyMaps.removed(map, entry.getKey(), true);
            ProxyMaps.removed(map, entry.getValue(), false);
        }
    }

    public static Set keySet(ProxyMap map) {
        ProxyEntrySet entries = (ProxyEntrySet)map.entrySet();
        entries.setView(0);
        return entries;
    }

    public static Collection values(ProxyMap map) {
        ProxyEntrySet entries = (ProxyEntrySet)map.entrySet();
        entries.setView(1);
        return entries;
    }

    public static Set afterEntrySet(ProxyMap map, Set entries) {
        return new ProxyEntrySetImpl(map, entries);
    }

    public static boolean beforeGet(ProxyMap map, Object key) {
        ProxyMaps.assertAllowedType(key, map.getKeyType());
        return map.keySet().contains(key);
    }

    public static Object afterGet(ProxyMap map, Object key, Object ret, boolean before) {
        if (before && map.getChangeTracker() != null) {
            ((MapChangeTracker)map.getChangeTracker()).changed(key, ret, ret);
        }
        return ret;
    }

    public static boolean beforePut(ProxyMap map, Object key, Object value) {
        ProxyMaps.assertAllowedType(key, map.getKeyType());
        ProxyMaps.assertAllowedType(value, map.getValueType());
        ProxyMaps.dirty(map, false);
        return map.containsKey(key);
    }

    public static Object afterPut(ProxyMap map, Object key, Object value, Object ret, boolean before) {
        if (before) {
            if (map.getChangeTracker() != null) {
                ((MapChangeTracker)map.getChangeTracker()).changed(key, ret, value);
            }
            ProxyMaps.removed(map, ret, false);
        } else if (map.getChangeTracker() != null) {
            ((MapChangeTracker)map.getChangeTracker()).added(key, value);
        }
        return ret;
    }

    public static boolean beforeSetProperty(ProxyMap map, String key, String value) {
        return ProxyMaps.beforePut(map, key, value);
    }

    public static Object afterSetProperty(ProxyMap map, String key, String value, Object ret, boolean before) {
        return ProxyMaps.afterPut(map, key, value, ret, before);
    }

    public static void beforeLoad(ProxyMap map, InputStream in) {
        ProxyMaps.dirty(map, true);
    }

    public static void beforeLoadFromXML(ProxyMap map, InputStream in) {
        ProxyMaps.dirty(map, true);
    }

    public static void putAll(ProxyMap map, Map values) {
        Iterator iterator = values.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static boolean beforeRemove(ProxyMap map, Object key) {
        ProxyMaps.dirty(map, false);
        return map.containsKey(key);
    }

    public static Object afterRemove(ProxyMap map, Object key, Object ret, boolean before) {
        if (before) {
            if (map.getChangeTracker() != null) {
                ((MapChangeTracker)map.getChangeTracker()).removed(key, ret);
            }
            ProxyMaps.removed(map, key, true);
            ProxyMaps.removed(map, ret, false);
        }
        return ret;
    }

    public static boolean beforeRemove(ProxyMap map, Object key, Object value) {
        Proxies.dirty(map, false);
        return map.containsKey(key);
    }

    public static boolean afterRemove(ProxyMap map, Object key, Object value, boolean ret, boolean before) {
        if (before) {
            if (map.getChangeTracker() != null) {
                ((MapChangeTracker)map.getChangeTracker()).removed(key, ret);
            }
            Proxies.removed(map, key, true);
            Proxies.removed(map, ret, false);
        }
        return ret;
    }

    public static interface ProxyEntrySet
    extends Set {
        public static final int VIEW_KEYS = 0;
        public static final int VIEW_VALUES = 1;
        public static final int VIEW_ENTRIES = 2;

        public void setView(int var1);
    }

    private static class ProxyEntrySetImpl
    extends AbstractSet
    implements ProxyEntrySet {
        private final ProxyMap _map;
        private final Set _entries;
        private int _view = 2;

        public ProxyEntrySetImpl(ProxyMap map, Set entries) {
            this._map = map;
            this._entries = entries;
        }

        public int getView() {
            return this._view;
        }

        @Override
        public void setView(int view) {
            this._view = view;
        }

        @Override
        public int size() {
            return this._entries.size();
        }

        @Override
        public boolean remove(Object o) {
            if (this._view != 0) {
                throw new UnsupportedOperationException();
            }
            if (!this._map.containsKey(o)) {
                return false;
            }
            this._map.remove(o);
            return true;
        }

        @Override
        public Iterator iterator() {
            final Iterator itr = this._entries.iterator();
            return new Iterator(){
                private Map.Entry _last = null;

                @Override
                public boolean hasNext() {
                    return itr.hasNext();
                }

                public Object next() {
                    this._last = (Map.Entry)itr.next();
                    switch (_view) {
                        case 0: {
                            return this._last.getKey();
                        }
                        case 1: {
                            return this._last.getValue();
                        }
                    }
                    return this._last;
                }

                @Override
                public void remove() {
                    Proxies.dirty(_map, false);
                    itr.remove();
                    if (_map.getChangeTracker() != null) {
                        ((MapChangeTracker)_map.getChangeTracker()).removed(this._last.getKey(), this._last.getValue());
                    }
                    Proxies.removed(_map, this._last.getKey(), true);
                    Proxies.removed(_map, this._last.getValue(), false);
                }
            };
        }

        protected Object writeReplace() throws ObjectStreamException {
            switch (this._view) {
                case 0: {
                    return this._map.keySet();
                }
                case 1: {
                    return this._map.values();
                }
            }
            return this._map.entrySet();
        }
    }
}

