/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.calendar;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.calendar.MeetingMemberDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dto.calendar.AppointmentDTO;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.manager.IInvitationManager;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class AppointmentDao
implements IDataProviderDao<Appointment> {
    private static final Logger log = LoggerFactory.getLogger(AppointmentDao.class);
    private static final String PARAM_START = "start";
    private static final String PARAM_CALID = "calId";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private MeetingMemberDao meetingMemberDao;
    @Inject
    private RoomDao roomDao;
    @Inject
    private ConfigurationDao cfgDao;
    @Inject
    private IInvitationManager invitationManager;

    @Override
    public Appointment get(Long id) {
        return (Appointment)DaoHelper.only(this.em.createNamedQuery("getAppointmentById", Appointment.class).setParameter("id", (Object)id).getResultList());
    }

    public Appointment getAny(Long id) {
        return (Appointment)DaoHelper.only(this.em.createNamedQuery("getAppointmentByIdAny", Appointment.class).setParameter("id", (Object)id).getResultList());
    }

    public List<Appointment> get() {
        return this.em.createNamedQuery("getAppointments", Appointment.class).getResultList();
    }

    @Override
    public Appointment update(Appointment a, Long userId) {
        return this.update(a, userId, true);
    }

    public Appointment update(Appointment a, Long userId, boolean sendmails) {
        Room r = a.getRoom();
        if (r.getId() == null) {
            r.setName(a.getTitle());
            r.setCapacity(this.cfgDao.getLong("calendar.conference.rooms.default.size", 50L));
        }
        a.setRoom(this.roomDao.update(r, userId));
        boolean newApp = a.getId() == null;
        AppointmentDTO a0 = null;
        Set<Object> mmIds = Set.of();
        if (sendmails && !newApp) {
            Appointment prev = this.get(a.getId());
            if (prev != null) {
                a0 = new AppointmentDTO(prev);
            }
            mmIds = this.meetingMemberDao.getMeetingMemberIdsByAppointment(a.getId());
        }
        if (newApp) {
            a.setIcalId(UUID.randomUUID().toString());
            this.em.persist((Object)a);
        } else {
            a = (Appointment)this.em.merge((Object)a);
        }
        if (sendmails) {
            boolean sendMail = a0 == null || !StringUtils.equals((CharSequence)a0.getTitle(), (CharSequence)a.getTitle()) || !StringUtils.equals((CharSequence)a0.getDescription(), (CharSequence)a.getDescription()) || !StringUtils.equals((CharSequence)a0.getLocation(), (CharSequence)a.getLocation()) || !a0.getStart().getTime().equals(a.getStart()) || !a0.getEnd().getTime().equals(a.getEnd());
            List<MeetingMember> mmList = a.getMeetingMembers();
            if (mmList != null) {
                for (MeetingMember mm : mmList) {
                    if (mm.getId() == null || !mmIds.contains(mm.getId())) {
                        this.invitationManager.processInvitation(a, mm, Invitation.MessageType.CREATE);
                        continue;
                    }
                    mmIds.remove(mm.getId());
                    this.invitationManager.processInvitation(a, mm, Invitation.MessageType.UPDATE, sendMail);
                }
            }
            Iterator<Object> iterator = mmIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                this.invitationManager.processInvitation(a, this.meetingMemberDao.get(id), Invitation.MessageType.CANCEL);
            }
            MeetingMember owner = new MeetingMember();
            owner.setUser(a.getOwner());
            if (newApp) {
                this.invitationManager.processInvitation(a, owner, Invitation.MessageType.CREATE);
            } else if (a.isDeleted()) {
                this.invitationManager.processInvitation(a, owner, Invitation.MessageType.CANCEL);
            } else if (sendMail) {
                this.invitationManager.processInvitation(a, owner, Invitation.MessageType.UPDATE, sendMail);
            }
        }
        return a;
    }

    @Override
    public void delete(Appointment a, Long userId) {
        if (a == null || a.getId() == null) {
            return;
        }
        a.setDeleted(true);
        a.setMeetingMembers(null);
        if (a.getRoom().isAppointment()) {
            a.getRoom().setDeleted(true);
        }
        this.update(a, userId);
    }

    public List<Appointment> getInRange(Long userId, Date start, Date end) {
        log.debug("Start {} End {}", (Object)start, (Object)end);
        TypedQuery query = this.em.createNamedQuery("appointmentsInRange", Appointment.class);
        query.setParameter(PARAM_START, (Object)start);
        query.setParameter("end", (Object)end);
        query.setParameter("userId", (Object)userId);
        ArrayList<Appointment> listAppoints = new ArrayList<Appointment>(query.getResultList());
        TypedQuery q1 = this.em.createNamedQuery("joinedAppointmentsInRange", Appointment.class);
        q1.setParameter(PARAM_START, (Object)start);
        q1.setParameter("end", (Object)end);
        q1.setParameter("userId", (Object)userId);
        for (Appointment a : q1.getResultList()) {
            a.setConnectedEvent(true);
            listAppoints.add(a);
        }
        return listAppoints;
    }

    public List<Appointment> getInRange(Calendar start, Calendar end) {
        TypedQuery q = this.em.createNamedQuery("appointmentsInRangeRemind", Appointment.class);
        q.setParameter("none", (Object)Appointment.Reminder.NONE);
        q.setParameter(PARAM_START, (Object)start.getTime());
        q.setParameter("end", (Object)end.getTime());
        return q.getResultList();
    }

    public Appointment getNext(Long userId, Date start) {
        List list = this.em.createNamedQuery("getNextAppointment", Appointment.class).setParameter(PARAM_START, (Object)start).setParameter("userId", (Object)userId).getResultList();
        return list == null || list.isEmpty() ? null : (Appointment)list.get(0);
    }

    public List<Appointment> searchByTitle(Long userId, String title) {
        return this.em.createNamedQuery("getAppointmentsByTitle", Appointment.class).setParameter("title", (Object)title).setParameter("userId", (Object)userId).getResultList();
    }

    public Appointment getByRoom(Long userId, Long roomId) {
        try {
            List list = this.em.createNamedQuery("getAppointmentByOwnerRoomId", Appointment.class).setParameter("userId", (Object)userId).setParameter("roomId", (Object)roomId).getResultList();
            return list.isEmpty() ? null : (Appointment)list.get(0);
        }
        catch (Exception e) {
            log.error("[getByRoom]", (Throwable)e);
            return null;
        }
    }

    public Appointment getByRoom(Long roomId) {
        Appointment a;
        List list = this.em.createNamedQuery("getAppointmentByRoomId", Appointment.class).setParameter("roomId", (Object)roomId).getResultList();
        Appointment appointment = a = list.isEmpty() ? null : (Appointment)list.get(0);
        if (a != null && !a.getRoom().isAppointment()) {
            throw new RuntimeException("Room " + a.getRoom().getName() + " isnt part of an appointed meeting");
        }
        return a;
    }

    public List<String> getHrefsbyCalendar(Long calId) {
        return this.em.createNamedQuery("getHrefsforAppointmentsinCalendar", String.class).setParameter(PARAM_CALID, (Object)calId).getResultList();
    }

    public List<Appointment> getbyCalendar(Long calId) {
        return this.em.createNamedQuery("getAppointmentsbyCalendar", Appointment.class).setParameter(PARAM_CALID, (Object)calId).getResultList();
    }

    public int deletebyCalendar(Long calId) {
        return this.em.createNamedQuery("deleteAppointmentsbyCalendar", Appointment.class).setParameter(PARAM_CALID, (Object)calId).executeUpdate();
    }

    @Override
    public List<Appointment> get(long start, long count) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public List<Appointment> get(String search, long start, long count, SortParam<String> order) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count() {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count(String search) {
        throw DaoHelper.UNSUPPORTED;
    }
}

