/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.ROWID;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFDCNRowChanges
implements RowChangeDescription {
    RowChangeDescription.RowOperation opcode;
    int rowidLength;
    byte[] rowid;
    ROWID rowidObj;

    NTFDCNRowChanges(RowChangeDescription.RowOperation rowOperation, int n2, byte[] byArray) {
        this.opcode = rowOperation;
        this.rowidLength = n2;
        this.rowid = byArray;
        this.rowidObj = null;
    }

    @Override
    public ROWID getRowid() {
        if (this.rowidObj == null) {
            this.rowidObj = new ROWID(this.rowid);
        }
        return this.rowidObj;
    }

    @Override
    public RowChangeDescription.RowOperation getRowOperation() {
        return this.opcode;
    }

    @DisableTrace
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("      ROW:  operation=" + this.getRowOperation() + ", ROWID=" + new String(this.rowid) + "\n");
        return stringBuffer.toString();
    }
}

