/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.installation;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.openmeetings.core.sip.SipManager;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Configuration;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.installation.InstallException;
import org.apache.openmeetings.installation.InstallationConfig;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.csp.CSPDirectiveSrcValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImportInitvalues {
    private static final Logger log = LoggerFactory.getLogger(ImportInitvalues.class);
    private static final String VER_1_8 = "1.8.x";
    private static final String VER_1_9 = "1.9.x";
    private static final String VER_2_0 = "2.0.x";
    private static final String VER_3_0 = "3.0.x";
    private static final String VER_3_0_3 = "3.0.3";
    private static final String VER_3_3_0 = "3.3.0";
    private static final String VER_5_0_0 = "5.0.0";
    private static final String VER_5_0_1 = "5.0.1";
    private static final String CLIENT_PLACEHOLDER = "<put your client_id>";
    private static final String SECRET_PLACEHOLDER = "<put your client_secret>";
    private static final String EMAIL_PARAM = "email";
    private static final String FNAME_PARAM = "first_name";
    private static final String LNAME_PARAM = "last_name";
    @Inject
    private ConfigurationDao cfgDao;
    @Inject
    private UserDao userDao;
    @Inject
    private SipManager sipDao;
    @Inject
    private OAuth2Dao oauthDao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private RoomDao roomDao;
    private int progress = 0;

    public int getProgress() {
        return this.progress;
    }

    private static void addCfg(List<Configuration> list, String key, String value, Configuration.Type type, String comment, String fromVersion) {
        Configuration c = new Configuration();
        c.setType(type);
        c.setKey(key);
        c.setValue(value);
        c.setComment(comment);
        c.setFromVersion(fromVersion);
        list.add(c);
    }

    public static List<Configuration> initialCfgs(InstallationConfig cfg) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        ImportInitvalues.addCfg(list, "crypt.class.name", cfg.getCryptClassName(), Configuration.Type.STRING, "This Class is used for Authentification-Crypting. Be carefull what you do here! If you change it while running previous Pass of users will not be workign anymore! for more Information see https://openmeetings.apache.org/CustomCryptMechanism.html", VER_1_9);
        ImportInitvalues.addCfg(list, "allow.frontend.register", String.valueOf(cfg.isAllowFrontendRegister()), Configuration.Type.BOOL, "Is USER register available on login screen", VER_1_8);
        ImportInitvalues.addCfg(list, "allow.soap.register", String.valueOf(true), Configuration.Type.BOOL, "Is user register available via SOAP/REST", VER_3_0);
        ImportInitvalues.addCfg(list, "allow.oauth.register", String.valueOf(true), Configuration.Type.BOOL, "Is user register available via OAuth", VER_3_0);
        ImportInitvalues.addCfg(list, "default.group.id", String.valueOf(OpenmeetingsVariables.getDefaultGroup()), Configuration.Type.NUMBER, "", VER_1_8);
        ImportInitvalues.addCfg(list, "mail.smtp.server", cfg.getSmtpServer(), Configuration.Type.STRING, "this is the smtp server to send messages", VER_1_9);
        ImportInitvalues.addCfg(list, "mail.smtp.port", String.valueOf(cfg.getSmtpPort()), Configuration.Type.NUMBER, "this is the smtp server port normally 25", VER_1_9);
        ImportInitvalues.addCfg(list, "mail.smtp.system.email", cfg.getMailReferer(), Configuration.Type.STRING, "all send e-mails by the system will have this address", VER_1_9);
        ImportInitvalues.addCfg(list, "mail.smtp.user", cfg.getMailAuthName(), Configuration.Type.STRING, "System auth email username", VER_1_9);
        ImportInitvalues.addCfg(list, "mail.smtp.pass", cfg.getMailAuthPass(), Configuration.Type.STRING, "System auth email password", VER_1_9);
        ImportInitvalues.addCfg(list, "mail.smtp.starttls.enable", String.valueOf(cfg.isMailUseTls()), Configuration.Type.BOOL, "Enable TLS", VER_1_9);
        ImportInitvalues.addCfg(list, "mail.smtp.connection.timeout", "30000", Configuration.Type.NUMBER, "Socket connection timeout value in milliseconds. Default is 30 seconds (30000).", VER_1_9);
        ImportInitvalues.addCfg(list, "mail.smtp.timeout", "30000", Configuration.Type.NUMBER, "Socket I/O timeout value in milliseconds. Default is 30 seconds (30000).", VER_1_9);
        ImportInitvalues.addCfg(list, "application.name", "OpenMeetings", Configuration.Type.STRING, "Name of the Browser Title window", VER_3_0);
        ImportInitvalues.addCfg(list, "default.lang.id", String.valueOf(cfg.getDefaultLangId()), Configuration.Type.NUMBER, "Default System Language ID see languages.xml", VER_1_8);
        ImportInitvalues.addCfg(list, "document.dpi", String.valueOf(cfg.getDocDpi()), Configuration.Type.NUMBER, "dpi for conversion of PDF to images (should be an integer between 50 and  600 with a default value of 150 dpi)", VER_2_0);
        ImportInitvalues.addCfg(list, "document.quality", String.valueOf(cfg.getDocQuality()), Configuration.Type.NUMBER, "compression quality for conversion of PDF to images (should be an integer between 1 and 100, with a default value of 90)", VER_2_0);
        ImportInitvalues.addCfg(list, "path.imagemagick", cfg.getImageMagicPath(), Configuration.Type.PATH, "Path to ImageMagick tools", VER_2_0);
        ImportInitvalues.addCfg(list, "path.sox", cfg.getSoxPath(), Configuration.Type.PATH, "Path To SoX-Tools", VER_2_0);
        ImportInitvalues.addCfg(list, "path.ffmpeg", cfg.getFfmpegPath(), Configuration.Type.PATH, "Path To FFMPEG", VER_2_0);
        ImportInitvalues.addCfg(list, "path.office", cfg.getOfficePath(), Configuration.Type.PATH, "The path to OpenOffice/LibreOffice (optional) please set this to the real path in case jodconverter is unable to find OpenOffice/LibreOffice installation automatically", VER_2_0);
        ImportInitvalues.addCfg(list, "dashboard.rss.feed1", cfg.getUrlFeed(), Configuration.Type.STRING, "Feed URL 1", VER_1_9);
        ImportInitvalues.addCfg(list, "dashboard.rss.feed2", cfg.getUrlFeed2(), Configuration.Type.STRING, "Feed URL 2", VER_1_9);
        ImportInitvalues.addCfg(list, "send.email.at.register", String.valueOf(cfg.isSendEmailAtRegister()), Configuration.Type.BOOL, "User get a EMail with their Account data.", VER_2_0);
        ImportInitvalues.addCfg(list, "send.email.with.verfication", String.valueOf(cfg.isSendEmailWithVerficationCode()), Configuration.Type.BOOL, String.format("User must activate their account by clicking on the activation-link in the registering Email It makes no sense to make this(%s) 'true' while %s is 'false' cause you need to send a EMail.", "send.email.with.verfication", "send.email.at.register"), VER_2_0);
        ImportInitvalues.addCfg(list, "application.base.url", cfg.getBaseUrl(), Configuration.Type.STRING, "Base URL your Openmeetings installation will be accessible at.", "3.0.2");
        ImportInitvalues.addCfg(list, "sip.enable", String.valueOf(cfg.isSipEnable()), Configuration.Type.BOOL, "Enable to enable the red5SIP integration ", VER_1_9);
        ImportInitvalues.addCfg(list, "sip.room.prefix", cfg.getSipRoomPrefix(), Configuration.Type.STRING, "Numerical prefix for OM rooms created inside the SIP", VER_1_9);
        ImportInitvalues.addCfg(list, "sip.exten.context", cfg.getSipExtenContext(), Configuration.Type.STRING, "Enable to enable the red5SIP integration ", VER_1_9);
        ImportInitvalues.addCfg(list, "default.timezone", cfg.getTimeZone(), Configuration.Type.STRING, "This is the default timezone if nothing is specified", VER_1_9);
        ImportInitvalues.addCfg(list, "screensharing.default.quality", "1", Configuration.Type.NUMBER, "Default selection in ScreenSharing Quality:\n 0 - bigger frame rate, no resize\n 1 - no resize\n 2 - size == 1/2 of selected area\n 3 - size == 3/8 of selected area", VER_3_0_3);
        ImportInitvalues.addCfg(list, "screensharing.default.fps", "10", Configuration.Type.NUMBER, "Default selection in ScreenSharing FPS", VER_3_0_3);
        ImportInitvalues.addCfg(list, "screensharing.fps.show", String.valueOf(true), Configuration.Type.BOOL, "Is screensharing FPS should be displayed or not", VER_3_0_3);
        ImportInitvalues.addCfg(list, "screensharing.allow.remote", String.valueOf(true), Configuration.Type.BOOL, "Is remote control will be enabled while screensharing. Allowing remote control will be not possible in case it is set to 'false'", "3.0.4");
        ImportInitvalues.addCfg(list, "dashboard.show.myrooms", String.valueOf(true), Configuration.Type.BOOL, "Show 'My Rooms' widget on dashboard", VER_1_9);
        ImportInitvalues.addCfg(list, "dashboard.show.chat", String.valueOf(true), Configuration.Type.BOOL, "Show 'Global Chat' outside the room", VER_1_9);
        ImportInitvalues.addCfg(list, "dashboard.show.rssfeed", String.valueOf(false), Configuration.Type.BOOL, "Show RSS widget on dashboard", VER_1_9);
        ImportInitvalues.addCfg(list, "max.upload.size", String.valueOf(0x6400000L), Configuration.Type.NUMBER, "Maximum size of upload file (bytes)", VER_1_8);
        ImportInitvalues.addCfg(list, "number.minutes.reminder.send", String.valueOf(OpenmeetingsVariables.getAppointmentReminderMinutes()), Configuration.Type.NUMBER, "The number of minutes before reminder emails are send. Set to 0 to disable reminder emails", VER_1_9);
        ImportInitvalues.addCfg(list, "user.login.minimum.length", String.valueOf(4), Configuration.Type.NUMBER, "Number of chars needed in a user login", VER_1_9);
        ImportInitvalues.addCfg(list, "user.pass.minimum.length", String.valueOf(8), Configuration.Type.NUMBER, "Number of chars needed in a user password", VER_1_9);
        ImportInitvalues.addCfg(list, "calendar.conference.rooms.default.size", "50", Configuration.Type.NUMBER, "Default number of participants conference room created via calendar", VER_1_9);
        ImportInitvalues.addCfg(list, "video.arrange.keycode", "Shift+F8", Configuration.Type.HOTKEY, "A hot key code for arrange video windows functionality", VER_2_0);
        ImportInitvalues.addCfg(list, "mute.others.keycode", "Shift+F12", Configuration.Type.HOTKEY, "A hot key code for the 'mute others' functionality", VER_2_0);
        ImportInitvalues.addCfg(list, "mute.keycode", "Shift+F7", Configuration.Type.HOTKEY, "A hot key code for the 'mute/unmute audio' functionality", VER_2_0);
        ImportInitvalues.addCfg(list, "default.ldap.id", "0", Configuration.Type.NUMBER, "Ldap domain selected by default in the login screen", VER_1_9);
        ImportInitvalues.addCfg(list, "inviter.email.as.replyto", String.valueOf(cfg.isReplyToOrganizer()), Configuration.Type.BOOL, "Set inviter's email address as ReplyTo in email invitations", VER_2_0);
        ImportInitvalues.addCfg(list, "default.landing.zone", "user/dashboard", Configuration.Type.STRING, "Area to be shown to the user after login. Possible values are: user/dashboard, user/calendar, user/record, rooms/my, rooms/group, rooms/public, profile/messages, profile/edit, profile/search, profile/invitation, profile/widget, admin/user, admin/connection, admin/group, admin/room, admin/config, admin/lang, admin/ldap, admin/oauth2, admin/backup, admin/email", "2.1.x");
        ImportInitvalues.addCfg(list, "oauth2.ignore.bad.ssl", String.valueOf(false), Configuration.Type.BOOL, "Set \"yes\" or \"no\" to enable/disable ssl certifications checking for OAuth2\nWARNING: it is not secure to ignore bad SSL", VER_3_0);
        ImportInitvalues.addCfg(list, "redirect.url.for.external.users", "", Configuration.Type.STRING, "Users entered the room via invitationHash or secureHash will be redirected to this URL on connection lost", VER_3_0);
        ImportInitvalues.addCfg(list, "google.analytics.code", null, Configuration.Type.STRING, "Code for Google Analytics", "3.1.0");
        ImportInitvalues.addCfg(list, "external.process.ttl", String.valueOf(OpenmeetingsVariables.getExtProcessTtl()), Configuration.Type.NUMBER, String.format("Time to live in minutes for external processes such as conversion via ffmpeg (default %s minutes)", OpenmeetingsVariables.getExtProcessTtl()), VER_3_3_0);
        ImportInitvalues.addCfg(list, "personal.rooms.enabled", String.valueOf(true), Configuration.Type.BOOL, "Users are allowed to create personal rooms", "3.3.2");
        ImportInitvalues.addCfg(list, "reminder.message", null, Configuration.Type.STRING, "Reminder message to notify about upcoming appointment, generated message will be used if not set", VER_2_0);
        ImportInitvalues.addCfg(list, "mp4.audio.rate", String.valueOf(OpenmeetingsVariables.getAudioRate()), Configuration.Type.NUMBER, "Audio sampling rate (in Hz) for MP4 video", "4.0.1");
        ImportInitvalues.addCfg(list, "mp4.audio.bitrate", String.valueOf(OpenmeetingsVariables.getAudioBitrate()), Configuration.Type.STRING, "Audio bitrate for MP4 video", "4.0.1");
        ImportInitvalues.addCfg(list, "rest.allow.origin", null, Configuration.Type.STRING, "List of addresses browser Ajax REST requests are allowed from", "4.0.2");
        ImportInitvalues.addCfg(list, "user.fname.minimum.length", String.valueOf(4), Configuration.Type.NUMBER, "Number of chars needed in a user first name", "4.0.4");
        ImportInitvalues.addCfg(list, "user.lname.minimum.length", String.valueOf(4), Configuration.Type.NUMBER, "Number of chars needed in a user last name", "4.0.4");
        ImportInitvalues.addCfg(list, "chat.send.on.enter", String.valueOf(false), Configuration.Type.BOOL, "Controls if chat message will be set on Enter (default: send on Ctrl+Enter)", "4.0.5");
        ImportInitvalues.addCfg(list, "mp4.video.preset", "medium", Configuration.Type.STRING, "Preset (encoder optimization settings) to be used while performing mp4 conversion.Valid values are: ultrafast, superfast, veryfast, faster, fast, medium, slow, slower, veryslow", "4.0.5");
        ImportInitvalues.addCfg(list, "cam.fps", "30", Configuration.Type.NUMBER, "Camera FPS, should be positive number in range (0, 60]", VER_5_0_0);
        ImportInitvalues.addCfg(list, "mic.rate", "22", Configuration.Type.NUMBER, "The rate at which the microphone should capture sound, in kHz. The default value is 22 kHz.", VER_5_0_0);
        ImportInitvalues.addCfg(list, "mic.echo.cancellation", String.valueOf(true), Configuration.Type.BOOL, "Whether or not echo cancellation is preferred and/or required.", VER_5_0_0);
        ImportInitvalues.addCfg(list, "mic.noise.suppression", String.valueOf(true), Configuration.Type.BOOL, "Whether noise suppression is preferred and/or required.", VER_5_0_0);
        ImportInitvalues.addCfg(list, "display.name.editable", String.valueOf(false), Configuration.Type.BOOL, "Is user will be able to edit his/her display name (default false).", "4.0.7");
        ImportInitvalues.addCfg(list, "start.quickpoll.keycode", "Ctrl+Alt+KeyQ", Configuration.Type.HOTKEY, "A hot key code to start quick poll", "4.0.10");
        ImportInitvalues.addCfg(list, "auto.open.sharing", String.valueOf(false), Configuration.Type.BOOL, "Whether shared screen should be auto-opened.", VER_5_0_0);
        ImportInitvalues.addCfg(list, "video.arrange.resize.keycode", "Ctrl+Shift+KeyA", Configuration.Type.HOTKEY, "A hot key code to arrange video windows bottom-to-top with resize to 120x90", VER_5_0_0);
        String cspMore = ", more info: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy";
        ImportInitvalues.addCfg(list, "header.csp.font", "https://fonts.gstatic.com", Configuration.Type.STRING, "Value for 'font-src' directive of 'Content-Security-Policy' header (default: https://fonts.gstatic.com), more info: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy", VER_5_0_0);
        ImportInitvalues.addCfg(list, "header.csp.frame", CSPDirectiveSrcValue.SELF.getValue(), Configuration.Type.STRING, "Value for 'frame-src' directive of 'Content-Security-Policy' header (default: " + CSPDirectiveSrcValue.SELF + "), more info: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy", VER_5_0_0);
        ImportInitvalues.addCfg(list, "header.csp.image", OpenmeetingsVariables.DEFAULT_CSP_DATA, Configuration.Type.STRING, "Value for 'image-src' directive of 'Content-Security-Policy' header (default: " + OpenmeetingsVariables.DEFAULT_CSP_DATA + "), more info: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy", VER_5_0_0);
        ImportInitvalues.addCfg(list, "header.csp.media", OpenmeetingsVariables.DEFAULT_CSP_DATA, Configuration.Type.STRING, "Value for 'media-src' directive of 'Content-Security-Policy' header (default: " + OpenmeetingsVariables.DEFAULT_CSP_DATA + "), more info: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy", VER_5_0_0);
        ImportInitvalues.addCfg(list, "header.csp.script", CSPDirectiveSrcValue.STRICT_DYNAMIC.getValue(), Configuration.Type.STRING, "Value for 'script-src' directive of 'Content-Security-Policy' header (default: " + CSPDirectiveSrcValue.STRICT_DYNAMIC + "), more info: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy", VER_5_0_0);
        ImportInitvalues.addCfg(list, "header.csp.style", OpenmeetingsVariables.DEFAULT_CSP_STYLE, Configuration.Type.STRING, "Value for 'style-src' directive of 'Content-Security-Policy' header (default: " + OpenmeetingsVariables.DEFAULT_CSP_STYLE + "), more info: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy", VER_5_0_0);
        ImportInitvalues.addCfg(list, "mail.smtp.ssl.enable", String.valueOf(false), Configuration.Type.BOOL, "Enable SSL", VER_5_0_0);
        ImportInitvalues.addCfg(list, "header.csp.enabled", String.valueOf(true), Configuration.Type.BOOL, "Whether or not CSP secure headers are enabled", VER_5_0_0);
        ImportInitvalues.addCfg(list, "user.pass.check.upper", String.valueOf(true), Configuration.Type.BOOL, "Whether or not Password MUST contain uppercase characters", VER_5_0_1);
        ImportInitvalues.addCfg(list, "user.pass.check.digit", String.valueOf(true), Configuration.Type.BOOL, "Whether or not Password MUST contain numeric", VER_5_0_1);
        ImportInitvalues.addCfg(list, "user.pass.check.special", String.valueOf(true), Configuration.Type.BOOL, "Whether or not Password MUST contain special character", VER_5_0_1);
        ImportInitvalues.addCfg(list, "appointment.pre.start.minutes", String.valueOf(OpenmeetingsVariables.getAppointmentPreStartMinutes()), Configuration.Type.NUMBER, "How many minutes before the start the room should be open (default: " + OpenmeetingsVariables.getAppointmentPreStartMinutes() + ")", VER_5_0_1);
        ImportInitvalues.addCfg(list, "recording.enabled", String.valueOf(true), Configuration.Type.BOOL, "Whether or not recording functionality is enabled", "6.0.0");
        ImportInitvalues.addCfg(list, "ui.theme", OpenmeetingsVariables.getTheme(), Configuration.Type.STRING, "UI theme, possible values are Cerulean, Cosmo, Cyborg, Darkly, Flatly, Journal, Litera, Lumen, Lux, Materia, Minty, Pulse, Sandstone, Simplex, Sketchy, Slate, Solar, Spacelab, Superhero, United, Yeti", "6.1.0");
        ImportInitvalues.addCfg(list, "otp.enabled", String.valueOf(false), Configuration.Type.BOOL, "Whether or not Time-based One Time Passwords are enabled", "6.3.0");
        return list;
    }

    public void loadConfiguration(InstallationConfig cfg) {
        for (Configuration c : ImportInitvalues.initialCfgs(cfg)) {
            this.cfgDao.update(c, null);
        }
        log.debug("Configurations ADDED");
    }

    private Room createRoom(String name, Room.Type type, long capacity, boolean isPublic, Long groupId) {
        Room r = new Room();
        r.setName(name);
        r.setComment("");
        r.setCapacity(capacity);
        r.setType(type);
        r.setIspublic(isPublic);
        r.setAllowUserQuestions(true);
        r.setAudioOnly(false);
        r.setAppointment(false);
        r.setDemoRoom(false);
        r.setDemoTime(null);
        r.hide(Room.RoomElement.MICROPHONE_STATUS);
        r.setModerated(false);
        r.setDeleted(false);
        r.setClosed(false);
        r.setRedirectURL(null);
        r.setOwnerId(null);
        r.setWaitRecording(false);
        r.setAllowRecording(true);
        if (groupId != null) {
            r.addGroup(this.groupDao.get(groupId));
        }
        r = this.roomDao.update(r, null);
        return r;
    }

    public void loadDefaultRooms(boolean createRooms, long langId) {
        if (createRooms) {
            this.createRoom(LabelDao.getString((String)"install.room.public.interview", (long)langId), Room.Type.INTERVIEW, 16L, true, null);
            this.createRoom(LabelDao.getString((String)"install.room.public.conference", (long)langId), Room.Type.CONFERENCE, 32L, true, null);
            Room r = this.createRoom(LabelDao.getString((String)"install.room.public.video.only", (long)langId), Room.Type.CONFERENCE, 32L, true, null);
            r.hide(Room.RoomElement.WHITEBOARD);
            this.roomDao.update(r, null);
            this.createRoom(LabelDao.getString((String)"install.room.public.video.wb", (long)langId), Room.Type.CONFERENCE, 32L, true, null);
            this.createRoom(LabelDao.getString((String)"install.room.public.presentation", (long)langId), Room.Type.PRESENTATION, 100L, true, null);
            r = this.createRoom(LabelDao.getString((String)"install.room.presentation.micro", (long)langId), Room.Type.PRESENTATION, 100L, true, null);
            r.getHiddenElements().clear();
            this.roomDao.update(r, null);
            r = this.createRoom(LabelDao.getString((String)"install.room.conference.micro", (long)langId), Room.Type.CONFERENCE, 32L, true, null);
            r.getHiddenElements().clear();
            this.roomDao.update(r, null);
            this.createRoom(LabelDao.getString((String)"install.room.private.conference", (long)langId), Room.Type.CONFERENCE, 32L, false, 1L);
        }
    }

    public void loadInitUserAndGroup(InstallationConfig cfg) throws Exception {
        Group g = new Group();
        g.setName(cfg.getGroup());
        g.setInsertedby(Long.valueOf(1L));
        g.setDeleted(false);
        g = this.groupDao.update(g, null);
        Configuration c = this.cfgDao.get("default.group.id");
        c.setValueN(g.getId());
        this.cfgDao.update(c, null);
        User u = UserDao.getNewUserInstance(null);
        u.setType(User.Type.USER);
        u.getRights().add(User.Right.ADMIN);
        u.getRights().add(User.Right.SOAP);
        u.setLogin(cfg.getUsername());
        u.setFirstname("firstname");
        u.setLastname("lastname");
        u.getAddress().setEmail(cfg.getEmail());
        u.addGroup(g);
        u = this.userDao.update(u, cfg.getPassword(), Long.valueOf(-1L));
        log.debug("Installation - User Added user-Id {}", (Object)u.getId());
        if (u.getId() == null) {
            throw new InstallException("Unable to add user");
        }
    }

    public User createSystemUser(User u, String group, String login, String pass, boolean groupAdmin, Consumer<User> postprocess) throws Exception {
        GroupUser gu = new GroupUser(this.groupDao.get(group), u);
        gu.setModerator(groupAdmin);
        u.getGroupUsers().add(gu);
        u.setLogin(login);
        if (postprocess != null) {
            postprocess.accept(u);
        }
        return this.userDao.update(u, pass, null);
    }

    public void loadInitialOAuthServers() {
        this.oauthDao.update(new OAuthServer().setName("Yandex").setIconUrl("https://yandex.st/morda-logo/i/favicon.ico").setEnabled(false).setClientId(CLIENT_PLACEHOLDER).setClientSecret(SECRET_PLACEHOLDER).setRequestKeyUrl("https://oauth.yandex.ru/authorize?response_type=code&client_id={$client_id}").setRequestTokenUrl("https://oauth.yandex.ru/token").setRequestTokenMethod(OAuthServer.RequestTokenMethod.POST).setRequestTokenAttributes("grant_type=authorization_code&code={$code}&client_id={$client_id}&client_secret={$client_secret}").setRequestInfoUrl("https://login.yandex.ru/info?format=json&oauth_token={$access_token}").addMapping("login", "login").addMapping("address.email", "default_email").addMapping("firstname", FNAME_PARAM).addMapping("lastname", LNAME_PARAM), null);
        this.oauthDao.update(new OAuthServer().setName("Google").setIconUrl("https://www.google.com/images/google_favicon_128.png").setEnabled(false).setClientId(CLIENT_PLACEHOLDER).setClientSecret(SECRET_PLACEHOLDER).setRequestKeyUrl("https://accounts.google.com/o/oauth2/auth?redirect_uri={$redirect_uri}&response_type=code&client_id={$client_id}&scope=https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fuserinfo.email+https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fuserinfo.profile").setRequestTokenUrl("https://accounts.google.com/o/oauth2/token").setRequestTokenMethod(OAuthServer.RequestTokenMethod.POST).setRequestTokenAttributes("code={$code}&client_id={$client_id}&client_secret={$client_secret}&redirect_uri={$redirect_uri}&grant_type=authorization_code").setRequestInfoUrl("https://www.googleapis.com/oauth2/v1/userinfo?access_token={$access_token}").setRequestInfoMethod(OAuthServer.RequestInfoMethod.GET).addMapping("login", EMAIL_PARAM).addMapping("address.email", EMAIL_PARAM).addMapping("firstname", "given_name").addMapping("lastname", "family_name"), null);
        this.oauthDao.update(new OAuthServer().setName("Facebook").setIconUrl("https://www.facebook.com/images/fb_icon_325x325.png").setEnabled(false).setClientId(CLIENT_PLACEHOLDER).setClientSecret(SECRET_PLACEHOLDER).setRequestKeyUrl("https://www.facebook.com/v4.0/dialog/oauth?client_id={$client_id}&redirect_uri={$redirect_uri}&scope=email").setRequestTokenUrl("https://graph.facebook.com/v4.0/oauth/access_token").setRequestTokenMethod(OAuthServer.RequestTokenMethod.POST).setRequestTokenAttributes("client_id={$client_id}&redirect_uri={$redirect_uri}&client_secret={$client_secret}&code={$code}").setRequestInfoUrl("https://graph.facebook.com/me?access_token={$access_token}&fields=id,first_name,last_name,email").setRequestInfoMethod(OAuthServer.RequestInfoMethod.GET).addMapping("login", "id").addMapping("address.email", EMAIL_PARAM).addMapping("firstname", FNAME_PARAM).addMapping("lastname", LNAME_PARAM), null);
        this.oauthDao.update(new OAuthServer().setName("VK").setIconUrl("https://vk.com/images/icons/pwa/apple/default.png").setEnabled(false).setClientId(CLIENT_PLACEHOLDER).setClientSecret(SECRET_PLACEHOLDER).setRequestKeyUrl("https://oauth.vk.com/authorize?client_id={$client_id}&scope=email&redirect_uri={$redirect_uri}&response_type=code&v=5.68").setRequestTokenUrl("https://oauth.vk.com/access_token").setRequestTokenMethod(OAuthServer.RequestTokenMethod.POST).setRequestTokenAttributes("client_id={$client_id}&client_secret={$client_secret}&code={$code}&redirect_uri={$redirect_uri}").setRequestInfoUrl("https://api.vk.com/method/users.get?&v=5.92&user_ids={$user_id}&access_token={$access_token}&fields=id,first_name,last_name,email&name_case=nom").setRequestInfoMethod(OAuthServer.RequestInfoMethod.GET).addMapping("login", "id").addMapping("address.email", EMAIL_PARAM).addMapping("firstname", FNAME_PARAM).addMapping("lastname", LNAME_PARAM), null);
        this.oauthDao.update(new OAuthServer().setName("keycloak").setIconUrl("https://www.keycloak.org/resources/images/keycloak_icon_512px.svg").setEnabled(false).setClientId(CLIENT_PLACEHOLDER).setClientSecret(SECRET_PLACEHOLDER).setRequestKeyUrl("<KeycloakBaseUrl>/auth/realms/uweslan/protocol/openid-connect/auth?redirect_uri={$redirect_uri}&client_id={$client_id}&response_type=code&scope=email").setRequestTokenUrl("<KeycloakBaseUrl>/auth/realms/<--custom-realm-->/protocol/openid-connect/token").setRequestTokenMethod(OAuthServer.RequestTokenMethod.POST).setRequestTokenAttributes("code={$code}&client_id={$client_id}&client_secret={$client_secret}&redirect_uri={$redirect_uri}&grant_type=authorization_code").setRequestInfoUrl("<KeycloakBaseUrl>/auth/realms/<--custom-realm-->/protocol/openid-connect/userinfo").setRequestInfoMethod(OAuthServer.RequestInfoMethod.HEADER).addMapping("login", EMAIL_PARAM).addMapping("address.email", EMAIL_PARAM).addMapping("firstname", "given_name").addMapping("lastname", "family_name"), null);
    }

    private void checkInstalled(boolean force) {
        if (!force && this.userDao.count() > 0L) {
            log.debug("System contains users, no need to install data one more time.");
        }
    }

    public void loadSystem(InstallationConfig cfg, boolean force) {
        this.checkInstalled(force);
        this.sipDao.delete();
        this.progress = 20;
        this.loadConfiguration(cfg);
        this.progress = 40;
        if (cfg.isCreateDefaultObjects()) {
            this.loadInitialOAuthServers();
        }
        this.progress = 60;
    }

    public void loadAll(InstallationConfig cfg, boolean force) throws Exception {
        this.checkInstalled(force);
        this.loadSystem(cfg, force);
        this.loadInitUserAndGroup(cfg);
        this.progress = 80;
        this.loadDefaultRooms(cfg.isCreateDefaultObjects(), cfg.getDefaultLangId());
        this.progress = 100;
    }
}

