/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/chat/chat.js":
/*!**************************!*\
  !*** ./src/chat/chat.js ***!
  \**************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const OmUtil = __webpack_require__(/*! ../main/omutils */ "../main/omutils");
const Settings = __webpack_require__(/*! ../main/settings */ "../main/settings");
const CSSEmoticon = __webpack_require__(/*! ./cssemoticons */ "./src/chat/cssemoticons.js");

const msgIdPrefix = 'chat-msg-id-'
	, closedSize = 20
	, closedSizePx = closedSize + "px"
	, doneTypingInterval = 5000 //time in ms, 5 second for example
	, SEND_ENTER = 'enter', SEND_CTRL = 'ctrl'
	, audio = new Audio('./public/chat_message.mp3')
	;
let chatPanel, ctrlBlk, tabs, openedHeight = "345px", openedWidth = "300px", allPrefix = "All"
	, roomPrefix = "Room ", typingTimer, roomMode = false
	, editor = $('#chatMessage .wysiwyg-editor'), muted = false, sendOn, DEF_SEND
	, userId, inited = false, newMsgNotification
	;

function __setCssVar(key, _val) {
	const val = ('' + _val).endsWith('px') ? _val : _val + 'px';
	if (roomMode) {
		if (typeof(Room) == 'object' && typeof(Room.setCssVar) === 'function') {
			Room.setCssVar(key, val);
		}
	} else {
		OmUtil.setCssVar(key, val);
	}
}
function __setCssWidth(val) {
	__setCssVar('--chat-width', val)
}
function __setCssHeight(val) {
	__setCssVar('--chat-height', val)
}
function _load() {
	const s = Settings.load();
	if (typeof(s.chat) === 'undefined') {
		s.chat = {
			muted: false
			, sendOn: DEF_SEND
		};
		Settings.save(s)
	}
	muted = s.chat.muted === true;
	sendOn = s.chat.sendOn === SEND_ENTER ? SEND_ENTER : SEND_CTRL;
	return s;
}
function _updateAudioBtn() {
	const btn = $('#chat .audio');
	btn.removeClass('sound' + (muted ? '' : '-mute')).addClass('sound' + (muted ? '-mute' : ''))
			.attr('title', btn.data(muted ? 'sound-enabled' : 'sound-muted'));
}
function _updateSendBtn() {
	const btn = $('#chat .send-btn')
		, ctrl = sendOn === SEND_CTRL;
	if (ctrl) {
		btn.addClass('send-ctrl');
		editor.off('keydown', _sendOnEnter).keydown('Ctrl+return', _sendOnEnter);
	} else {
		btn.removeClass('send-ctrl');
		editor.off('keydown', _sendOnEnter).keydown('return', _sendOnEnter);
	}
	btn.attr('title', btn.data(ctrl ? 'send-ctrl' : 'send-enter'));
}
function _sendOnEnter() {
	$('#chat .send').trigger('click');
}
function doneTyping () {
	typingTimer = null;
	chatActivity('typing_stop', $('.room-block .room-container').data('room-id'));
}
function _emtClick() {
	_editorAppend($(this).data('emt'));
}
function initToolbar() {
	const emots = CSSEmoticon.emoticons;
	const rowSize = 20, emotMenuList = $('#emotMenuList');
	emotMenuList.html('');
	let row;
	for (let i = 0; i < emots.length; ++i) {
		if (i % rowSize === 0) {
			row = $('<tr></tr>');
			emotMenuList.append(row);
		}
		row.append($('<td>').append(
				$('<div>').addClass('emt').html(CSSEmoticon.emoticonize(emots[i]))
					.data('emt', emots[i]).click(_emtClick)
			));
	}
	const emtBtn = $('#emoticons');
	emtBtn.html('');
	emtBtn.append(' ' + CSSEmoticon.emoticonize(':)'));
	const a = $('#chat .audio');
	const sbtn = $('#chat .send-btn');
	{ //scope
		_load();
		_updateAudioBtn();
		_updateSendBtn()
	}
	a.off().click(function() {
		const s = _load();
		muted = s.chat.muted = !s.chat.muted;
		_updateAudioBtn();
		Settings.save(s);
	});
	sbtn.off().click(function() {
		const s = _load();
		sendOn = s.chat.sendOn = s.chat.sendOn !== SEND_CTRL ? SEND_CTRL : SEND_ENTER;
		_updateSendBtn();
		Settings.save(s);
	});
	$('#chat #hyperlink').parent().find('button').off().click(function() {
		_insertLink();
	});
	CSSEmoticon.animate();
}
function isClosed() {
	return chatPanel.hasClass('closed');
}
function activateTab(id) {
	if (isClosed()) {
		tabs.find('.nav.nav-tabs .nav-link').each(function() {
			const self = $(this)
				, tabId = self.attr('aria-controls')
				, tab = $('#' + tabId);

			if (tabId === id) {
				self.addClass('active');
				tab.addClass('active');
				self.attr('aria-selected', true);
			} else {
				self.removeClass('active');
				tab.removeClass('active');
				self.attr('aria-selected', false);
			}
		});
	} else {
		$('#chatTabs li a[aria-controls="' + id + '"]').tab('show');
	}
	$('#activeChatTab').val(id).trigger('change');
}
function _reinit(opts) {
	userId = opts.userId;
	allPrefix = opts.all;
	roomPrefix = opts.room;
	DEF_SEND = opts.sendOnEnter === true ? SEND_ENTER : SEND_CTRL;
	sendOn = DEF_SEND;
	chatPanel = $('#chatPanel');
	clearTimeout(chatPanel.data('timeout'));
	ctrlBlk = $('#chatPopup .control.block');
	newMsgNotification = ctrlBlk.data('new-msg');
	editor = $('#chatMessage .wysiwyg-editor');
	initToolbar();
	tabs = $("#chatTabs");
	tabs.off().on('shown.bs.tab', function (e) {
		const ct = $(e.target).attr('aria-controls');
		_scrollDown($('#' + ct));
		$('#activeChatTab').val(ct).trigger('change');
	});
	tabs.delegate(".btn.close-chat", "click", function() {
		const panelId = $(this).closest("a").attr("aria-controls");
		_removeTab(panelId);
		$('#chatTabs li:last-child a').tab('show');
	});
	if (roomMode) {
		_removeResize();
	} else {
		ctrlBlk.attr('title', '');
		chatPanel.removeClass('room opened').addClass('closed')
			.off('mouseenter mouseleave').resizable({
				handles: 'n, ' + (Settings.isRtl ? 'e' : 'w')
				, disabled: isClosed()
				, minHeight: 195
				, minWidth: 260
				, stop: function(_, ui) {
					chatPanel.css({'top': '', 'left': ''});
					openedHeight = ui.size.height + 'px';
					__setCssHeight(openedHeight);
					__setCssWidth(ui.size.width);
				}
			});
		__setCssHeight(closedSize);
	}
	ctrlBlk.off().click(_toggle);
	$('#chatMessage').off().on('input propertychange paste', function () {
		const room = $('.room-block .room-container');
		if (room.length) {
			if (!!typingTimer) {
				clearTimeout(typingTimer);
			} else {
				chatActivity('typing_start', room.data('room-id'));
			}
			typingTimer = setTimeout(doneTyping, doneTypingInterval);
		}
	});
	$('#chat .chat-toolbar .link-field').off().on('keypress', function(evt) {
		if (evt.keyCode === 13) {
			$(this).parent().find('button').trigger('click');
		}
		return evt.keyCode !== 13;
	});
	inited = true;
}
function _removeTab(id) {
	$('#chatTabs li a[aria-controls="' + id + '"]').parent().remove();
	$('#' + id).remove();
}
function _addTab(id, label) {
	if (!inited) {
		_reinit({});
	}
	if ($('#chat').length < 1 || $('#' + id).length) {
		return;
	}
	if (!label) {
		label = id === "chatTab-all" ? allPrefix : roomPrefix + id.substr(9);
	}
	const link = $('<a class="nav-link" data-bs-toggle="tab">')
		.attr('aria-controls', id)
		.attr('href', '#' + id).text(label)
		, li = $('<li class="nav-item">').append(link);
	if (id.indexOf("chatTab-u") === 0) {
		link.append(OmUtil.tmpl('#chat-close-block'));
	}
	tabs.find('.nav.nav-tabs').append(li);
	const msgArea = OmUtil.tmpl('#chat-msg-area-template', id);
	tabs.find('.tab-content').append(msgArea);
	msgArea.append($('<div class="clear icons actions float-start">').addClass('short')
			.append(OmUtil.tmpl('#chat-actions-short-template')));
	msgArea.append($('<div class="clear icons actions float-start">').addClass('short-mod')
			.append(OmUtil.tmpl('#chat-actions-short-template'))
			.append(OmUtil.tmpl('#chat-actions-accept-template')));
	msgArea.append($('<div class="clear icons actions float-start">').addClass('full')
			.append(OmUtil.tmpl('#chat-actions-short-template'))
			.append(OmUtil.tmpl('#chat-actions-others-template').children().clone()));
	msgArea.append($('<div class="clear icons actions float-start">').addClass('full-mod')
			.append(OmUtil.tmpl('#chat-actions-short-template'))
			.append(OmUtil.tmpl('#chat-actions-others-template').children().clone())
			.append(OmUtil.tmpl('#chat-actions-accept-template')));
	const actions = __hideActions();
	actions.find('.user').off().click(function() {
		const e = $(this).parent();
		showUserInfo(e.data("userId"));
	});
	actions.find('.add').off().click(function() {
		const e = $(this).parent();
		addContact(e.data("userId"));
	});
	actions.find('.new-email').off().click(function() {
		const e = $(this).parent();
		privateMessage(e.data("userId"));
	});
	actions.find('.invite').off().click(function() {
		const e = $(this).parent();
		inviteUser(e.data("userId"));
	});
	actions.find('.accept').off().click(function() {
		const e = $(this).parent()
			, msgId = e.data('msgId');
		chatActivity('accept', e.data('roomId'), msgId);
		__hideActions();
		$('#chat-msg-id-' + msgId).remove();
	});
	activateTab(id);
}
function __hideActions() {
	return $('#chat .tab-content .messageArea .icons').hide();
}
function __getActions(row) {
	return row.closest('.messageArea').find('.actions.' + row.data('actions'));
}
function _addMessage(m) {
	if ($('#chat').length > 0 && m && m.type === "chat") {
		let msg, cm, notify = false;
		while (!!(cm = m.msg.pop())) {
			let area = $('#' + cm.scope);
			if (cm.from.id !== userId && (isClosed() || !area.is(':visible'))) {
				notify = true;
			}
			const actions = ('full' === cm.actions ? 'full' : 'short') + (cm.needModeration ? '-mod' : '');
			msg = OmUtil.tmpl('#chat-msg-template', msgIdPrefix + cm.id)
			const row = msg.find('.user-row')
				.data('userId', cm.from.id)
				.data('actions', actions)
				.mouseenter(function() {
					__hideActions();
					__getActions($(this))
						.data('userId', $(this).data('userId'))
						.data('roomId', $(this).data('roomId'))
						.data('msgId', $(this).data('msgId'))
						.css('top', ($(this).closest('.msg-row')[0].offsetTop + 20) + 'px')
						.show();
				});
			if (cm.needModeration) {
				row.parent().addClass('need-moderation');
				row.data('roomId', cm.scope.substring(9))
					.data('msgId', cm.id);
			}
			area.mouseleave(function() {
				__hideActions();
			});
			msg.find('.from').data('user-id', cm.from.id).html(cm.from.displayName || cm.from.name);
			msg.find('.time').html(cm.time).attr('title', cm.sent);
			if (!area.length) {
				_addTab(cm.scope, cm.scopeName);
				area = $('#' + cm.scope);
			}
			if (m.mode === "accept") {
				$('#chat-msg-id-' + cm.id).remove();
			}
			const btm = area[0].scrollHeight - (area.scrollTop() + area.innerHeight()) < 3; //approximately equal
			if (area.data('lastDate') !== cm.date) {
				area.append(OmUtil.tmpl('#chat-date-template').html(cm.date).mouseenter(function() {
					__hideActions();
				}));
				area.data('lastDate', cm.date);
			}
			area.append(msg);
			msg.find('.user-row')[0].style.cssText = `
				background-image: url(${(!!cm.from.img ? cm.from.img : './profile/' + cm.from.id + '?anticache=' + Date.now())});
				background-position-x: ${Settings.isRtl ? 'right' : 'left'};
			`;

			msg.find('.msg').html(CSSEmoticon.emoticonize(!!cm.message ? cm.message : ""));
			if (btm) {
				_scrollDown(area);
			}
		}
		if (notify) {
			ctrlBlk.addClass('bg-warning');
			if (chatPanel.is(':visible') && !muted) {
				OmUtil.notify(newMsgNotification, 'new_chat_msg', () => {
					// impossible to use Notification API from iFrame
					audio.play()
						.then(function() {
							// Automatic playback started!
						}).catch(function() {
							// Automatic playback failed.
						});
				});
			}
		}
		CSSEmoticon.animate();
	}
}
function _setOpened() {
	__setCssWidth(openedWidth);
	chatPanel.resizable({
		handles: (Settings.isRtl ? 'e' : 'w')
		, minWidth: 165
		, stop: function(_, ui) {
			chatPanel.css({'left': '', 'width': '', 'height': ''});
			openedWidth = ui.size.width + 'px';
			__setCssWidth(openedWidth);
		}
	});
}
function _removeResize() {
	if (chatPanel.resizable('instance') !== undefined) {
		chatPanel.resizable('destroy');
	}
}
function _open(handler) {
	if (isClosed()) {
		ctrlBlk.removeClass('bg-warning');
		let opts;
		if (roomMode) {
			opts = {width: openedWidth};
		} else {
			opts = {height: openedHeight};
			chatPanel.resizable("option", "disabled", false);
		}
		chatPanel.removeClass('closed').animate(opts, 1000, function() {
			__hideActions();
			chatPanel.removeClass('closed');
			chatPanel.css({'height': '', 'width': ''});
			if (typeof(handler) === 'function') {
				handler();
			}
			ctrlBlk.attr('title', ctrlBlk.data('ttl-undock'));
			if (roomMode) {
				_setOpened();
				if (typeof(window.WbArea) === 'object') {
					window.WbArea.resize();
				}
			} else {
				__setCssHeight(openedHeight);
			}
			_setAreaHeight();
		});
	}
}
function _close(handler) {
	if (!isClosed()) {
		let opts;
		if (roomMode) {
			opts = {width: closedSizePx};
		} else {
			opts = {height: closedSizePx};
			chatPanel.resizable("option", "disabled", true);
		}
		chatPanel.animate(opts, 1000, function() {
			chatPanel.addClass('closed').css({'height': '', 'width': ''});
			if (roomMode) {
				__setCssWidth(closedSizePx);
				_removeResize();
				if (typeof(window.WbArea) === 'object') {
					window.WbArea.resize();
				}
			} else {
				__setCssHeight(closedSizePx);
			}
			if (typeof(handler) === 'function') {
				handler();
			}
			ctrlBlk.attr('title', ctrlBlk.data('ttl-dock'));
		});
	}
}
function _toggle() {
	if (isClosed()) {
		_open();
	} else {
		_close();
	}
}
function _editorAppend(_emoticon) {
	editor.html(editor.html() + ' ' + _emoticon + ' ').trigger('change');
}
function _clean() {
	editor.html('').trigger('change');
}
function _setRoomMode(_mode) {
	roomMode = _mode;
	if (inited && !roomMode) {
		// remove all private chats on room exit
		$('li[aria-controls^="chatTab-u"]').remove();
		$('div[id^="chatTab-u"]').remove();
	}
	_reinit({userId: userId, all: allPrefix, room: roomPrefix, sendOnEnter: sendOn === SEND_ENTER});
}
function _scrollDown(area) {
	area.animate({
		scrollTop: area[0].scrollHeight
	}, 300);
}
function _setAreaHeight() {
	$('#chat .messageArea').each(function() {
		_scrollDown($(this));
	});
}
function _insertLink() {
	const text = $('#chat #hyperlink').parent().find('input').val();
	if ('' === text) {
		return;
	}
	let url = text.trim();
	if ('' === url) {
		return;
	}
	if (!/^(https?:)?\/\//i.test(url)) {
		url = 'http://' + url;
	}
	const a = $('<div>').append($('<a></a>').attr('target', '_blank').attr('href', url).text(url)).html();
	if (window.getSelection) {
		const sel = window.getSelection();
		if (sel.rangeCount) {
			const range = sel.getRangeAt(0);
			if ($(range.startContainer).parents('.wysiwyg-editor').length > 0) {
				range.deleteContents();
				range.insertNode(a);
			} else {
				_editorAppend(a);
			}
		}
	}
}
function _typingActivity(uid, active) {
	if (typeof(Room) !== 'object') {
		return;
	}
	const c = Room.getClient(uid);
	if (!c) {
		return;
	}
	const u = c.find('.typing-activity');
	if (!u) {
		return;
	}
	if (active) {
		u.addClass("typing");
	} else {
		u.removeClass("typing");
	}
}

$(function() {
	Wicket.Event.subscribe("/websocket/message", function(_, msg) {
		try {
			if (msg instanceof Blob) {
				return; //ping
			}
			const m = JSON.parse(msg);
			if (m) {
				switch(m.type) {
					case "chat":
						if ('clean' === m.action) {
							$('#' + m.scope).html('');
						} else {
							_addMessage(m);
						}
						break;
					case "typing":
						_typingActivity(m.uid, m.active);
						break;
				}
			}
		} catch (err) {
			//no-op
		}
	});
	function _cancelAskNotification() {
		$(document).off('click', _askNotification)
	}
	function _askNotification() {
		OmUtil.requestNotifyPermission(_cancelAskNotification, _cancelAskNotification);
	}
	$(document).on('click', _askNotification);
});

module.exports = {
	SEND_ENTER: SEND_ENTER
	, SEND_CTRL: SEND_CTRL

	, reinit: _reinit
	, removeTab: _removeTab
	, addTab: _addTab
	, addMessage: _addMessage
	, open: _open
	, setOpened: function() {
		_open(function() {
			_setOpened();
		});
	}
	, close: _close
	, toggle: _toggle
	, setRoomMode: _setRoomMode
	, clean: _clean
	, reload: () => {
		_load();
		_updateAudioBtn();
		_updateSendBtn();
	}
	, validate: function() {
		return !!editor && editor.text().trim().length > 0;
	}
};


/***/ }),

/***/ "./src/chat/cssemoticons.js":
/*!**********************************!*\
  !*** ./src/chat/cssemoticons.js ***!
  \**********************************/
/***/ ((module) => {

/*
 * Based on
 *
 * jQuery CSSEmoticons plugin 0.2.9
 *
 * Copyright (c) 2010 Steve Schwartz (JangoSteve)
 *
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 * Date: Sun Oct 22 1:00:00 2010 -0500
 */
const escapeCharacters = [")", "(", "*", "[", "]", "{", "}", "|", "^", "<", ">", "\\", "?", "+", "=", "."]
	, specialRegex = new RegExp('(\\' + escapeCharacters.join('|\\') + ')', 'g')
	// One of these characters must be present before the matched emoticon, or the matched emoticon must be the first character in the container HTML
	//  This is to ensure that the characters in the middle of HTML properties or URLs are not matched as emoticons
	//  Below matches ^ (first character in container HTML), \s (whitespace like space or tab), or \0 (NULL character)
	// (<\\S+.*>) matches <\\S+.*> (matches an HTML tag like <span> or <div>), but haven't quite gotten it working yet, need to push this fix now
	, preMatch = '(^|[\\s\\0])'
	, emoticons = []
	, matchers = []
	, defaults = {animate: true, delay: 500, exclude: 'pre,code,.no-emoticons'};

function createMatcher(m) {
	const str = m.text.replace(specialRegex, '\\$1');
	m.regexp = new RegExp(preMatch + '(' + str + ')', 'g');
	return m;
}
function addMatchers(arr) {
	for (let i = 0; i < arr.length; ++i) {
		const o = arr[i]
		let m = typeof(o) === 'object' ? JSON.parse(JSON.stringify(o)) : {text: o, cssClass: ' '};
		emoticons.push(m.text);

		matchers.push(createMatcher(m));
		if (m.text.indexOf('=') > -1) {
			m = JSON.parse(JSON.stringify(m));
			m.text = m.text.replace(/=/g, '&#61;').replace(/[+]/g, '&#43;');
			matchers.push(createMatcher(m));
		}
		if (m.text.indexOf('\'') > -1) {
			m = JSON.parse(JSON.stringify(m));
			m.text = m.text.replace(/'/g, '&#39;');
			matchers.push(createMatcher(m));
		}
	}
}
addMatchers([
	":-)", ":o)", ":c)", ":^)", ":-D", ":-(", ":-9", ";-)", ":-P", ":-p", ":-Þ", ":-b", ":-O", ":-/", ":-X", ":-#", ":'(", "B-)", "8-)", ";*(", ":-*", ":-\\",
	"?-)" // <== This is my own invention, it's a smiling pirate (with an eye-patch)!
]);
addMatchers([ // separate these out so that we can add a letter-spacing between the characters for better proportions
	":)", ":]", "=]", "=)", "8)", ":}", ":D", ":(", ":[", ":{", "=(", ";)", ";]", ";D", ":P", ":p", "=P", "=p", ":b", ":Þ", ":O", ":/", "=/", ":S", ":#", ":X", "B)", ":|", ":\\", "=\\", ":*", ":&gt;", ":&lt;"
]);
addMatchers([ // emoticons to be treated with a special class, hash specifies the additional class to add, along with standard css-emoticon class
	{text: "&gt;:)", cssClass: "red-emoticon small-emoticon spaced-emoticon"},
	{text: "&gt;;)", cssClass: "red-emoticon small-emoticon spaced-emoticon"},
	{text: "&gt;:(", cssClass: "red-emoticon small-emoticon spaced-emoticon"},
	{text: "&gt;: )", cssClass: "red-emoticon small-emoticon"},
	{text: "&gt;; )", cssClass: "red-emoticon small-emoticon"},
	{text: "&gt;: (", cssClass: "red-emoticon small-emoticon"},
	{text: ";(", cssClass: "red-emoticon spaced-emoticon"},
	{text: "&lt;3", cssClass: "pink-emoticon counter-rotated"},
	{text: "O_O", cssClass: "no-rotate"},
	{text: "o_o", cssClass: "no-rotate"},
	{text: "0_o", cssClass: "no-rotate"},
	{text: "O_o", cssClass: "no-rotate"},
	{text: "T_T", cssClass: "no-rotate"},
	{text: "^_^", cssClass: "no-rotate"},
	{text: "O:)", cssClass: "small-emoticon spaced-emoticon"},
	{text: "O: )", cssClass: "small-emoticon"},
	{text: "8D", cssClass: "small-emoticon spaced-emoticon"},
	{text: "XD", cssClass: "small-emoticon spaced-emoticon"},
	{text: "xD", cssClass: "small-emoticon spaced-emoticon"},
	{text: "=D", cssClass: "small-emoticon spaced-emoticon"},
	{text: "8O", cssClass: "small-emoticon spaced-emoticon"},
	{text: "[+=..]", cssClass: "no-rotate nintendo-controller"}
]);

module.exports = {
	emoticons: emoticons
	, matchers: matchers
	, defaults: defaults
	, emoticonize: function(str, options) {
		const opts = $.extend({}, defaults, options);

		let cssClass = 'css-emoticon';
		if (opts.animate) {
			cssClass += ' un-transformed-emoticon animated-emoticon';
		}
		for (let i = 0; i < matchers.length; ++i) {
			const m = matchers[i];
			const css = cssClass + " " + m.cssClass;
			str = str.replace(m.regexp, "$1<span class='" + css + "'>$2</span>");
		}
		return str;
	}
	, animate: function(options) {
		const opts = $.extend({}, defaults, options);
		// animate emoticons
		if (opts.animate) {
			setTimeout(function () {
				$('.un-transformed-emoticon').removeClass('un-transformed-emoticon');
			}, opts.delay);
		}
	}
};


/***/ }),

/***/ "../main/omutils":
/*!*************************!*\
  !*** external "OmUtil" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = OmUtil;

/***/ }),

/***/ "../main/settings":
/*!***************************!*\
  !*** external "Settings" ***!
  \***************************/
/***/ ((module) => {

"use strict";
module.exports = Settings;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!***************************!*\
  !*** ./src/chat/index.js ***!
  \***************************/
/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
Object.assign(window, {
	Chat: __webpack_require__(/*! ./chat */ "./src/chat/chat.js")
});

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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