/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OfficeDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeDescriptor.class);
    private static final String LIBRE_OFFICE = "LibreOffice";
    private static final String OPEN_OFFICE = "OpenOffice";
    private static final String LIBRE_OFFICE_LCASE = "libreoffice";
    private static final String OPEN_OFFICE_LCASE = "openoffice";
    private String product = "???";
    private String version = "???";
    private boolean useLongOptionNameGnuStyle;

    private OfficeDescriptor() {
    }

    public static @NonNull OfficeDescriptor fromHelpOutput(@NonNull List<@NonNull String> lines) {
        OfficeDescriptor desc = new OfficeDescriptor();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Building {} from help output lines", (Object)OfficeDescriptor.class.getName());
        }
        for (String line : lines) {
            if (line.contains("--help")) {
                desc.useLongOptionNameGnuStyle = true;
                continue;
            }
            OfficeDescriptor.fromLine(desc, line);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("soffice info (from help output): {}", (Object)desc);
        }
        return desc;
    }

    private static void fromLine(OfficeDescriptor desc, String line) {
        String productLine;
        String[] parts;
        String lowerLine = line.trim().toLowerCase(Locale.ROOT);
        if ((lowerLine.startsWith(OPEN_OFFICE_LCASE) || lowerLine.startsWith(LIBRE_OFFICE_LCASE)) && (parts = (productLine = line.trim()).split(" ")).length > 0) {
            desc.product = parts[0];
            if (parts.length > 1) {
                desc.version = parts[1];
            }
        }
    }

    public static @NonNull OfficeDescriptor fromExecutablePath(@NonNull String path) {
        OfficeDescriptor desc = new OfficeDescriptor();
        String lowerPath = path.toLowerCase(Locale.ROOT);
        if (lowerPath.contains(LIBRE_OFFICE_LCASE)) {
            desc.product = LIBRE_OFFICE;
            desc.useLongOptionNameGnuStyle = true;
        } else if (lowerPath.contains(OPEN_OFFICE_LCASE)) {
            desc.product = OPEN_OFFICE;
            desc.useLongOptionNameGnuStyle = false;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("soffice info (from exec path): {}", (Object)desc);
        }
        return desc;
    }

    public @NonNull String getProduct() {
        return this.product;
    }

    public @NonNull String getVersion() {
        return this.version;
    }

    public boolean useLongOptionNameGnuStyle() {
        return this.useLongOptionNameGnuStyle;
    }

    public @NonNull String toString() {
        return String.format("Product: %s - Version: %s - useLongOptionNameGnuStyle: %s", this.getProduct(), this.getVersion(), this.useLongOptionNameGnuStyle());
    }
}

