/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav;

import jakarta.inject.Inject;
import java.net.URI;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.immutable.ImmutableCalScale;
import net.fortuna.ical4j.model.property.immutable.ImmutableTransp;
import net.fortuna.ical4j.model.property.immutable.ImmutableVersion;
import net.fortuna.ical4j.transform.recurrence.Frequency;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.mail.IcalHandler;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IcalUtils {
    private static final Logger log = LoggerFactory.getLogger(IcalUtils.class);
    private static final List<String> acceptedFormats = List.of("yyyyMMdd'T'HHmmss", "yyyyMMdd'T'HHmmss'Z'", "yyyyMMdd");
    public static final String PROD_ID = "-//Events Calendar//Apache Openmeetings//EN";
    @Inject
    private UserDao userDao;

    public Appointment parseCalendartoAppointment(net.fortuna.ical4j.model.Calendar calendar, String href, String etag, OmCalendar omCalendar) {
        Appointment a = new Appointment();
        a.setId(null);
        a.setDeleted(false);
        a.setHref(href);
        a.setCalendar(omCalendar);
        a.setOwner(omCalendar.getOwner());
        a.setRoom(IcalUtils.createDefaultRoom());
        a.setReminder(Appointment.Reminder.NONE);
        return this.parseCalendartoAppointment(a, calendar, etag);
    }

    public List<Appointment> parseCalendartoAppointments(net.fortuna.ical4j.model.Calendar calendar, Long ownerId) {
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        List events = calendar.getComponents(new String[]{"VEVENT"});
        User owner = this.userDao.get(ownerId);
        for (CalendarComponent event : events) {
            Appointment a = new Appointment();
            a.setOwner(owner);
            a.setDeleted(false);
            a.setRoom(IcalUtils.createDefaultRoom());
            a.setReminder(Appointment.Reminder.NONE);
            appointments.add(this.addVEventPropertiestoAppointment(a, event));
        }
        return appointments;
    }

    public Appointment parseCalendartoAppointment(Appointment a, net.fortuna.ical4j.model.Calendar calendar, String etag) {
        if (calendar == null) {
            return a;
        }
        calendar.getComponent("VEVENT").ifPresent(event -> {
            a.setEtag(etag);
            this.addVEventPropertiestoAppointment(a, (CalendarComponent)event);
        });
        return a;
    }

    private Date getDate(CalendarComponent event, String prop) {
        return this.getDate(event.getProperty(prop).orElse(null));
    }

    private Date getDate(Property prop) {
        return prop == null ? null : Date.from(Instant.from(((DateProperty)prop).getDate()));
    }

    private Appointment addVEventPropertiestoAppointment(Appointment a, CalendarComponent event) {
        event.getProperty("UID").ifPresent(uid -> a.setIcalId(uid.getValue()));
        Date d = this.getDate(event, "DTSTART");
        a.setStart(this.getDate(event, "DTSTART"));
        event.getProperty("DTEND").ifPresentOrElse(dtend -> a.setEnd(this.getDate((Property)dtend)), () -> a.setEnd(this.addTimetoDate(d, 11, 1)));
        event.getProperty("DTSTAMP").ifPresent(dtstamp -> a.setInserted(this.getDate((Property)dtstamp)));
        event.getProperty("LAST-MODIFIED").ifPresent(lastmod -> a.setUpdated(this.getDate((Property)lastmod)));
        event.getProperty("DESCRIPTION").ifPresent(description -> a.setDescription(description.getValue()));
        event.getProperty("SUMMARY").ifPresent(summary -> a.setTitle(summary.getValue()));
        event.getProperty("LOCATION").ifPresent(location -> a.setLocation(location.getValue()));
        event.getProperty("RRULE").ifPresent(recur -> recur.getParameter("FREQ").ifPresent(freq -> {
            if (freq.getValue().equals(Frequency.DAILY.name())) {
                a.setIsDaily(Boolean.valueOf(true));
            } else if (freq.getValue().equals(Frequency.WEEKLY.name())) {
                a.setIsWeekly(Boolean.valueOf(true));
            } else if (freq.getValue().equals(Frequency.MONTHLY.name())) {
                a.setIsMonthly(Boolean.valueOf(true));
            } else if (freq.getValue().equals(Frequency.YEARLY.name())) {
                a.setIsYearly(Boolean.valueOf(true));
            }
        }));
        HashSet attList = a.getMeetingMembers() == null ? new HashSet() : new HashSet(a.getMeetingMembers());
        AtomicReference organizerEmail = new AtomicReference();
        event.getProperty("ORGANIZER").ifPresent(organizer -> {
            URI uri = URI.create(organizer.getValue());
            if ("mailto".equals(uri.getScheme())) {
                String email = uri.getSchemeSpecificPart();
                organizerEmail.set(email);
                if (!email.equals(a.getOwner().getAddress().getEmail())) {
                    User org = this.userDao.getByEmail(email);
                    if (org == null) {
                        org = this.userDao.getContact(email, a.getOwner());
                        attList.add(IcalUtils.createMeetingMember(a, org));
                    } else if (!org.getId().equals(a.getOwner().getId())) {
                        attList.add(IcalUtils.createMeetingMember(a, org));
                    }
                }
            }
        });
        event.getProperties(new String[]{"ATTENDEE"}).forEach(attendee -> {
            URI uri = URI.create(attendee.getValue());
            if ("mailto".equals(uri.getScheme())) {
                String email = uri.getSchemeSpecificPart();
                Optional role = attendee.getParameter(Role.CHAIR.getName());
                if (role.isPresent() && ((Role)role.get()).getValue().equals(Role.CHAIR.getValue()) && email.equals(organizerEmail.get())) {
                    return;
                }
                User u = this.userDao.getByEmail(email);
                if (u == null) {
                    u = this.userDao.getContact(email, a.getOwner());
                }
                attList.add(IcalUtils.createMeetingMember(a, u));
            }
        });
        a.setMeetingMembers((List)(attList.isEmpty() ? null : new ArrayList(attList)));
        return a;
    }

    private static MeetingMember createMeetingMember(Appointment a, User u) {
        MeetingMember mm = new MeetingMember();
        mm.setUser(u);
        mm.setDeleted(false);
        mm.setInserted(a.getInserted());
        mm.setUpdated(a.getUpdated());
        mm.setAppointment(a);
        return mm;
    }

    private static Room createDefaultRoom() {
        Room r = new Room();
        r.setAppointment(true);
        if (r.getType() == null) {
            r.setType(Room.Type.CONFERENCE);
        }
        return r;
    }

    public TimeZone parseTimeZone(net.fortuna.ical4j.model.Calendar calendar, User owner) {
        return Optional.ofNullable(calendar).map(cal -> cal.getComponent("VTIMEZONE")).filter(Optional::isPresent).map(Optional::get).map(timezone -> timezone.getProperty("TZID")).filter(Optional::isPresent).map(Optional::get).map(tzid -> TimezoneUtil.getTimeZone((String)tzid.getValue())).orElse(TimezoneUtil.getTimeZone((User)owner));
    }

    public Date parseDate(Property dt, TimeZone timeZone) {
        if (dt == null || Strings.isEmpty((String)dt.getValue())) {
            return null;
        }
        return dt.getParameter("TZID").map(tzid -> this.parseDate(dt.getValue(), TimezoneUtil.getTimeZone((String)tzid.getValue()))).orElse(this.parseDate(dt.getValue(), timeZone));
    }

    public Date parseDate(String str, TimeZone inTimeZone) {
        Locale locale = WebSession.get().getLocale();
        TimeZone timeZone = str.endsWith("Z") ? TimeZone.getTimeZone("UTC") : inTimeZone;
        ParsePosition pos = new ParsePosition(0);
        for (String pattern : acceptedFormats) {
            FastDateFormat parser = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone, (Locale)locale);
            pos.setIndex(0);
            Date date = parser.parse(str, pos);
            if (date == null || pos.getIndex() != str.length()) continue;
            return date;
        }
        log.error("Unable to parse the date: {} at {}", (Object)str, (Object)-1);
        return null;
    }

    public Date addTimetoDate(Date date, int field, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(field, amount);
        return c.getTime();
    }

    private net.fortuna.ical4j.model.TimeZone getTimazone(String tzid) {
        net.fortuna.ical4j.model.TimeZone timeZone = IcalHandler.TZ_REGISTRY.getTimeZone(tzid);
        if (timeZone == null) {
            throw new NoSuchElementException("Unable to get time zone by id provided: " + tzid);
        }
        return timeZone;
    }

    private net.fortuna.ical4j.model.Calendar getCalendar(net.fortuna.ical4j.model.TimeZone timeZone, List<CalendarComponent> events) {
        ArrayList<CalendarComponent> comps = new ArrayList<CalendarComponent>(events);
        comps.add(0, (CalendarComponent)timeZone.getVTimeZone());
        return new net.fortuna.ical4j.model.Calendar(new PropertyList(List.of(new ProdId(PROD_ID), ImmutableVersion.VERSION_2_0, ImmutableCalScale.GREGORIAN)), new ComponentList(comps));
    }

    private VEvent parseAppointment(Appointment appointment, net.fortuna.ical4j.model.TimeZone timeZone) {
        Uid ui;
        ZonedDateTime start = CalendarHelper.getZoneDateTime((Date)appointment.getStart(), (String)timeZone.getID());
        ZonedDateTime end = CalendarHelper.getZoneDateTime((Date)appointment.getEnd(), (String)timeZone.getID());
        VEvent meeting = new VEvent((Temporal)start, (Temporal)end, appointment.getTitle());
        ArrayList<Object> mProperties = new ArrayList<Object>(meeting.getProperties());
        if (appointment.getLocation() != null) {
            mProperties.add(new Location(appointment.getLocation()));
        }
        mProperties.add(new Description(appointment.getDescription()));
        mProperties.add(new Sequence(0));
        mProperties.add(ImmutableTransp.OPAQUE);
        String uid = appointment.getIcalId();
        if (uid == null || uid.length() < 1) {
            UUID uuid = UUID.randomUUID();
            appointment.setIcalId(uuid.toString());
            ui = new Uid(uuid.toString());
        } else {
            ui = new Uid(uid);
        }
        mProperties.add(ui);
        if (appointment.getMeetingMembers() != null) {
            for (MeetingMember meetingMember : appointment.getMeetingMembers()) {
                mProperties.add(new Attendee(new ParameterList(List.of(Role.REQ_PARTICIPANT, new Cn(meetingMember.getUser().getLogin()))), URI.create("mailto:" + meetingMember.getUser().getAddress().getEmail())));
            }
        }
        URI orgUri = URI.create("mailto:" + appointment.getOwner().getAddress().getEmail());
        Cn orgCn = new Cn(appointment.getOwner().getLogin());
        mProperties.add(new Attendee(new ParameterList(List.of(Role.CHAIR, orgCn)), orgUri));
        mProperties.add(new Organizer(new ParameterList(List.of(orgCn)), orgUri));
        meeting.setPropertyList(new PropertyList(mProperties));
        return meeting;
    }

    public net.fortuna.ical4j.model.Calendar parseAppointmenttoCalendar(Appointment appointment) {
        net.fortuna.ical4j.model.TimeZone timeZone = this.getTimazone(this.parseTimeZone(null, appointment.getOwner()).getID());
        return this.getCalendar(timeZone, List.of(this.parseAppointment(appointment, timeZone)));
    }

    public net.fortuna.ical4j.model.Calendar parseAppointmentstoCalendar(List<Appointment> appointments, Long ownerId) {
        net.fortuna.ical4j.model.TimeZone timeZone = this.getTimazone(this.parseTimeZone(null, this.userDao.get(ownerId)).getID());
        return this.getCalendar(timeZone, appointments.stream().map(appointment -> this.parseAppointment((Appointment)appointment, timeZone)).toList());
    }
}

