/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.util.Objects;

@Deprecated(since="5.4", forRemoval=true)
@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
public class PortableId
implements DataSerializable {
    private int factoryId;
    private int classId;
    private int version;

    @PrivateApi
    public PortableId() {
    }

    public PortableId(int factoryId, int classId, int version) {
        this.factoryId = factoryId;
        this.classId = classId;
        this.version = version;
    }

    public PortableId(String portableId) {
        String[] components = portableId.split(":");
        assert (components.length == 3) : "Number of Portable ID components should always be 3";
        this.factoryId = Integer.parseInt(components[0]);
        this.classId = Integer.parseInt(components[1]);
        this.version = Integer.parseInt(components[2]);
    }

    public int getFactoryId() {
        return this.factoryId;
    }

    public int getClassId() {
        return this.classId;
    }

    public int getVersion() {
        return this.version;
    }

    @PrivateApi
    public void setVersionIfNotSet(int version) {
        if (this.version < 0) {
            this.version = version;
        }
    }

    public String toString() {
        return this.factoryId + ":" + this.classId + ":" + this.version;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.factoryId);
        out.writeInt(this.classId);
        out.writeInt(this.version);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.factoryId = in.readInt();
        this.classId = in.readInt();
        this.version = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortableId that = (PortableId)o;
        return this.factoryId == that.factoryId && this.classId == that.classId && this.version == that.version;
    }

    public int hashCode() {
        return Objects.hash(this.factoryId, this.classId, this.version);
    }
}

