/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicates;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.log.ConferenceLogDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.log.ConferenceLog;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.mediaserver.KurentoHandler;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.TimerService;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.pages.auth.SignInPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClientManager
implements IClientManager {
    private static final Logger log = LoggerFactory.getLogger(ClientManager.class);
    private static final String ROOMS_KEY = "ROOMS_KEY";
    private static final String ONLINE_USERS_KEY = "ONLINE_USERS_KEY";
    private static final String SERVERS_KEY = "SERVERS_KEY";
    private static final String INSTANT_TOKENS_KEY = "INSTANT_TOKENS_KEY";
    private static final String UID_BY_SID_KEY = "UID_BY_SID_KEY";
    private final Map<String, Client> onlineClients = new ConcurrentHashMap<String, Client>();
    private final Map<Long, Set<String>> onlineRooms = new ConcurrentHashMap<Long, Set<String>>();
    private final Map<String, ServerInfo> onlineServers = new ConcurrentHashMap<String, ServerInfo>();
    @Inject
    private ConferenceLogDao confLogDao;
    @Inject
    private Application app;
    @Inject
    private KurentoHandler kHandler;
    @Inject
    private TimerService timerService;

    private IMap<String, Client> map() {
        return this.app.hazelcast.getMap(ONLINE_USERS_KEY);
    }

    private Map<String, String> mapBySid() {
        return this.app.hazelcast.getMap(UID_BY_SID_KEY);
    }

    private IMap<Long, Set<String>> rooms() {
        return this.app.hazelcast.getMap(ROOMS_KEY);
    }

    private IMap<String, ServerInfo> servers() {
        return this.app.hazelcast.getMap(SERVERS_KEY);
    }

    private IMap<String, InstantToken> tokens() {
        return this.app.hazelcast.getMap(INSTANT_TOKENS_KEY);
    }

    void init() {
        log.debug("Cluster:: PostConstruct");
        this.onlineClients.putAll((Map<String, Client>)this.map());
        this.onlineRooms.putAll((Map<Long, Set<String>>)this.rooms());
        this.onlineServers.putAll((Map<String, ServerInfo>)this.servers());
        this.map().addEntryListener((MapListener)new ClientListener(), true);
        this.rooms().addEntryListener((MapListener)new RoomListener(), true);
        this.servers().addEntryListener((MapListener)((EntryUpdatedListener)event -> {
            log.debug("Cluster:: Server was updated {} -> {}", event.getKey(), event.getValue());
            this.onlineServers.put((String)event.getKey(), (ServerInfo)event.getValue());
        }), true);
    }

    public void add(Client c) {
        this.confLogDao.add(ConferenceLog.Type.CLIENT_CONNECT, c.getUserId(), "0", null, c.getRemoteAddress(), "");
        log.debug("Adding online client: {}, room: {}", (Object)c.getUid(), (Object)c.getRoom());
        c.setServerId(Application.get().getServerId());
        this.map().put((Object)c.getUid(), (Object)c);
        this.onlineClients.put(c.getUid(), c);
        this.mapBySid().put(c.getSid(), c.getUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client update(Client c) {
        this.map().put((Object)c.getUid(), (Object)c);
        Map<String, Client> map = this.onlineClients;
        synchronized (map) {
            this.onlineClients.get(c.getUid()).merge(c);
        }
        return c;
    }

    public Client get(String uid) {
        return uid == null ? null : this.onlineClients.get(uid);
    }

    public Client getBySid(String sid) {
        if (sid == null) {
            return null;
        }
        String uid = this.mapBySid().get(sid);
        return uid == null ? null : this.get(uid);
    }

    public String uidBySid(String sid) {
        if (sid == null) {
            return null;
        }
        return this.mapBySid().get(sid);
    }

    public void exitRoom(Client c) {
        this.exitRoom(c, true);
    }

    public void exitRoom(Client c, boolean update) {
        Long roomId = c.getRoomId();
        log.debug("Removing online room client: {}, room: {}", (Object)c.getUid(), (Object)roomId);
        if (roomId != null) {
            IMap<Long, Set<String>> rooms = this.rooms();
            rooms.lock((Object)roomId);
            Set clients = (Set)rooms.getOrDefault((Object)roomId, ConcurrentHashMap.newKeySet());
            clients.remove(c.getUid());
            rooms.put((Object)roomId, (Object)clients);
            this.onlineRooms.put(roomId, clients);
            rooms.unlock((Object)roomId);
            if (clients.isEmpty()) {
                String serverId = c.getServerId();
                IMap<String, ServerInfo> servers = this.servers();
                servers.lock((Object)serverId);
                ServerInfo si = (ServerInfo)servers.get((Object)serverId);
                si.remove(c.getRoom());
                servers.put((Object)serverId, (Object)si);
                this.onlineServers.put(serverId, si);
                servers.unlock((Object)serverId);
            }
            this.kHandler.leaveRoom(c);
            c.setRoom(null);
            c.clear();
            if (update) {
                this.update(c);
            }
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(roomId, c, RoomMessage.Type.ROOM_EXIT, c.getUid()));
            this.confLogDao.add(ConferenceLog.Type.ROOM_LEAVE, c.getUserId(), "0", roomId, c.getRemoteAddress(), String.valueOf(roomId));
        }
    }

    public void exit(Client c) {
        if (c != null) {
            this.confLogDao.add(ConferenceLog.Type.CLIENT_DISCONNECT, c.getUserId(), "0", null, c.getRemoteAddress(), "");
            this.exitRoom(c, false);
            this.kHandler.remove((IWsClient)c);
            log.debug("Removing online client: {}, roomId: {}", (Object)c.getUid(), (Object)c.getRoomId());
            this.map().remove((Object)c.getUid());
            this.onlineClients.remove(c.getUid());
            this.mapBySid().remove(c.getSid());
        }
    }

    public void serverAdded(String serverId, String url) {
        this.onlineServers.computeIfAbsent(serverId, id -> {
            ServerInfo si = new ServerInfo(url);
            this.servers().put(id, (Object)si);
            log.debug("Cluster:: server with id '{}' was added", id);
            return si;
        });
    }

    public void serverRemoved(String serverId) {
        IMap<String, Client> clients = this.map();
        for (Map.Entry e : clients.entrySet()) {
            if (!serverId.equals(((Client)e.getValue()).getServerId())) continue;
            this.exit((Client)e.getValue());
        }
        log.debug("Cluster:: server with id '{}' was removed", (Object)serverId);
        this.servers().remove((Object)serverId);
        this.onlineServers.remove(serverId);
    }

    public int addToRoom(Client c) {
        Room r = c.getRoom();
        Long roomId = r.getId();
        this.confLogDao.add(ConferenceLog.Type.ROOM_ENTER, c.getUserId(), "0", roomId, c.getRemoteAddress(), String.valueOf(roomId));
        log.debug("Adding online room client: {}, room: {}", (Object)c.getUid(), (Object)roomId);
        IMap<Long, Set<String>> rooms = this.rooms();
        rooms.lock((Object)roomId);
        Set set = (Set)rooms.getOrDefault((Object)roomId, ConcurrentHashMap.newKeySet());
        set.add(c.getUid());
        int count = set.size();
        rooms.put((Object)roomId, (Object)set);
        this.onlineRooms.put(roomId, set);
        rooms.unlock((Object)roomId);
        String serverId = c.getServerId();
        this.addRoomToServer(serverId, r);
        this.update(c);
        this.timerService.scheduleSipCheck(r);
        return count;
    }

    private void addRoomToServer(String serverId, Room r) {
        if (!this.onlineServers.get(serverId).getRooms().contains(r.getId())) {
            log.debug("Cluster:: room {} was not found for server '{}', adding ...", (Object)r.getId(), (Object)serverId);
            IMap<String, ServerInfo> servers = this.servers();
            servers.lock((Object)serverId);
            ServerInfo si = (ServerInfo)servers.get((Object)serverId);
            si.add(r);
            servers.put((Object)serverId, (Object)si);
            this.onlineServers.put(serverId, si);
            servers.unlock((Object)serverId);
        }
    }

    public boolean isOnline(Long userId) {
        boolean isUserOnline = false;
        for (Map.Entry e : this.map().entrySet()) {
            if (!((Client)e.getValue()).sameUserId(userId)) continue;
            isUserOnline = true;
            break;
        }
        return isUserOnline;
    }

    public Stream<Client> stream() {
        return this.map().values().stream();
    }

    public Collection<Client> listByUser(Long userId) {
        return this.map().values(Predicates.equal((String)"userId", (Comparable)userId));
    }

    public Stream<Client> streamByRoom(Long roomId) {
        return Optional.ofNullable(roomId).map(id -> this.onlineRooms.getOrDefault(id, Set.of())).stream().flatMap(Collection::stream).map(this::get).filter(Objects::nonNull);
    }

    public boolean isInRoom(long roomId, long userId) {
        return Optional.of(roomId).map(id -> this.onlineRooms.getOrDefault(id, Set.of())).stream().flatMap(Collection::stream).map(this::get).anyMatch(c -> c != null && c.sameUserId(Long.valueOf(userId)));
    }

    private List<Client> getByKeys(Long userId, String sessionId) {
        return this.map().values().stream().filter(c -> c.sameUserId(userId) && c.getSessionId().equals(sessionId)).toList();
    }

    public void invalidate(Long userId, String sessionId) {
        for (Client c : this.getByKeys(userId, sessionId)) {
            Map<String, String> invalid = Application.get().getInvalidSessions();
            invalid.putIfAbsent(sessionId, c.getUid());
            this.exit(c);
        }
    }

    private String getServerUrl(Map.Entry<String, ServerInfo> e, Room r, UnaryOperator<String> generator) {
        String serverId;
        String curServerId = this.app.getServerId();
        if (!curServerId.equals(serverId = e.getKey())) {
            this.addRoomToServer(serverId, r);
            return (String)generator.apply(e.getValue().getUrl());
        }
        return null;
    }

    public String getServerUrl(Room r, UnaryOperator<String> inGenerator) {
        if (this.onlineServers.size() == 1) {
            log.debug("Cluster:: The only server found");
            return null;
        }
        UnaryOperator generator = inGenerator == null ? baseUrl -> {
            String uuid = UUID.randomUUID().toString();
            this.tokens().put((Object)uuid, (Object)new InstantToken(WebSession.getUserId(), r.getId()));
            return Application.urlForPage(SignInPage.class, new PageParameters().add("token", (Object)uuid), baseUrl);
        } : inGenerator;
        Optional<Map.Entry> existing = this.onlineServers.entrySet().stream().filter(e -> ((ServerInfo)e.getValue()).getRooms().contains(r.getId())).findFirst();
        if (existing.isPresent()) {
            return this.getServerUrl(existing.get(), r, generator);
        }
        Optional min = this.onlineServers.entrySet().stream().min((e1, e2) -> ((ServerInfo)e1.getValue()).getCapacity() - ((ServerInfo)e2.getValue()).getCapacity());
        return this.getServerUrl((Map.Entry)min.get(), r, generator);
    }

    Optional<InstantToken> getToken(StringValue uuid) {
        log.debug("Cluster:: Checking token {}, full list: {}", (Object)uuid, (Object)this.tokens().entrySet());
        return uuid.isEmpty() ? Optional.empty() : Optional.ofNullable((InstantToken)this.tokens().remove((Object)uuid.toString()));
    }

    public class ClientListener
    implements EntryAddedListener<String, Client>,
    EntryUpdatedListener<String, Client>,
    EntryRemovedListener<String, Client> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(EntryEvent<String, Client> event, boolean shouldAdd) {
            if (event.getMember().localMember()) {
                return;
            }
            String uid = (String)event.getKey();
            Map<String, Client> map = ClientManager.this.onlineClients;
            synchronized (map) {
                if (ClientManager.this.onlineClients.containsKey(uid)) {
                    ClientManager.this.onlineClients.get(uid).merge((Client)event.getValue());
                } else if (shouldAdd) {
                    ClientManager.this.onlineClients.put(uid, (Client)event.getValue());
                }
            }
        }

        public void entryAdded(EntryEvent<String, Client> event) {
            this.process(event, true);
        }

        public void entryUpdated(EntryEvent<String, Client> event) {
            this.process(event, false);
        }

        public void entryRemoved(EntryEvent<String, Client> event) {
            log.trace("ClientListener::Remove");
            ClientManager.this.onlineClients.remove(event.getKey());
        }
    }

    public class RoomListener
    implements EntryAddedListener<Long, Set<String>>,
    EntryUpdatedListener<Long, Set<String>>,
    EntryRemovedListener<Long, Set<String>> {
        public void entryAdded(EntryEvent<Long, Set<String>> event) {
            log.trace("RoomListener::Add");
            ClientManager.this.onlineRooms.put((Long)event.getKey(), (Set)event.getValue());
        }

        public void entryUpdated(EntryEvent<Long, Set<String>> event) {
            log.trace("RoomListener::Update");
            ClientManager.this.onlineRooms.put((Long)event.getKey(), (Set)event.getValue());
        }

        public void entryRemoved(EntryEvent<Long, Set<String>> event) {
            log.trace("RoomListener::Remove");
            ClientManager.this.onlineRooms.remove(event.getKey(), event.getValue());
        }
    }

    private static class ServerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int capacity = 0;
        private final String url;
        private final Set<Long> rooms = new HashSet<Long>();

        public ServerInfo(String url) {
            this.url = url;
        }

        public void add(Room r) {
            if (this.rooms.add(r.getId())) {
                log.debug("Cluster:: room {} is added to server, whole list {}", (Object)r.getId(), this.rooms);
                this.capacity = (int)((long)this.capacity + r.getCapacity());
            }
        }

        public void remove(Room r) {
            if (this.rooms.remove(r.getId())) {
                log.debug("Cluster:: room {} is removed from server, whole list {}", (Object)r.getId(), this.rooms);
                this.capacity = (int)((long)this.capacity - r.getCapacity());
            }
        }

        public String getUrl() {
            return this.url;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public Set<Long> getRooms() {
            return this.rooms;
        }

        public String toString() {
            return "ServerInfo[rooms: " + this.rooms + "]";
        }
    }

    public static class InstantToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long userId;
        private final long roomId;
        private final long created;

        InstantToken(long userId, long roomId) {
            this.userId = userId;
            this.roomId = roomId;
            this.created = System.currentTimeMillis();
        }

        public long getUserId() {
            return this.userId;
        }

        public long getRoomId() {
            return this.roomId;
        }
    }
}

