/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.calendar6;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.ui.calendar6.CalendarBehavior;
import org.wicketstuff.jquery.ui.calendar6.CalendarModel;
import org.wicketstuff.jquery.ui.calendar6.CalendarModelBehavior;
import org.wicketstuff.jquery.ui.calendar6.EventSource;
import org.wicketstuff.jquery.ui.calendar6.ICalendarListener;

public class Calendar
extends WebMarkupContainer
implements ICalendarListener {
    private static final long serialVersionUID = 1L;
    private List<EventSource> sources;
    private CalendarModelBehavior modelBehavior;
    private CalendarBehavior behavior;
    protected final Options options;

    public Calendar(String id, Options options) {
        super(id);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public Calendar(String id, CalendarModel model) {
        this(id, model, new Options());
    }

    public Calendar(String id, CalendarModel model, Options options) {
        super(id, (IModel)model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public CalendarModel getModel() {
        return (CalendarModel)this.getDefaultModel();
    }

    public void addSource(EventSource source) {
        if (this.sources == null) {
            this.sources = Generics.newArrayList();
        }
        this.sources.add(source);
    }

    public void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("document.querySelector('%s').calendar.refetchEvents();", IJQueryWidget.JQueryWidget.getSelector((Component)this)));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.modelBehavior = this.newCalendarModelBehavior(this.getModel());
        this.behavior = new CalendarBehavior(IJQueryWidget.JQueryWidget.getSelector((Component)this), this.options, this);
        this.add(new Behavior[]{this.behavior, this.modelBehavior});
    }

    public void onConfigure() {
        super.onConfigure();
        StringBuilder sourceBuilder = new StringBuilder();
        sourceBuilder.append("{ url: '" + this.modelBehavior.getCallbackUrl() + "' }");
        if (this.sources != null) {
            for (EventSource source : this.sources) {
                sourceBuilder.append(", ");
                sourceBuilder.append(source.toString());
            }
        }
        this.behavior.setOption("eventSources", "[" + sourceBuilder + "]");
    }

    protected CalendarModelBehavior newCalendarModelBehavior(CalendarModel model) {
        return new CalendarModelBehavior(model);
    }
}

