/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.graph;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.lib.graph.Edge;
import org.apache.openjpa.lib.graph.Graph;
import org.apache.openjpa.lib.graph.NodeInfo;
import org.apache.openjpa.lib.util.Localizer;

public class DepthFirstAnalysis {
    private static final Localizer _loc = Localizer.forPackage(DepthFirstAnalysis.class);
    private final Graph _graph;
    private final Map<Object, NodeInfo> _nodeInfo = new HashMap<Object, NodeInfo>();
    private Comparator<Object> _comp;

    public DepthFirstAnalysis(Graph graph) {
        this._graph = graph;
        Collection<Object> nodes = graph.getNodes();
        for (Object node : nodes) {
            this._nodeInfo.put(node, new NodeInfo());
        }
        for (Object node : nodes) {
            NodeInfo info = this._nodeInfo.get(node);
            if (info.color != 0) continue;
            this.visit(graph, node, info, 0, new LinkedList<Edge>());
        }
    }

    private int visit(Graph graph, Object node, NodeInfo info, int time, List<Edge> path) {
        info.color = 1;
        Collection<Edge> edges = graph.getEdgesFrom(node);
        int maxChildTime = time - 1;
        for (Edge edge : edges) {
            int childTime;
            Object other = edge.getOther(node);
            NodeInfo otherInfo = this._nodeInfo.get(other);
            if (otherInfo.color == 0) {
                path.add(edge);
                childTime = this.visit(graph, other, otherInfo, time, path);
                path.remove(edge);
                edge.setType(1);
            } else if (otherInfo.color == 1) {
                childTime = -1;
                edge.setType(2);
                edge.setCycle(this.cycleForBackEdge(edge, path));
            } else {
                childTime = otherInfo.finished;
                edge.setType(3);
                LinkedList<Edge> cycle = new LinkedList<Edge>();
                cycle.add(edge);
                if (this.cycleForForwardEdge(graph, other, node, cycle)) {
                    edge.setCycle(cycle);
                }
            }
            maxChildTime = Math.max(maxChildTime, childTime);
        }
        info.color = 2;
        info.finished = maxChildTime + 1;
        return info.finished;
    }

    public void setNodeComparator(Comparator<Object> comp) {
        this._comp = comp;
    }

    public List<Object> getSortedNodes() {
        Map.Entry[] entries = this._nodeInfo.entrySet().toArray(new Map.Entry[this._nodeInfo.size()]);
        Arrays.sort(entries, new NodeInfoComparator(this._comp));
        return new NodeList(entries);
    }

    public Collection<Edge> getEdges(int type) {
        List<Edge> typed = null;
        for (Object node : this._graph.getNodes()) {
            for (Edge edge : this._graph.getEdgesFrom(node)) {
                if (edge.getType() != type) continue;
                if (typed == null) {
                    typed = new ArrayList<Edge>();
                }
                typed.add(edge);
            }
        }
        if (typed == null) {
            typed = Collections.emptyList();
        }
        return typed;
    }

    public int getFinishedTime(Object node) {
        NodeInfo info = this._nodeInfo.get(node);
        if (info == null) {
            return -1;
        }
        return info.finished;
    }

    private List<Edge> buildCycle(Edge backEdge, List<Edge> path, int pos) {
        int length = path != null ? path.size() - pos : 0;
        ArrayList<Edge> cycle = new ArrayList<Edge>(length + 1);
        cycle.add(0, backEdge);
        for (int i = 0; i < length; ++i) {
            cycle.add(i + 1, path.get(pos + i));
        }
        return cycle;
    }

    private List<Edge> cycleForBackEdge(Edge edge, List<Edge> path) {
        if (edge.getType() != 2) {
            return null;
        }
        int pos = 0;
        if (path != null && !edge.getFrom().equals(edge.getTo())) {
            pos = this.findNodeInPath(edge.getTo(), path);
            assert (pos >= 0) : _loc.get("node-not-on-path", edge, edge.getTo());
        } else {
            assert (edge.getFrom().equals(edge.getTo())) : _loc.get("edge-no-loop", edge).getMessage();
            path = null;
        }
        List<Edge> cycle = this.buildCycle(edge, path, pos);
        assert (cycle != null) : _loc.get("cycle-null", edge).getMessage();
        return cycle;
    }

    private boolean cycleForForwardEdge(Graph graph, Object node, Object cycleTo, List<Edge> path) {
        boolean found = false;
        Collection<Edge> edges = graph.getEdgesFrom(node);
        for (Edge edge : edges) {
            Object other = edge.getOther(node);
            if (node.equals(other)) continue;
            if (other.equals(cycleTo)) {
                path.add(edge);
                found = true;
                continue;
            }
            if (path.contains(edge)) continue;
            path.add(edge);
            found = this.cycleForForwardEdge(graph, other, cycleTo, path);
            if (found) continue;
            path.remove(edge);
        }
        return found;
    }

    private int findNodeInPath(Object node, List<Edge> path) {
        int pos = -1;
        if (path != null) {
            for (int i = 0; i < path.size(); ++i) {
                if (!path.get(i).getFrom().equals(node)) continue;
                pos = i;
            }
        }
        return pos;
    }

    public boolean hasNoCycles() {
        if (!this.getEdges(2).isEmpty()) {
            return false;
        }
        Collection<Edge> edges = this.getEdges(3);
        if (!edges.isEmpty()) {
            for (Edge edge : edges) {
                if (edge.getCycle() == null) continue;
                return false;
            }
        }
        return true;
    }

    private static class NodeInfoComparator
    implements Comparator<Map.Entry<Object, NodeInfo>> {
        private final Comparator<Object> _subComp;

        public NodeInfoComparator(Comparator<Object> subComp) {
            this._subComp = subComp;
        }

        @Override
        public int compare(Map.Entry<Object, NodeInfo> e1, Map.Entry<Object, NodeInfo> e2) {
            NodeInfo n1 = e1.getValue();
            NodeInfo n2 = e2.getValue();
            int ret = n1.finished - n2.finished;
            if (ret == 0 && this._subComp != null) {
                ret = this._subComp.compare(e1.getKey(), e2.getKey());
            }
            return ret;
        }
    }

    private static class NodeList
    extends AbstractList<Object> {
        private final Map.Entry<Object, NodeInfo>[] _entries;

        public NodeList(Map.Entry<Object, NodeInfo>[] entries) {
            this._entries = entries;
        }

        @Override
        public Object get(int idx) {
            return this._entries[idx].getKey();
        }

        @Override
        public int size() {
            return this._entries.length;
        }
    }
}

