/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/main/omutils.js":
/*!*****************************!*\
  !*** ./src/main/omutils.js ***!
  \*****************************/
/***/ ((module) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */

let options, alertId = 0;

function _init(_options) {
	options = _options;
}
function _tmpl(tmplId, newId) {
	return $(tmplId).clone().attr('id', newId || '');
}
function __alert(level, msg, autohideAfter) {
	const holder = document.getElementById('alert-holder');
	const curId = 'om-alert' + alertId++;
	holder.insertAdjacentHTML('beforeend',
		`<div id="${curId}" class="alert alert-${level} alert-dismissible fade show m-0" role="alert">${msg}
			<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="${holder.getAttribute('data-lbl-close')}"></button>
		</div>`);
	if (autohideAfter > 0) {
		setTimeout(() => { bootstrap.Alert.getOrCreateInstance(`#${curId}`).close();}, autohideAfter);
	}
}
function _error(msg, noAlert) {
	if (typeof(msg) === 'object') {
		msg = msg.name + ': ' + msg.message;
	}
	if (noAlert !== true) {
		__alert('danger', msg, 20000);
	}
	return console.error(msg);
}
function _debugEnabled() {
	return !!options && !!options.debug;
}
function _info() {
	if (_debugEnabled()) {
		console.info.apply(this, arguments);
	}
}
function _log() {
	if (_debugEnabled()) {
		console.log.apply(this, arguments);
	}
}
function _sendMessage(_m, _base) {
	const base = _base || {}
		, m = _m || {}
		, msg = JSON.stringify(Object.assign({}, base, m));
	Wicket.WebSocket.send(msg);
}
function _requestNotifyPermission(callback, elseCallback) {
	if (typeof(Notification) !== 'undefined'
		&& Notification.permission !== 'granted'
		&& Notification.permission !== 'denied') {
		function onRequest(permission) {
			if (permission === 'granted') {
				callback();
			}
		}
		Promise.resolve(Notification.requestPermission()).then(onRequest);
	} else {
		_info('No notification API for this browser');
		if (typeof(elseCallback) === 'function') {
			elseCallback();
		}
	}
}
function _notify(msg, tag, elseCallback) {
	if (typeof(Notification) !== 'undefined'
		&& window === window.parent) {
		function _newMessage() {
			const opts = {
					tag: tag
				};
			try {
				new Notification(msg, opts);
			} catch (e) {
				console.error("Failed to create Notification" + e)
			}
		}
		if (Notification.permission === 'granted') {
			_newMessage();
		} else {
			_requestNotifyPermission(() => _newMessage());
		}
	} else {
		_info('No notification API for this browser');
		if (typeof(elseCallback) === 'function') {
			elseCallback();
		}
	}
}

module.exports = {
	init: _init
	, tmpl: _tmpl
	, debugEnabled: _debugEnabled
	, enableDebug: function() {
		if (!!options) {
			options.debug = true;
		}
	}
	, sendMessage: _sendMessage
	, alert: __alert
	, error: _error
	, info: _info
	, log: _log
	, wbAction: function(_m) {
		_sendMessage(_m, {area: 'room', type: 'wb'});
	}
	, roomAction: function(_m) {
		_sendMessage(_m, {area: 'room', type: 'room'});
	}
	, setCssVar: function(key, val) {
		document.querySelector('body').style.setProperty(key, val);
	}
	, ping: function() {
		setTimeout(() => {
			_sendMessage({type: 'ping'});
			fetch('./ping', {cache: "no-store"});
		}, 30000);
	}
	, notify: _notify
	, requestNotifyPermission: _requestNotifyPermission
};


/***/ }),

/***/ "./src/main/settings.js":
/*!******************************!*\
  !*** ./src/main/settings.js ***!
  \******************************/
/***/ ((module) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const key = 'openmeetings';
function _load() {
	let s = {};
	try {
		s = JSON.parse(localStorage.getItem(key)) || s;
	} catch (e) {
		// no-op
	}
	return s;
}
function _save(s) {
	const _s = JSON.stringify(s);
	localStorage.setItem(key, _s);
	return _s;
}

module.exports = {
	isRtl: 'rtl' === document.querySelector('html').getAttribute('dir')
	, load: _load
	, save: _save
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!***************************!*\
  !*** ./src/main/index.js ***!
  \***************************/
/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
Wicket.BrowserInfo.collectExtraInfo = function(info) {
	const l = window.location;
	info.codebase = l.origin + l.pathname;
	info.settings = Settings.load();
};

function _updateResize() {
	const doc = document.documentElement;
	doc.style.setProperty('--app-height', `${window.innerHeight}px`)
}
$(window).on('resize', _updateResize);
//initial resize
_updateResize();

Object.assign(window, {
	Settings: __webpack_require__(/*! ./settings */ "./src/main/settings.js")
	, OmUtil: __webpack_require__(/*! ./omutils */ "./src/main/omutils.js")
	//Fix to move the close icon on top of the .ui-dialog-titlebar cause otherwise
	// touch-events are broken and you won't be able to close the dialog
	, fixJQueryUIDialogTouch: function(dialog) {
		dialog.parent().find('.ui-dialog-titlebar-close').appendTo(dialog.parent());
	}
	, showBusyIndicator: function() {
		$('#busy-indicator').show();
	}
	, hideBusyIndicator: function() {
		$('#busy-indicator').hide();
	}
});

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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