/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages.auth;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.spinner.SpinnerAjaxButton;
import java.io.Serializable;
import java.util.List;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.server.LdapConfigDao;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.server.LdapConfig;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.OmAuthenticationStrategy;
import org.apache.openmeetings.web.app.UserManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmAjaxClientInfoBehavior;
import org.apache.openmeetings.web.pages.HashPage;
import org.apache.openmeetings.web.pages.PrivacyPage;
import org.apache.openmeetings.web.pages.auth.ForgetPasswordDialog;
import org.apache.openmeetings.web.pages.auth.OtpDialog;
import org.apache.openmeetings.web.pages.auth.RegisterDialog;
import org.apache.openmeetings.web.pages.auth.SignInPage;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignInDialog
extends Modal<String> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SignInDialog.class);
    private final PasswordTextField passField = new PasswordTextField("pass", (IModel)Model.of((Serializable)((Object)"")));
    private final RequiredTextField<String> loginField = new RequiredTextField("login", (IModel)Model.of((Serializable)((Object)"")));
    private boolean rememberMe = false;
    private LdapConfig domain;
    private NotificationPanel feedback = new NotificationPanel("feedback");
    @SpringBean
    private ConfigurationDao cfgDao;
    @SpringBean
    private LdapConfigDao ldapDao;
    @SpringBean
    private OAuth2Dao oauthDao;
    @SpringBean
    private UserDao userDao;

    public SignInDialog(String id) {
        super(id);
        this.add(new Behavior[]{new OmAjaxClientInfoBehavior()});
    }

    protected void onInitialize() {
        SignInForm form = new SignInForm("signin");
        this.add(new Component[]{form});
        this.header((IModel)new ResourceModel("108"));
        this.show(true);
        this.setCloseOnEscapeKey(false);
        this.setBackdrop(Modal.Backdrop.STATIC);
        this.addButton((Component)new SpinnerAjaxButton("button", (IModel)new ResourceModel("112"), (Form)form, Buttons.Type.Outline_Primary));
        this.addButton(new BootstrapAjaxLink<String>("button", (IModel)Model.of((Serializable)((Object)"")), Buttons.Type.Outline_Secondary, (IModel)new ResourceModel("123")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                SignInDialog.this.close((IPartialPageRequestHandler)target);
                RegisterDialog register = (RegisterDialog)this.getPage().get("register");
                register.setClientTimeZone();
                register.show((IPartialPageRequestHandler)target);
            }
        }.setVisible(OpenmeetingsVariables.isAllowRegisterFrontend()));
        super.onInitialize();
    }

    protected Component createHeaderCloseButton(String id) {
        return super.createHeaderCloseButton(id).setVisible(false);
    }

    private String getLogin() {
        return String.format(this.domain.getAddDomainToUserName() ? "%s@%s" : "%s", this.loginField.getModelObject(), this.domain.getDomain());
    }

    void finalStep(boolean signedIn, User.Type type, AjaxRequestTarget target) {
        OmAuthenticationStrategy strategy = Application.getAuthenticationStrategy();
        if (signedIn) {
            this.setResponsePage(Application.get().getHomePage());
            if (this.rememberMe) {
                String login = this.getLogin();
                strategy.save(login, (String)this.passField.getModelObject(), type, this.domain.getId());
            } else {
                strategy.remove();
            }
        } else {
            if (!this.hasErrorMessage()) {
                this.error((Serializable)((Object)this.getString("error.bad.credentials")));
                target.add(new Component[]{this.feedback});
            }
            SignInDialog.penalty();
            strategy.remove();
        }
    }

    public static void penalty() {
        try {
            Thread.sleep(6L + (long)(10.0 * Math.random() * 1000.0));
        }
        catch (InterruptedException e) {
            log.error("Unexpected exception while sleeping", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    class SignInForm
    extends StatelessForm<String> {
        private static final long serialVersionUID = 1L;
        private final WebMarkupContainer credentials;

        public SignInForm(String id) {
            super(id);
            this.credentials = new WebMarkupContainer("credentials");
        }

        protected void onInitialize() {
            SignInDialog.this.loginField.setLabel((IModel)new ResourceModel("114"));
            SignInDialog.this.passField.setLabel((IModel)new ResourceModel("110"));
            super.onInitialize();
            if (WebSession.get().isSignedIn()) {
                this.alreadyLoggedIn();
            }
            this.add(new Component[]{this.credentials, SignInDialog.this.feedback.setOutputMarkupId(true)});
            this.credentials.add(new Component[]{SignInDialog.this.loginField, SignInDialog.this.passField.setResetPassword(true)});
            List ldaps = SignInDialog.this.ldapDao.get();
            boolean showLdap = ldaps.size() > 1;
            int selectedLdap = SignInDialog.this.cfgDao.getInt("default.ldap.id", 0);
            SignInDialog.this.domain = (LdapConfig)ldaps.get(selectedLdap < ldaps.size() && selectedLdap > 0 ? selectedLdap : 0);
            this.credentials.add(new Component[]{new WebMarkupContainer("ldap").add(new Component[]{new DropDownChoice("domain", (IModel)new PropertyModel((Object)SignInDialog.this, "domain"), ldaps, (IChoiceRenderer)new ChoiceRenderer("name", "id"))}).setVisible(showLdap)});
            this.credentials.add(new Component[]{new CheckBox("rememberMe", (IModel)new PropertyModel((Object)SignInDialog.this, "rememberMe")).setOutputMarkupId(true)});
            AjaxButton ab = new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;
            };
            this.add(new Component[]{ab});
            this.setDefaultButton((IFormSubmittingComponent)ab);
            this.credentials.add(new Component[]{new AjaxLink<Void>("forget"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    SignInDialog.this.close((IPartialPageRequestHandler)target);
                    ForgetPasswordDialog forget = (ForgetPasswordDialog)this.getPage().get("forget");
                    forget.show((IPartialPageRequestHandler)target);
                }
            }});
            this.add(new Component[]{new WebMarkupContainer("netTest").add(new Behavior[]{AttributeModifier.append((String)"href", (Serializable)((Object)RequestCycle.get().urlFor(HashPage.class, new PageParameters().add("app", (Object)"network")).toString()))})});
            this.add(new Component[]{new BookmarkablePageLink("privacy", PrivacyPage.class)});
            boolean showOauth = ((SignInPage)this.getPage()).allowOAuthLogin();
            this.add(new Component[]{new WebMarkupContainer("oauth").add(new Component[]{new ListView<OAuthServer>("oauthList", SignInDialog.this.oauthDao.getActive()){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<OAuthServer> item) {
                    final OAuthServer s = (OAuthServer)item.getModelObject();
                    BootstrapAjaxLink<String> btn = new BootstrapAjaxLink<String>("oauthBtn", null, Buttons.Type.Outline_Info, (IModel)Model.of((Serializable)((Object)s.getName()))){
                        private static final long serialVersionUID = 1L;
                        {
                            super(id, model, type, labelModel);
                            this.setMarkupId("om-oauth-btn-" + s.getId());
                            this.setOutputMarkupId(true);
                        }

                        public void onClick(AjaxRequestTarget target) {
                            UserManager.showAuth(s);
                        }

                        public void renderHead(IHeaderResponse response) {
                            if (!Strings.isEmpty((String)s.getIconUrl())) {
                                response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)("#" + this.getMarkupId() + " .provider {background-image: url(" + s.getIconUrl() + ")}"), (String)("oauth-btn-css-" + this.getMarkupId())));
                            }
                        }
                    };
                    item.add(new Component[]{btn.setIconType(new IconType("provider"){
                        private static final long serialVersionUID = 1L;

                        public String cssClassName() {
                            return "provider";
                        }
                    })});
                    item.setRenderBodyOnly(true);
                }
            }}).setVisible(showOauth)});
            if (showOauth) {
                this.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"wide"))});
            }
        }

        private void alreadyLoggedIn() {
            this.continueToOriginalDestination();
            throw new RestartResponseException(Application.get().getHomePage());
        }

        protected void onError() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onError);
        }

        protected void onError(AjaxRequestTarget target) {
            target.add(new Component[]{SignInDialog.this.feedback});
        }

        protected void onSubmit() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onSubmit);
        }

        private void processOtp(String login, AjaxRequestTarget target) {
            boolean signedIn = false;
            boolean checkOtp = false;
            String password = (String)SignInDialog.this.passField.getModelObject();
            User u = null;
            try {
                u = SignInDialog.this.userDao.login(login, password);
                signedIn = u != null;
                checkOtp = signedIn && u.getOtpSecret() != null;
            }
            catch (OmException e) {
                this.error((Serializable)((Object)this.getString(e.getKey())));
                target.add(new Component[]{SignInDialog.this.feedback});
            }
            if (signedIn) {
                if (checkOtp) {
                    OtpDialog otp = (OtpDialog)this.getPage().get("otpDialog");
                    otp.setModelObject(u);
                    SignInDialog.this.close((IPartialPageRequestHandler)target);
                    otp.show((IPartialPageRequestHandler)target);
                    return;
                }
                WebSession ws = WebSession.get();
                ws.signIn(u);
            }
            SignInDialog.this.finalStep(signedIn, User.Type.USER, target);
        }

        protected void onSubmit(AjaxRequestTarget target) {
            User.Type type;
            String login = SignInDialog.this.getLogin();
            String password = (String)SignInDialog.this.passField.getModelObject();
            WebSession ws = WebSession.get();
            User.Type type2 = type = SignInDialog.this.domain.getId() > 0L ? User.Type.LDAP : User.Type.USER;
            if (OpenmeetingsVariables.isOtpEnabled() && User.Type.USER == type) {
                this.processOtp(login, target);
                return;
            }
            boolean signedIn = false;
            try {
                signedIn = ws.signIn(login, password, type, SignInDialog.this.domain.getId());
            }
            catch (OmException e) {
                this.error((Serializable)((Object)this.getString(e.getKey())));
                target.add(new Component[]{SignInDialog.this.feedback});
            }
            SignInDialog.this.finalStep(signedIn, type, target);
        }
    }
}

