/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import java.io.File;
import java.nio.file.Files;
import org.apache.openmeetings.core.converter.ImageConverter;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.web.common.UploadableImagePanel;
import org.apache.openmeetings.web.util.ProfileImageResourceReference;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class UploadableProfileImagePanel
extends UploadableImagePanel {
    private static final long serialVersionUID = 1L;
    private Long userId;
    @SpringBean
    private ImageConverter converter;
    @SpringBean
    private UserDao userDao;

    public UploadableProfileImagePanel(String id, Long userId) {
        super(id, false);
        this.userId = userId;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setVisible(this.userDao.get(this.userId) != null);
    }

    @Override
    protected void processImage(StoredFile sf, File f) throws Exception {
        this.converter.convertImageUserProfile(f, this.userId);
    }

    @Override
    protected void deleteImage() throws Exception {
        File f = new File(OmFileHelper.getUploadProfilesUserDir((Long)this.userId), OmFileHelper.getName((String)"profile", (String)"png"));
        Files.deleteIfExists(f.toPath());
    }

    @Override
    protected String getImageUrl() {
        User u = this.userDao.get(this.userId);
        return u == null ? "" : ProfileImageResourceReference.getUrl(this.getRequestCycle(), u);
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }
}

