/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import dev.samstevens.totp.code.CodeGenerator;
import dev.samstevens.totp.code.CodeVerifier;
import dev.samstevens.totp.code.DefaultCodeGenerator;
import dev.samstevens.totp.code.DefaultCodeVerifier;
import dev.samstevens.totp.code.HashingAlgorithm;
import dev.samstevens.totp.exceptions.QrGenerationException;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.qr.ZxingPngQrGenerator;
import dev.samstevens.totp.recovery.RecoveryCodeGenerator;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.secret.SecretGenerator;
import dev.samstevens.totp.time.NtpTimeProvider;
import dev.samstevens.totp.time.SystemTimeProvider;
import dev.samstevens.totp.time.TimeProvider;
import dev.samstevens.totp.util.Utils;
import java.net.UnknownHostException;
import javax.annotation.PostConstruct;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OtpManager {
    private static final Logger log = LoggerFactory.getLogger(OtpManager.class);
    private static final int DIGITS = 6;
    private static final int PERIOD = 30;
    private static final HashingAlgorithm ALGORITHM = HashingAlgorithm.SHA1;
    private final SecretGenerator secretGenerator = new DefaultSecretGenerator(128);
    private CodeVerifier codeVerifier;
    @Value(value="${otp.issuer}")
    private String issuer = "";
    @Value(value="${otp.ntp.server}")
    private String ntpServer = "pool.ntp.org";
    @Value(value="${otp.ntp.timeout}")
    private int ntpTimeout = 6;

    @PostConstruct
    public void init() throws UnknownHostException {
        NtpTimeProvider timeProvider;
        DefaultCodeGenerator codeGenerator = new DefaultCodeGenerator(ALGORITHM, 6);
        try {
            timeProvider = new NtpTimeProvider(this.ntpServer, this.ntpTimeout);
        }
        catch (UnknownHostException e) {
            log.error("Unable to create NTP time provider, fallback to system, Please CHECK your setup", (Throwable)e);
            timeProvider = new SystemTimeProvider();
        }
        DefaultCodeVerifier verifier = new DefaultCodeVerifier((CodeGenerator)codeGenerator, (TimeProvider)timeProvider);
        verifier.setTimePeriod(30);
        this.codeVerifier = verifier;
    }

    public String generateSecret() {
        return this.secretGenerator.generate();
    }

    public String getQr(String userEmail, String secret) {
        QrData data = new QrData.Builder().label(userEmail).secret(secret).issuer(Strings.isEmpty((String)this.issuer) ? OpenmeetingsVariables.getApplicationName() : this.issuer).algorithm(ALGORITHM).digits(6).period(30).build();
        ZxingPngQrGenerator generator = new ZxingPngQrGenerator();
        try {
            byte[] imageData = generator.generate(data);
            return Utils.getDataUriForImage((byte[])imageData, (String)"image/png");
        }
        catch (QrGenerationException e) {
            log.error("Unexpected exception while generating QR", (Throwable)e);
            return "";
        }
    }

    public String[] getRecoveryCodes() {
        RecoveryCodeGenerator recoveryCodes = new RecoveryCodeGenerator();
        return recoveryCodes.generateCodes(16);
    }

    public boolean verify(String secret, String code) {
        return this.codeVerifier.isValidCode(secret, code);
    }
}

