/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.locksupport.LockProxySupport;
import com.hazelcast.internal.locksupport.LockSupportServiceImpl;
import com.hazelcast.internal.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.multimap.impl.operations.CountOperation;
import com.hazelcast.multimap.impl.operations.DeleteOperation;
import com.hazelcast.multimap.impl.operations.GetAllOperation;
import com.hazelcast.multimap.impl.operations.MultiMapOperationFactory;
import com.hazelcast.multimap.impl.operations.MultiMapPutAllOperationFactory;
import com.hazelcast.multimap.impl.operations.MultiMapResponse;
import com.hazelcast.multimap.impl.operations.PutOperation;
import com.hazelcast.multimap.impl.operations.RemoveAllOperation;
import com.hazelcast.multimap.impl.operations.RemoveOperation;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public abstract class MultiMapProxySupport
extends AbstractDistributedObject<MultiMapService> {
    protected final MultiMapConfig config;
    protected final String name;
    protected final LockProxySupport lockSupport;
    protected final OperationService operationService;
    protected final IPartitionService partitionService;

    protected MultiMapProxySupport(MultiMapConfig config, MultiMapService service, NodeEngine nodeEngine, String name) {
        super(nodeEngine, service);
        this.config = config;
        this.name = name;
        this.partitionService = nodeEngine.getPartitionService();
        this.operationService = nodeEngine.getOperationService();
        this.lockSupport = new LockProxySupport(new DistributedObjectNamespace("hz:impl:multiMapService", name), LockSupportServiceImpl.getMaxLeaseTimeInMillis(nodeEngine.getProperties()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    private int getPutAllInitialSize(int mapSize, int partitionCount) {
        if (mapSize == 1) {
            return 1;
        }
        return mapSize / partitionCount + 1;
    }

    protected void putAllInternal(Map<Data, Data> map, @Nullable InternalCompletableFuture<Void> future) {
        try {
            int mapSize = map.size();
            if (mapSize == 0) {
                if (future != null) {
                    future.complete(null);
                }
                return;
            }
            int partitionCount = this.partitionService.getPartitionCount();
            int initialSize = this.getPutAllInitialSize(mapSize, partitionCount);
            Map<Address, List<Integer>> memberPartitionsMap = this.partitionService.getMemberPartitionsMap();
            MapEntries[] entriesPerPartition = new MapEntries[partitionCount];
            for (Map.Entry<Data, Data> entry : map.entrySet()) {
                Preconditions.checkNotNull(entry.getKey(), "Null key is not allowed!");
                Preconditions.checkNotNull(entry.getValue(), "Null value is not allowed!");
                Data keyData = entry.getKey();
                int partitionId = this.partitionService.getPartitionId(keyData);
                MapEntries entries = entriesPerPartition[partitionId];
                if (entries == null) {
                    entriesPerPartition[partitionId] = entries = new MapEntries(initialSize);
                }
                entries.add(keyData, entry.getValue());
            }
            AtomicInteger counter = new AtomicInteger(memberPartitionsMap.size());
            InternalCompletableFuture resultFuture = future != null ? future : new InternalCompletableFuture();
            BiConsumer<Void, Throwable> callback = (response, t) -> {
                if (t != null) {
                    resultFuture.completeExceptionally((Throwable)t);
                }
                if (counter.decrementAndGet() == 0 && !resultFuture.isDone()) {
                    resultFuture.complete(null);
                }
            };
            for (Map.Entry<Address, List<Integer>> entry : memberPartitionsMap.entrySet()) {
                this.invokePutAllOperation(entry.getKey(), entry.getValue(), entriesPerPartition).whenCompleteAsync(callback, ConcurrencyUtil.getDefaultAsyncExecutor());
            }
            if (future == null) {
                resultFuture.get();
            }
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private InternalCompletableFuture<Void> invokePutAllOperation(Address address, List<Integer> memberPartitions, MapEntries[] entriesPerPartition) {
        int size = memberPartitions.size();
        int[] partitions = new int[size];
        int index = 0;
        for (Integer partitionId : memberPartitions) {
            if (entriesPerPartition[partitionId] == null) continue;
            partitions[index++] = partitionId;
        }
        if (index == 0) {
            return InternalCompletableFuture.newCompletedFuture(null);
        }
        if (index < size) {
            partitions = Arrays.copyOf(partitions, index);
            size = index;
        }
        index = 0;
        MapEntries[] entries = new MapEntries[size];
        long totalSize = 0L;
        for (int partitionId : partitions) {
            totalSize += (long)entriesPerPartition[partitionId].size();
            entries[index++] = entriesPerPartition[partitionId];
            entriesPerPartition[partitionId] = null;
        }
        if (totalSize == 0L) {
            return InternalCompletableFuture.newCompletedFuture(null);
        }
        MultiMapPutAllOperationFactory factory = new MultiMapPutAllOperationFactory(this.name, partitions, entries);
        long startTimeNanos = System.nanoTime();
        CompletableFuture future = this.operationService.invokeOnPartitionsAsync("hz:impl:multiMapService", (OperationFactory)factory, Collections.singletonMap(address, CollectionUtil.asIntegerList(partitions)));
        InternalCompletableFuture<Void> resultFuture = new InternalCompletableFuture<Void>();
        long finalTotalSize = totalSize;
        future.whenCompleteAsync((response, t) -> {
            if (t == null) {
                ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementPutLatencyNanos(finalTotalSize, System.nanoTime() - startTimeNanos);
                resultFuture.complete(null);
            } else {
                resultFuture.completeExceptionally((Throwable)t);
            }
        }, ConcurrencyUtil.CALLER_RUNS);
        return resultFuture;
    }

    protected Boolean putInternal(Data dataKey, Data dataValue, int index) {
        try {
            PutOperation operation = new PutOperation(this.name, dataKey, this.getThreadId(), dataValue, index);
            return (Boolean)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected MultiMapResponse getAllInternal(Data dataKey) {
        try {
            GetAllOperation operation = new GetAllOperation(this.name, dataKey);
            operation.setThreadId(ThreadUtil.getThreadId());
            return (MultiMapResponse)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Boolean removeInternal(Data dataKey, Data dataValue) {
        try {
            RemoveOperation operation = new RemoveOperation(this.name, dataKey, this.getThreadId(), dataValue);
            return (Boolean)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected MultiMapResponse removeInternal(Data dataKey) {
        try {
            RemoveAllOperation operation = new RemoveAllOperation(this.name, dataKey, this.getThreadId());
            return (MultiMapResponse)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected void deleteInternal(Data dataKey) {
        try {
            DeleteOperation operation = new DeleteOperation(this.name, dataKey, this.getThreadId());
            this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Set<Data> localKeySetInternal() {
        return ((MultiMapService)this.getService()).localKeySet(this.name);
    }

    protected Set<Data> keySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:multiMapService", new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.KEY_SET));
            HashSet<Data> keySet = new HashSet<Data>();
            for (Object result : results.values()) {
                MultiMapResponse response;
                if (result == null || (response = (MultiMapResponse)nodeEngine.toObject(result)).getCollection() == null) continue;
                keySet.addAll(response.getCollection());
            }
            return keySet;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Map valuesInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:multiMapService", new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.VALUES));
            if (this.config.isStatisticsEnabled()) {
                ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
            }
            return results;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected Map entrySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:multiMapService", new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.ENTRY_SET));
            if (this.config.isStatisticsEnabled()) {
                ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
            }
            return results;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected boolean containsInternal(Data key, Data value) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:multiMapService", new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.CONTAINS, key, value, ThreadUtil.getThreadId()));
            if (this.config.isStatisticsEnabled()) {
                ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
            }
            for (Object obj : results.values()) {
                Boolean result;
                if (obj == null || !(result = (Boolean)nodeEngine.toObject(obj)).booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public int size() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:multiMapService", new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.SIZE));
            if (this.config.isStatisticsEnabled()) {
                ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
            }
            long size = 0L;
            for (Object obj : results.values()) {
                if (obj == null) continue;
                Integer result = (Integer)nodeEngine.toObject(obj);
                size += (long)result.intValue();
            }
            return MapUtil.toIntSize(size);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public void clear() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> resultMap = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:multiMapService", new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.CLEAR));
            if (this.config.isStatisticsEnabled()) {
                ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
            }
            int numberOfAffectedEntries = 0;
            for (Object o : resultMap.values()) {
                numberOfAffectedEntries += ((Integer)o).intValue();
            }
            this.publishMultiMapEvent(numberOfAffectedEntries, EntryEventType.CLEAR_ALL);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    private void publishMultiMapEvent(int numberOfAffectedEntries, EntryEventType eventType) {
        ((MultiMapService)this.getService()).publishMultiMapEvent(this.name, eventType, numberOfAffectedEntries);
    }

    protected Integer countInternal(Data dataKey) {
        try {
            CountOperation operation = new CountOperation(this.name, dataKey);
            operation.setThreadId(ThreadUtil.getThreadId());
            return (Integer)this.invoke(operation, dataKey);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    private <T> T invoke(Operation operation, Data dataKey) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Object result;
            int partitionId = nodeEngine.getPartitionService().getPartitionId(dataKey);
            if (this.config.isStatisticsEnabled()) {
                long startTimeNanos = Timer.nanos();
                InvocationFuture future = this.operationService.invokeOnPartition("hz:impl:multiMapService", operation, partitionId);
                result = future.get();
                this.incrementOperationStats(startTimeNanos, this.name, operation);
            } else {
                InvocationFuture future = this.operationService.invokeOnPartition("hz:impl:multiMapService", operation, partitionId);
                result = future.get();
            }
            return nodeEngine.toObject(result);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    private void incrementOperationStats(long startTimeNanos, String name, Operation operation) {
        LocalMultiMapStatsImpl localMultiMapStatsImpl = ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(name);
        long durationNanos = Timer.nanosElapsed(startTimeNanos);
        if (operation instanceof PutOperation) {
            localMultiMapStatsImpl.incrementPutLatencyNanos(durationNanos);
        } else if (operation instanceof RemoveOperation || operation instanceof RemoveAllOperation || operation instanceof DeleteOperation) {
            localMultiMapStatsImpl.incrementRemoveLatencyNanos(durationNanos);
        } else if (operation instanceof GetAllOperation) {
            localMultiMapStatsImpl.incrementGetLatencyNanos(durationNanos);
        }
    }

    private long getThreadId() {
        return ThreadUtil.getThreadId();
    }

    @Override
    public String toString() {
        return "MultiMap{name=" + this.name + '}';
    }
}

