/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.data.file;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Optional;
import java.util.UUID;
import java.util.function.DoubleConsumer;
import org.apache.commons.io.FileUtils;
import org.apache.openmeetings.core.converter.DocumentConverter;
import org.apache.openmeetings.core.converter.ImageConverter;
import org.apache.openmeetings.core.converter.VideoConverter;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.tika.exception.UnsupportedFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileProcessor {
    private static final Logger log = LoggerFactory.getLogger(FileProcessor.class);
    @Autowired
    private VideoConverter videoConverter;
    @Autowired
    private FileItemDao fileDao;
    @Autowired
    private ImageConverter imageConverter;
    @Autowired
    private DocumentConverter docConverter;

    public ProcessResultList processFile(FileItem f, InputStream is, Optional<DoubleConsumer> progress) throws Exception {
        ProcessResultList logs = new ProcessResultList();
        String hash = UUID.randomUUID().toString();
        File temp = null;
        try {
            temp = File.createTempFile(String.format("upload_%s", hash), ".tmp");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)temp);
            String ext = OmFileHelper.getFileExt((String)f.getName());
            log.debug("file extension: {}", (Object)ext);
            StoredFile sf = new StoredFile(hash, ext, temp);
            log.debug("isAsIs: {}", (Object)sf.isAsIs());
            if (sf.isImage()) {
                f.setType(BaseFileItem.Type.IMAGE);
            } else if (sf.isVideo()) {
                f.setType(BaseFileItem.Type.VIDEO);
            } else if (sf.isChart()) {
                f.setType(BaseFileItem.Type.POLL_CHART);
            } else if (sf.isPdf() || sf.isOffice()) {
                f.setType(BaseFileItem.Type.PRESENTATION);
            } else {
                throw new UnsupportedFormatException("The file type cannot be converted :: " + f.getName());
            }
            f.setHash(hash);
            this.processFile(f, sf, temp, logs, progress);
        }
        catch (Exception e) {
            log.debug("Error while processing the file", (Throwable)e);
            throw e;
        }
        finally {
            if (temp != null && temp.exists() && temp.isFile()) {
                log.debug("Clean up was successful ? {}", (Object)Files.deleteIfExists(temp.toPath()));
            }
        }
        return logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFile(FileItem f, StoredFile sf, File temp, ProcessResultList logs, Optional<DoubleConsumer> progress) throws Exception {
        try {
            File file = f.getFile(sf.getExt());
            log.debug("writing file to: {}", (Object)file);
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                logs.add(new ProcessResult("Unable to create parent for file: " + file.getCanonicalPath()));
                return;
            }
            switch (f.getType()) {
                case PRESENTATION: {
                    log.debug("Office document: {}", (Object)file);
                    FileUtils.copyFile((File)temp, (File)file);
                    this.docConverter.convertPDF(f, sf, logs, progress);
                    return;
                }
                case POLL_CHART: {
                    log.debug("uploaded chart file");
                    return;
                }
                case IMAGE: {
                    log.debug("##### convert it to PNG: ");
                    FileUtils.copyFile((File)temp, (File)file);
                    this.imageConverter.convertImage((BaseFileItem)f, sf, progress);
                    return;
                }
                case VIDEO: {
                    FileUtils.copyFile((File)temp, (File)file);
                    this.videoConverter.convertVideo(f, sf, logs, progress);
                    return;
                }
            }
            return;
        }
        finally {
            f = this.fileDao.update(f);
            log.debug("fileId: {}", (Object)f.getId());
        }
    }
}

