/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.mediaserver;

import com.github.openjson.JSONObject;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.basic.ScreenStreamDesc;
import org.apache.openmeetings.db.entity.basic.StreamDesc;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.mediaserver.KRoom;
import org.apache.openmeetings.mediaserver.KStream;
import org.apache.openmeetings.mediaserver.KurentoHandler;
import org.apache.openmeetings.mediaserver.StreamProcessor;
import org.apache.openmeetings.util.logging.TimedApplication;
import org.apache.wicket.util.string.Strings;
import org.kurento.client.IceCandidate;
import org.kurento.client.internal.server.KurentoServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamProcessorActions {
    private static final Logger log = LoggerFactory.getLogger(StreamProcessorActions.class);
    @Autowired
    private IClientManager cm;
    @Autowired
    private KurentoHandler kHandler;
    @Autowired
    private StreamProcessor streamProcessor;

    @TimedApplication
    protected void addIceCandidate(JSONObject msg) {
        String uid = msg.optString("uid");
        JSONObject candidate = msg.getJSONObject("candidate");
        String candStr = candidate.getString("candidate");
        KStream sender = this.streamProcessor.getByUid(uid);
        if (sender != null) {
            if (!Strings.isEmpty((String)candStr)) {
                IceCandidate cand = new IceCandidate(candStr, candidate.getString("sdpMid"), candidate.getInt("sdpMLineIndex"));
                sender.addIceCandidate(cand, msg.getString("luid"));
            }
        } else {
            log.warn("addIceCandidate sender is empty, uid: {}, candStr: {} ", (Object)uid, (Object)candStr);
        }
    }

    @TimedApplication
    protected void addListener(Client c, JSONObject msg) {
        KStream sender = this.streamProcessor.getByUid(msg.getString("sender"));
        if (sender != null) {
            ScreenStreamDesc scr;
            Client sendClient = this.cm.getBySid(sender.getSid());
            StreamDesc sd = sendClient.getStream(sender.getUid());
            if (sd == null) {
                return;
            }
            if (sd instanceof ScreenStreamDesc && (scr = (ScreenStreamDesc)sd).has(Client.Activity.RECORD) && !scr.has(Client.Activity.SCREEN)) {
                return;
            }
            sender.addListener(c.getSid(), c.getUid(), msg.getString("sdpOffer"));
        }
    }

    @TimedApplication
    protected void handleBroadcastRestarted(Client c, String uid) {
        if (!this.kHandler.isConnected()) {
            return;
        }
        KStream sender = this.streamProcessor.getByUid(uid);
        if (sender != null) {
            sender.broadcastRestarted();
        }
    }

    @TimedApplication
    protected void handleBroadcastStarted(Client c, String uid, JSONObject msg) {
        if (!this.kHandler.isConnected()) {
            return;
        }
        StreamDesc sd = c.getStream(uid);
        KStream sender = this.streamProcessor.getByUid(uid);
        try {
            if (sender == null) {
                KRoom room = this.kHandler.getRoom(c.getRoomId());
                sender = room.join(sd);
            }
            if (msg.has("width")) {
                sd.setWidth(msg.getInt("width")).setHeight(msg.getInt("height"));
                this.cm.update(c);
            }
            this.streamProcessor.startBroadcast(sender, sd, msg.getString("sdpOffer"), () -> {
                ScreenStreamDesc scr;
                if (sd instanceof ScreenStreamDesc && (scr = (ScreenStreamDesc)sd).has(Client.Activity.RECORD) && !this.streamProcessor.isRecording(c.getRoomId())) {
                    this.streamProcessor.startRecording(c);
                }
            });
        }
        catch (KurentoServerException e) {
            if (sender != null) {
                sender.release();
            }
            WebSocketHelper.sendClient((IWsClient)c, (JSONObject)StreamProcessor.newStoppedMsg(sd));
            KurentoHandler.sendError((IWsClient)c, "Failed to start broadcast: " + e.getMessage());
            log.error("Failed to start broadcast", (Throwable)e);
        }
    }
}

