/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.mediaserver;

import com.github.openjson.JSONObject;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.ScreenStreamDesc;
import org.apache.openmeetings.db.entity.basic.StreamDesc;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.db.util.FormatHelper;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.mediaserver.AbstractStream;
import org.apache.openmeetings.mediaserver.KStream;
import org.apache.openmeetings.mediaserver.KurentoHandler;
import org.apache.openmeetings.mediaserver.StreamProcessor;
import org.apache.wicket.injection.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRoom {
    private static final Logger log = LoggerFactory.getLogger(KRoom.class);
    @Inject
    private KurentoHandler kHandler;
    @Inject
    private StreamProcessor processor;
    @Inject
    private RecordingDao recDao;
    @Inject
    private IClientManager cm;
    private final Room room;
    private final AtomicBoolean recordingStarted = new AtomicBoolean(false);
    private final AtomicBoolean sharingStarted = new AtomicBoolean(false);
    private Long recordingId = null;
    private long sipCount = 0L;
    private JSONObject recordingUser = new JSONObject();
    private JSONObject sharingUser = new JSONObject();

    public KRoom(Room r) {
        this.room = r;
        Injector.get().inject((Object)this);
        log.info("ROOM {} has been created", (Object)this.room.getId());
    }

    public Room getRoom() {
        return this.room;
    }

    public Long getRecordingId() {
        return this.recordingId;
    }

    public KStream join(StreamDesc sd) {
        log.info("ROOM {}: join client {}, stream: {}", new Object[]{this.room.getId(), sd.getClient(), sd.getUid()});
        KStream stream = new KStream(sd, this);
        this.processor.addStream(stream);
        return stream;
    }

    public void onStopBroadcast(KStream stream) {
        this.processor.release(stream, true);
        WebSocketHelper.sendAll((String)KurentoHandler.newKurentoMsg().put("id", (Object)"broadcastStopped").put("uid", (Object)stream.getUid()).toString());
    }

    public boolean isRecording() {
        return this.recordingStarted.get();
    }

    public JSONObject getRecordingUser() {
        return new JSONObject(this.recordingUser.toString());
    }

    public void startRecording(Client c) {
        if (this.recordingStarted.compareAndSet(false, true)) {
            IApplication app = ApplicationHelper.ensureApplication((Long)c.getUser().getLanguageId());
            log.debug("##REC:: recording in room {} is starting ::", (Object)this.room.getId());
            Room r = c.getRoom();
            Date now = new Date();
            Recording rec = new Recording();
            rec.setHash(UUID.randomUUID().toString());
            FastDateFormat fdf = FormatHelper.getDateTimeFormat((User)c.getUser());
            rec.setName(app.getOmString(r.isInterview() ? "file.name.interview" : "file.name.recording", c.getUser().getLanguageId()) + fdf.format(new Date()));
            User u = c.getUser();
            this.recordingUser.put("login", (Object)u.getLogin());
            this.recordingUser.put("firstName", (Object)u.getFirstname());
            this.recordingUser.put("lastName", (Object)u.getLastname());
            this.recordingUser.put("started", now.getTime());
            Long ownerId = User.Type.CONTACT == u.getType() ? u.getOwnerId() : u.getId();
            rec.setInsertedBy(ownerId);
            rec.setType(BaseFileItem.Type.RECORDING);
            rec.setInterview(r.isInterview());
            rec.setRoomId(this.room.getId());
            rec.setRecordStart(now);
            rec.setOwnerId(ownerId);
            rec.setStatus(Recording.Status.RECORDING);
            log.debug("##REC:: recording created by USER: {}", (Object)ownerId);
            Optional osd = c.getScreenStream();
            if (osd.isPresent()) {
                ((ScreenStreamDesc)osd.get()).add(Client.Activity.RECORD);
                this.cm.update(c);
                rec.setWidth(Integer.valueOf(((ScreenStreamDesc)osd.get()).getWidth()));
                rec.setHeight(Integer.valueOf(((ScreenStreamDesc)osd.get()).getHeight()));
            }
            rec = this.recDao.update(rec);
            this.recordingId = rec.getId();
            this.processor.getByRoom(this.room.getId()).forEach(KStream::startRecord);
            WebSocketHelper.sendRoom((RoomMessage)new RoomMessage(this.room.getId(), u, RoomMessage.Type.RECORDING_TOGGLED));
            log.debug("##REC:: recording in room {} is started {} ::", (Object)this.room.getId(), (Object)this.recordingId);
        }
    }

    public void stopRecording(Client c) {
        if (this.recordingStarted.compareAndSet(true, false)) {
            User u;
            log.debug("##REC:: recording in room {} is stopping {} ::", (Object)this.room.getId(), (Object)this.recordingId);
            this.processor.getByRoom(this.room.getId()).forEach(KStream::stopRecord);
            Recording rec = this.recDao.get(this.recordingId);
            rec.setRecordEnd(new Date());
            rec = this.recDao.update(rec);
            this.recordingUser = new JSONObject();
            this.recordingId = null;
            this.processor.startConvertion(rec);
            if (c == null) {
                u = new User();
            } else {
                u = c.getUser();
                Optional osd = c.getScreenStream();
                if (osd.isPresent()) {
                    ((ScreenStreamDesc)osd.get()).remove(Client.Activity.RECORD);
                    this.cm.update(c);
                    this.kHandler.sendShareUpdated((StreamDesc)osd.get());
                }
            }
            WebSocketHelper.sendRoom((RoomMessage)new RoomMessage(this.room.getId(), u, RoomMessage.Type.RECORDING_TOGGLED));
            log.debug("##REC:: recording in room {} is stopped ::", (Object)this.room.getId());
        }
    }

    public boolean isSharing() {
        return this.sharingStarted.get();
    }

    public JSONObject getSharingUser() {
        return new JSONObject(this.sharingUser.toString());
    }

    public void startSharing(Client c, Optional<ScreenStreamDesc> osd, JSONObject msg, Client.Activity a) {
        if (this.sharingStarted.compareAndSet(false, true)) {
            this.sharingUser.put("sid", (Object)c.getSid());
            ScreenStreamDesc sd = (ScreenStreamDesc)c.addStream(Client.StreamType.SCREEN, a);
            this.cm.update(c);
            log.debug("Stream.UID {}: sharing has been started, activity: {}", (Object)sd.getUid(), (Object)a);
            this.kHandler.sendClient(sd.getSid(), KurentoHandler.newKurentoMsg().put("id", (Object)"broadcast").put("stream", (Object)sd.toJson().put("shareType", (Object)msg.getString("shareType")).put("fps", (Object)msg.getString("fps"))).put("iceServers", (Object)this.kHandler.getTurnServers(c)));
        } else if (osd.isPresent() && !osd.get().has(a)) {
            ScreenStreamDesc sd = osd.get();
            sd.add(a);
            this.cm.update(c);
            this.kHandler.sendShareUpdated((StreamDesc)sd);
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.RIGHT_UPDATED, c.getUid()));
            WebSocketHelper.sendRoomOthers((Long)this.room.getId(), (String)c.getUid(), (JSONObject)KurentoHandler.newKurentoMsg().put("id", (Object)"newStream").put("iceServers", (Object)this.kHandler.getTurnServers(c)).put("stream", (Object)sd.toJson()));
        }
    }

    public void stopSharing() {
        if (this.sharingStarted.compareAndSet(true, false)) {
            this.sharingUser = new JSONObject();
        }
    }

    public void close() {
        this.processor.getByRoom(this.room.getId()).forEach(AbstractStream::release);
        log.debug("Room {} closed", (Object)this.room.getId());
    }

    public void updateSipCount(long count) {
        if (count != this.sipCount) {
            this.processor.getByRoom(this.room.getId()).forEach(stream -> stream.addSipProcessor(count));
            if (this.sipCount == 0L) {
                this.cm.streamByRoom(this.room.getId()).filter(Client::isSip).findAny().ifPresent(c -> {
                    StreamDesc sd = c.addStream(Client.StreamType.WEBCAM, Client.Activity.AUDIO);
                    sd.setWidth(120).setHeight(90);
                    KStream stream = this.join(sd);
                    stream.startBroadcast(sd, "", () -> {});
                    this.cm.update(c);
                });
            }
            this.sipCount = count;
        }
    }

    public long getSipCount() {
        return this.sipCount;
    }
}

