/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.task;

import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.task.DocumentMSPasswordRequest;
import com.sun.star.task.DocumentPasswordRequest;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.task.PasswordRequest;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.task.XInteractionRequest;
import com.sun.star.uno.Exception;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.job.SourceDocumentSpecs;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.task.AbstractOfficeTask;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeContext;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.PasswordProtectedException;
import org.jodconverter.local.office.utils.Lo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalOfficeTask
extends AbstractOfficeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLocalOfficeTask.class);
    private static final String ERROR_MESSAGE_LOAD = "Could not open document: ";
    protected final Map<String, Object> loadProperties;
    protected final boolean useStreamAdapters;

    protected static void appendProperties(@NonNull Map<@NonNull String, @NonNull Object> properties, @Nullable Map<@NonNull String, @NonNull Object> toAddProperties) {
        if (toAddProperties != null) {
            properties.putAll(toAddProperties);
        }
    }

    public AbstractLocalOfficeTask(@NonNull SourceDocumentSpecs source) {
        this(source, false);
    }

    public AbstractLocalOfficeTask(@NonNull SourceDocumentSpecs source, boolean useStreamAdapters) {
        this(source, useStreamAdapters, null);
    }

    public AbstractLocalOfficeTask(@NonNull SourceDocumentSpecs source, boolean useStreamAdapters, @Nullable Map<@NonNull String, @NonNull Object> loadProperties) {
        super(source);
        this.useStreamAdapters = useStreamAdapters;
        this.loadProperties = loadProperties;
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getLoadProperties() {
        HashMap<String, Object> loadProps = new HashMap<String, Object>();
        if (this.source.getFormat() != null) {
            AbstractLocalOfficeTask.appendProperties(loadProps, this.source.getFormat().getLoadProperties());
        }
        AbstractLocalOfficeTask.appendProperties(loadProps, this.loadProperties == null ? LocalConverter.DEFAULT_LOAD_PROPERTIES : this.loadProperties);
        loadProps.putIfAbsent("InteractionHandler", new PasswordInteractionHandler());
        return loadProps;
    }

    protected @NonNull XComponent loadDocument(@NonNull LocalOfficeContext context, @NonNull File sourceFile) throws OfficeException {
        XComponentLoader loader = context.getComponentLoader();
        AssertUtils.notNull((Object)loader, (String)"Context component loader must not be null");
        try {
            Map<String, Object> loadProps = this.getLoadProperties();
            XComponent document = this.loadDocumentFromURL(loader, sourceFile, loadProps);
            this.handlePasswordProtection(document, loadProps);
            AssertUtils.notNull((Object)document, (String)(ERROR_MESSAGE_LOAD + sourceFile.getName()));
            return document;
        }
        catch (ErrorCodeIOException exception) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName() + "; errorCode: " + exception.ErrCode, (Throwable)exception);
        }
        catch (Exception exception) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName(), (Throwable)exception);
        }
    }

    private XComponent loadDocumentFromURL(XComponentLoader loader, File sourceFile, Map<String, Object> loadProps) throws Exception, OfficeException {
        if (this.useStreamAdapters) {
            try {
                byte[] bytes = Files.readAllBytes(sourceFile.toPath());
                loadProps.put("InputStream", new ByteArrayToXInputStreamAdapter(bytes));
                return loader.loadComponentFromURL("private:stream", "_blank", 0, LocalOfficeUtils.toUnoProperties(loadProps));
            }
            catch (IOException exception) {
                throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName(), (Throwable)exception);
            }
        }
        return loader.loadComponentFromURL(LocalOfficeUtils.toUrl(sourceFile), "_blank", 0, LocalOfficeUtils.toUnoProperties(loadProps));
    }

    protected void closeDocument(@Nullable XComponent document) {
        if (document != null) {
            XCloseable closeable = Lo.qiOptional(XCloseable.class, document).orElse(null);
            if (closeable == null) {
                document.dispose();
                Lo.qi(XComponent.class, document).dispose();
            } else {
                try {
                    closeable.close(true);
                }
                catch (CloseVetoException closeVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private void handlePasswordProtection(XComponent document, Map<String, Object> loadProps) throws OfficeException {
        PasswordInteractionHandler pHandler;
        Object handler;
        if (document == null && (handler = loadProps.get("InteractionHandler")) instanceof PasswordInteractionHandler && (pHandler = (PasswordInteractionHandler)handler).hasPasswordInteractionRequest()) {
            throw new PasswordProtectedException("Document password requested for " + pHandler.getDocumentName(), (Throwable)pHandler.getPasswordRequest());
        }
    }

    public @NonNull String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{source=" + this.source + ", loadProperties=" + this.loadProperties + ", useStreamAdapters=" + this.useStreamAdapters + '}';
    }

    private static class PasswordInteractionHandler
    implements XInteractionHandler {
        private PasswordRequest passwordRequest;
        private String documentName;

        private PasswordInteractionHandler() {
        }

        public PasswordRequest getPasswordRequest() {
            return this.passwordRequest;
        }

        public boolean hasPasswordInteractionRequest() {
            return this.passwordRequest != null;
        }

        public String getDocumentName() {
            return this.documentName;
        }

        public void handle(XInteractionRequest interactionRequest) {
            Object request;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Interaction detected with request {}", interactionRequest.getRequest());
            }
            if ((request = interactionRequest.getRequest()) instanceof PasswordRequest) {
                this.passwordRequest = (PasswordRequest)request;
                this.documentName = "NA";
                if (request instanceof DocumentPasswordRequest) {
                    this.documentName = ((DocumentPasswordRequest)request).Name;
                } else if (request instanceof DocumentMSPasswordRequest) {
                    this.documentName = ((DocumentMSPasswordRequest)request).Name;
                }
                LOGGER.debug("Password interaction detected for {}", (Object)this.documentName);
            }
        }
    }
}

