/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.cxf.feature.Features;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.room.InvitationDao;
import org.apache.openmeetings.db.dao.user.IUserManager;
import org.apache.openmeetings.db.dto.basic.ServiceResult;
import org.apache.openmeetings.db.dto.room.InvitationDTO;
import org.apache.openmeetings.db.dto.room.RoomDTO;
import org.apache.openmeetings.db.dto.user.UserDTO;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.mapper.RoomMapper;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.service.room.InvitationManager;
import org.apache.openmeetings.webservice.BaseWebService;
import org.apache.openmeetings.webservice.error.InternalServiceException;
import org.apache.openmeetings.webservice.error.ServiceException;
import org.apache.openmeetings.webservice.schema.RoomDTOListWrapper;
import org.apache.openmeetings.webservice.schema.RoomDTOWrapper;
import org.apache.openmeetings.webservice.schema.ServiceResultWrapper;
import org.apache.openmeetings.webservice.schema.UserDTOListWrapper;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="roomWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.RoomWebService", targetNamespace="http://webservice.openmeetings.apache.org/")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="RoomService")
@Path(value="/room")
public class RoomWebService
extends BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(RoomWebService.class);
    @Autowired
    private IUserManager userManager;
    @Autowired
    private IClientManager clientManager;
    @Autowired
    private InvitationDao inviteDao;
    @Autowired
    private InvitationManager inviteManager;
    @Autowired
    private RoomMapper rMapper;

    @WebMethod
    @GET
    @Path(value="/public/{type}")
    @Operation(description="Returns an Object of Type RoomsList which contains a list of\n ROOM-Objects. Every ROOM-Object contains a Roomtype and all informations\n  about that ROOM. The List of current-users in the room is Null if you get\n   them via SOAP. The Roomtype can be 'conference', 'presentation' or 'interview'.", responses={@ApiResponse(responseCode="200", description="list of public rooms", content={@Content(schema=@Schema(implementation=RoomDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<RoomDTO> getPublic(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="Type of public rooms need to be retrieved") @PathParam(value="type") @WebParam(name="type") String type) throws ServiceException {
        Room.Type t = Strings.isEmpty((String)type) ? null : Room.Type.valueOf((String)type);
        return this.performCall(sid, User.Right.ROOM, (Sessiondata sd) -> RoomDTO.list((List)this.roomDao.getPublicRooms(t)));
    }

    @WebMethod
    @GET
    @Path(value="/{id}")
    @Operation(description="Returns a conference room object", responses={@ApiResponse(responseCode="200", description="room with the id given", content={@Content(schema=@Schema(implementation=RoomDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public RoomDTO getRoomById(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the room id") @PathParam(value="id") @WebParam(name="id") Long id) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> new RoomDTO(this.roomDao.get(id)));
    }

    private Room updateRtoRoom(Room r, Long userId) {
        if (r.getFiles() == null) {
            r.setFiles(new ArrayList());
        }
        if (r.getId() == null) {
            List files = r.getFiles();
            r.setFiles(null);
            r = this.roomDao.update(r, userId);
            r.setFiles(files);
        }
        for (RoomFile rf : r.getFiles()) {
            rf.setRoomId(r.getId());
        }
        return this.roomDao.update(r, userId);
    }

    @WebMethod
    @GET
    @Path(value="/{type}/{externaltype}/{externalid}")
    @Operation(description="Checks if a room with this exteralId + externalType does exist,\n if yes it returns the room id if not, it will create the room and then\n return the room id of the newly created room", responses={@ApiResponse(responseCode="200", description="id of the room or error code", content={@Content(schema=@Schema(implementation=RoomDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public RoomDTO getExternal(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="type of the room") @PathParam(value="type") @WebParam(name="type") String type, @Parameter(required=true, description="you can specify your system-name or type of room here, for example \"moodle\"") @PathParam(value="externaltype") @WebParam(name="externaltype") String externalType, @Parameter(required=true, description="your external room id may set here") @PathParam(value="externalid") @WebParam(name="externalid") String externalId, @Parameter(required=true, description="details of the room to be created if not found") @WebParam(name="room") @QueryParam(value="room") RoomDTO room) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Room r = this.roomDao.getExternal(Room.Type.valueOf((String)type), externalType, externalId);
            if (r == null) {
                if (room == null) {
                    return null;
                }
                room.setExternalType(externalType);
                room.setExternalId(externalId);
                r = this.rMapper.get(room);
                r = this.updateRtoRoom(r, sd.getUserId());
                return new RoomDTO(r);
            }
            return new RoomDTO(r);
        });
    }

    @WebMethod
    @POST
    @Path(value="/")
    @Operation(description="Adds a new ROOM like through the Frontend", responses={@ApiResponse(responseCode="200", description="Room object or throw error", content={@Content(schema=@Schema(implementation=RoomDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public RoomDTO add(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="room object") @WebParam(name="room") @FormParam(value="room") RoomDTO room) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Room r = this.rMapper.get(room);
            r = this.updateRtoRoom(r, sd.getUserId());
            return new RoomDTO(r);
        });
    }

    @WebMethod
    @DELETE
    @Path(value="/{id}")
    @Operation(description="Delete a room by its room id", responses={@ApiResponse(responseCode="200", description="id of the room deleted", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult delete(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="The id of the room") @WebParam(name="id") @PathParam(value="id") long id) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Room r = (Room)this.roomDao.get(id);
            if (r == null) {
                return new ServiceResult("Not found", ServiceResult.Type.SUCCESS);
            }
            this.roomDao.delete(r, sd.getUserId());
            return new ServiceResult("Deleted", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @GET
    @Path(value="/close/{id}")
    @Operation(description="Method to remotely close rooms. If a room is closed all users\n inside the room and all users that try to enter it will be redirected to\n  the redirectURL that is defined in the ROOM-Object.", responses={@ApiResponse(responseCode="200", description="1 in case of success, -2 otherwise", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult close(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the room id") @WebParam(name="id") @PathParam(value="id") long id) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Long userId = sd.getUserId();
            Room room = (Room)this.roomDao.get(id);
            room.setClosed(true);
            this.roomDao.update(room, userId);
            WebSocketHelper.sendRoom((RoomMessage)new RoomMessage(room.getId(), this.userDao.get(userId), RoomMessage.Type.ROOM_CLOSED));
            return new ServiceResult("Closed", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @GET
    @Path(value="/open/{id}")
    @Operation(description="Method to remotely open rooms. If a room is closed all users\n inside the room and all users that try to enter it will be redirected to\n  the redirectURL that is defined in the ROOM-Object.", responses={@ApiResponse(responseCode="200", description="1 in case of success, -2 otherwise", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult open(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the room id") @WebParam(name="id") @PathParam(value="id") long id) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Room room = (Room)this.roomDao.get(id);
            room.setClosed(false);
            this.roomDao.update(room, sd.getUserId());
            return new ServiceResult("Opened", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @GET
    @Path(value="/kick/{id}")
    @Operation(description="Kick all uses of a certain room", responses={@ApiResponse(responseCode="200", description="true if USER was kicked, false otherwise", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult kickAll(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the room id") @WebParam(name="id") @PathParam(value="id") long id) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            boolean result = this.userManager.kickUsersByRoomId(Long.valueOf(id));
            return new ServiceResult(result ? "Kicked" : "Not kicked", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @GET
    @Path(value="/kick/{id}/{externalType}/{externalId}")
    @Operation(description="kick external USER from given room", responses={@ApiResponse(responseCode="200", description="'Kicked' if USER was 'Not kicked' otherwise", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult kick(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the room id") @WebParam(name="id") @PathParam(value="id") long id, @Parameter(required=true, description="external type of USER to kick") @WebParam(name="externalType") @PathParam(value="externalType") String externalType, @Parameter(required=true, description="external id of USER to kick") @WebParam(name="externalId") @PathParam(value="externalId") String externalId) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            boolean result = this.userManager.kickExternal(Long.valueOf(id), externalType, externalId);
            return new ServiceResult(result ? "Kicked" : "Not kicked", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @GET
    @Path(value="/count/{roomid}")
    @Operation(description="Returns the count of users currently in the ROOM with given id", responses={@ApiResponse(responseCode="200", description="number of users as int", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult count(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="roomId id of the room to get users") @WebParam(name="roomid") @PathParam(value="roomid") Long roomId) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> new ServiceResult(String.valueOf(this.clientManager.streamByRoom(roomId).count()), ServiceResult.Type.SUCCESS));
    }

    @WebMethod
    @GET
    @Path(value="/users/{roomid}")
    @Operation(description="Returns list of users currently in the ROOM with given id", responses={@ApiResponse(responseCode="200", description="List of users in the room", content={@Content(schema=@Schema(implementation=UserDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<UserDTO> users(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="roomId id of the room to get users") @WebParam(name="roomid") @PathParam(value="roomid") Long roomId) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> this.clientManager.streamByRoom(roomId).map(c -> new UserDTO(c.getUser())).toList());
    }

    @WebMethod
    @POST
    @Path(value="/hash")
    @Operation(description="Method to get invitation hash with given parameters", responses={@ApiResponse(responseCode="200", description="serviceResult object with the result", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult hash(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="parameters of the invitation") @WebParam(name="invite") @QueryParam(value="invite") InvitationDTO invite, @Parameter(required=true, description="flag to determine if email should be sent or not") @WebParam(name="sendmail") @QueryParam(value="sendmail") boolean sendmail) throws ServiceException {
        log.debug("[hash] invite {}", (Object)invite);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Invitation i = this.rMapper.get(invite, sd.getUserId());
            if ((i = this.inviteDao.update(i)) != null) {
                if (sendmail) {
                    try {
                        this.inviteManager.sendInvitationLink(i, Invitation.MessageType.CREATE, invite.getSubject(), invite.getMessage(), false, null);
                    }
                    catch (Exception e) {
                        throw new InternalServiceException(e.getMessage());
                    }
                }
                return new ServiceResult(i.getHash(), ServiceResult.Type.SUCCESS);
            }
            return new ServiceResult("error.unknown", ServiceResult.Type.ERROR);
        });
    }
}

