/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.cxf.feature.Features;
import org.apache.openmeetings.db.dto.basic.Health;
import org.apache.openmeetings.db.dto.basic.Info;
import org.apache.openmeetings.util.OmVersion;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.webservice.schema.HealthWrapper;
import org.apache.openmeetings.webservice.schema.InfoWrapper;
import org.springframework.stereotype.Service;

@Service(value="infoWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.InfoWebService", targetNamespace="http://webservice.openmeetings.apache.org/")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="InfoService")
@Path(value="/info")
public class InfoWebService {
    @WebMethod
    @GET
    @Path(value="/version")
    @Operation(description="Method to get current OpenMeetings version", responses={@ApiResponse(responseCode="200", description="Current version", content={@Content(schema=@Schema(implementation=InfoWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of server error")})
    public Info getVersion() {
        return new Info();
    }

    @WebMethod
    @GET
    @Path(value="/health")
    @Operation(description="Method to get health report for this OpenMeetings instance", responses={@ApiResponse(responseCode="200", description="health report", content={@Content(schema=@Schema(implementation=HealthWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of server error")})
    public Health getHealth() {
        return Health.getInstance();
    }

    @WebMethod
    @GET
    @Path(value="/manifest.webmanifest")
    @Produces(value={"application/manifest+json"})
    public String getManifest() {
        URI omPath = OpenmeetingsVariables.getWebappPath();
        return new JSONObject().put("name", (Object)(OpenmeetingsVariables.getApplicationName() + " " + OmVersion.getVersion())).put("short_name", (Object)(OpenmeetingsVariables.getApplicationName() + " " + OmVersion.getVersion())).put("description", (Object)"Openmeetings provides video conferencing, instant messaging, white board, collaborative document editing and other groupware tools.").put("start_url", (Object)omPath.resolve("?pwa=true")).put("scope", (Object)"/").put("background_color", (Object)"#ffffff").put("theme_color", (Object)"#ffffff").put("dir", (Object)"auto").put("display", (Object)"standalone").put("orientation", (Object)"landscape").put("icons", (Object)new JSONArray().put((Object)this.generateIcon("manifest-icon-512.maskable.png", "512x512", "maskable", omPath)).put((Object)this.generateIcon("manifest-icon-192.maskable.png", "192x192", "maskable", omPath))).put("prefer_related_applications", false).toString(2);
    }

    private JSONObject generateIcon(String name, String dimension, String purpose, URI omPath) {
        return new JSONObject().put("src", (Object)omPath.resolve("images/icons/" + name)).put("type", (Object)"image/png").put("sizes", (Object)dimension).put("purpose", (Object)purpose);
    }
}

