/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.agilecoders.wicket.jquery.WicketJquerySelectors;
import de.agilecoders.wicket.jquery.settings.ObjectMapperFactory;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public final class Json {
    private Json() {
        throw new UnsupportedOperationException();
    }

    public static <T> T fromJson(String json, JavaType type) {
        try {
            return (T)Json.createObjectMapper().readValue(json, type);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        return Holder.factory.newObjectMapper();
    }

    public static JsonNode toJson(Object data) {
        if (data == null) {
            return Json.newObject();
        }
        try {
            return Json.createObjectMapper().valueToTree(data);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T fromJson(JsonNode json, Class<T> clazz) {
        try {
            return (T)Json.createObjectMapper().treeToValue((TreeNode)json, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return Json.fromJson(Json.parse(json), clazz);
    }

    public static ObjectNode newObject() {
        return Json.createObjectMapper().createObjectNode();
    }

    public static String stringify(JsonNode json) {
        try {
            return json != null ? Json.createObjectMapper().writeValueAsString((Object)json) : "{}";
        }
        catch (JsonProcessingException jpx) {
            throw new RuntimeException("A problem occurred while stringifying a JsonNode: " + jpx.getMessage(), jpx);
        }
    }

    public static String stringify(Object data) {
        return Json.stringify(Json.toJson(data));
    }

    public static boolean isValid(String json) {
        if (Strings.isEmpty((String)json)) {
            return false;
        }
        try {
            return Json.parse(json) != null;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static JsonNode parse(String jsonString) {
        if (Strings.isEmpty((String)jsonString)) {
            return Json.newObject();
        }
        try {
            return (JsonNode)Json.createObjectMapper().readValue(jsonString, JsonNode.class);
        }
        catch (Throwable e) {
            throw new ParseException(String.format("can't parse string [%s]", jsonString), e);
        }
    }

    public static final class RawValue
    implements IClusterable {
        private final String value;

        public RawValue(String value) {
            this.value = Args.notEmpty((String)value, (String)"value");
        }

        public String value() {
            return this.value;
        }
    }

    public static final class ParseException
    extends RuntimeException {
        public ParseException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public ParseException(Throwable throwable) {
            super(throwable);
        }
    }

    private static final class Holder {
        private static final ObjectMapperFactory factory = WicketJquerySelectors.assignedSettingsOrDefault().getObjectMapperFactory();

        private Holder() {
        }
    }
}

