/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.openmeetings.db.dao.IGroupAdminDataProviderDao;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class GroupDao
implements IGroupAdminDataProviderDao<Group> {
    private static final List<String> searchFields = List.of("name");
    private static final List<String> guSearchFields = List.copyOf(searchFields.stream().map(n -> "group." + n).toList());
    @PersistenceContext
    private EntityManager em;

    @Override
    public Group get(Long id) {
        return (Group)DaoHelper.only(this.em.createNamedQuery("getGroupById", Group.class).setParameter("id", (Object)id).getResultList());
    }

    public Group get(String name) {
        List groups = this.em.createNamedQuery("getGroupByName", Group.class).setParameter("name", (Object)name).getResultList();
        return groups == null || groups.isEmpty() ? null : (Group)groups.get(0);
    }

    public Group getExternal(String name) {
        Group g;
        List groups = this.em.createNamedQuery("getExtGroupByName", Group.class).setParameter("name", (Object)name).getResultList();
        Group group = g = groups == null || groups.isEmpty() ? null : (Group)groups.get(0);
        if (g == null) {
            g = this.update(new Group().setExternal(true).setName(name), (Long)null);
        }
        return g;
    }

    @Override
    public List<Group> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getNondeletedGroups", Group.class), start, count).getResultList();
    }

    @Override
    public List<Group> get(String search, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, Group.class, false, search, searchFields, true, null, sort, start, count);
    }

    private Predicate getAdminFilter(Long adminId, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root<GroupUser> root = DaoHelper.getRoot(query, GroupUser.class);
        return builder.and((Expression)builder.equal((Expression)root.get("user").get("id"), (Object)adminId), (Expression)builder.isTrue((Expression)root.get("moderator")));
    }

    @Override
    public List<Group> adminGet(String search, Long adminId, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, GroupUser.class, Group.class, (builder, root) -> root.get("group"), true, search, guSearchFields, true, (b, q) -> this.getAdminFilter(adminId, (CriteriaBuilder)b, (CriteriaQuery<?>)q), sort, start, count);
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countGroups", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return DaoHelper.count(this.em, Group.class, search, searchFields, true, null);
    }

    @Override
    public long adminCount(String search, Long adminId) {
        return DaoHelper.count(this.em, GroupUser.class, (builder, root) -> builder.countDistinct((Expression)root.get("group")), search, guSearchFields, false, (b, q) -> this.getAdminFilter(adminId, (CriteriaBuilder)b, (CriteriaQuery<?>)q.distinct(true)));
    }

    public List<Group> get(Collection<Long> ids) {
        return this.em.createNamedQuery("getGroupsByIds", Group.class).setParameter("ids", ids).getResultList();
    }

    public List<Group> getLimited() {
        return this.em.createNamedQuery("getLimitedGroups", Group.class).getResultList();
    }

    public List<Group> getGroupsForUserNotifications() {
        return this.em.createNamedQuery("getGroupsForUserNotifications", Group.class).getResultList();
    }

    @Override
    public Group update(Group entity, Long userId) {
        if (entity.getId() == null) {
            if (userId != null) {
                entity.setInsertedby(userId);
            }
            this.em.persist((Object)entity);
        } else {
            if (userId != null) {
                entity.setUpdatedby(userId);
            }
            entity = (Group)this.em.merge((Object)entity);
        }
        return entity;
    }

    @Override
    public void delete(Group g, Long userId) {
        this.em.createNamedQuery("deleteGroupUsersByGroup").setParameter("id", (Object)g.getId()).executeUpdate();
        g.setDeleted(true);
        if (userId != null) {
            g.setUpdatedby(userId);
        }
        this.em.merge((Object)g);
    }
}

