/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.basic;

import com.github.openjson.JSONObject;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.event.RemoteCommitProvider;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Configuration;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.util.OmVersion;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.wicket.Application;
import org.apache.wicket.csp.CSPDirective;
import org.apache.wicket.csp.CSPDirectiveSrcValue;
import org.apache.wicket.csp.CSPHeaderConfiguration;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ConfigurationDao
implements IDataProviderDao<Configuration> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationDao.class);
    private static final List<String> searchFields = List.of("key", "value");
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OAuth2Dao oauthDao;
    @Autowired
    private IApplication app;

    public void updateClusterAddresses(String addresses) throws UnknownHostException {
        OpenJPAConfiguration cfg = ((OpenJPAEntityManagerSPI)OpenJPAPersistence.cast((EntityManager)this.em)).getConfiguration();
        RemoteCommitProvider prov = cfg.getRemoteCommitEventManager().getRemoteCommitProvider();
        if (prov instanceof TCPRemoteCommitProvider) {
            TCPRemoteCommitProvider tcpProv = (TCPRemoteCommitProvider)prov;
            tcpProv.setAddresses(addresses);
        }
    }

    public Configuration forceGet(String key) {
        try {
            List list = this.em.createNamedQuery("forceGetConfigurationByKey", Configuration.class).setParameter("key", (Object)key).getResultList();
            if (list.isEmpty()) {
                return null;
            }
            Configuration c = (Configuration)list.get(0);
            return c.getKey().equals(key) ? c : null;
        }
        catch (Exception e) {
            log.error("[forceGet]: ", (Throwable)e);
            return null;
        }
    }

    public List<Configuration> get(String ... keys) {
        ArrayList<Configuration> result = new ArrayList<Configuration>();
        for (String key : keys) {
            List r = this.em.createNamedQuery("getConfigurationsByKeys", Configuration.class).setParameter("keys", List.of(key)).getResultList();
            result.add(r.isEmpty() ? null : (Configuration)r.get(0));
        }
        return result;
    }

    public Configuration get(String key) {
        List<Configuration> list = this.get(new String[]{key});
        if (list == null || list.isEmpty() || list.get(0) == null) {
            log.warn("Could not find key in configurations: {}", (Object)key);
            return null;
        }
        return list.get(0);
    }

    public boolean getBool(String key, boolean def) {
        Configuration c = this.get(key);
        if (c != null) {
            try {
                return c.getValueB();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public Long getLong(String key, Long def) {
        Configuration c = this.get(key);
        if (c != null) {
            try {
                return c.getValueN();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public int getInt(String key, int def) {
        Configuration c = this.get(key);
        if (c != null) {
            try {
                Long val = c.getValueN();
                return val == null ? def : val.intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public String getString(String key, String def) {
        Configuration c = this.get(key);
        return c != null && c.getValue() != null ? c.getValue() : def;
    }

    @Override
    public Configuration get(Long id) {
        if (id == null) {
            return null;
        }
        return (Configuration)this.em.createNamedQuery("getConfigurationById", Configuration.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<Configuration> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getNondeletedConfiguration", Configuration.class), start, count).getResultList();
    }

    @Override
    public List<Configuration> get(String search, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, Configuration.class, true, search, searchFields, false, null, sort, start, count);
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countConfigurations", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return DaoHelper.count(this.em, Configuration.class, search, searchFields, true, null);
    }

    @Override
    public Configuration update(Configuration entity, Long userId) {
        return this.update(entity, userId, false);
    }

    public Configuration update(Configuration entity, Long userId, boolean deleted) {
        String key = entity.getKey();
        String value = entity.getValue();
        if (entity.getId() == null || entity.getId() <= 0L) {
            entity.setDeleted(deleted);
            this.em.persist((Object)entity);
        } else {
            entity.setUser(this.userDao.get(userId));
            entity.setDeleted(deleted);
            entity = (Configuration)this.em.merge((Object)entity);
        }
        switch (key) {
            case "cam.fps": 
            case "mic.echo.cancellation": 
            case "mic.noise.suppression": 
            case "mic.rate": 
            case "video.arrange.keycode": 
            case "mute.others.keycode": 
            case "mute.keycode": 
            case "start.quickpoll.keycode": 
            case "video.arrange.resize.keycode": 
            case "auto.open.sharing": {
                this.reloadRoomSettings();
                break;
            }
            case "max.upload.size": {
                this.reloadMaxUpload();
                break;
            }
            case "crypt.class.name": {
                this.reloadCrypt();
                break;
            }
            case "application.name": {
                OpenmeetingsVariables.setApplicationName((String)value);
                break;
            }
            case "application.base.url": {
                this.reloadBaseUrl();
                break;
            }
            case "sip.enable": {
                this.reloadSipEnabled();
                break;
            }
            case "external.process.ttl": {
                OpenmeetingsVariables.setExtProcessTtl((int)NumberUtils.toInt((String)value));
                break;
            }
            case "default.lang.id": {
                this.reloadDefaultLang();
                break;
            }
            case "mp4.audio.rate": {
                this.reloadAudioRate();
                break;
            }
            case "mp4.audio.bitrate": {
                this.reloadAudioBitrate();
                break;
            }
            case "mp4.video.preset": {
                this.reloadVideoPreset();
                break;
            }
            case "default.timezone": {
                this.reloadTimezone();
                break;
            }
            case "rest.allow.origin": {
                this.reloadRestAllowOrigin();
                break;
            }
            case "user.login.minimum.length": 
            case "user.pass.minimum.length": 
            case "user.pass.check.upper": 
            case "user.pass.check.digit": 
            case "user.pass.check.special": {
                this.reloadLoginPassword();
                break;
            }
            case "default.group.id": {
                this.reloadDefaultGroup();
                break;
            }
            case "sip.exten.context": {
                this.reloadSipContext();
                break;
            }
            case "user.fname.minimum.length": {
                this.reloadFnameMinLength();
                break;
            }
            case "user.lname.minimum.length": {
                this.reloadLnameMinLength();
                break;
            }
            case "chat.send.on.enter": {
                this.reloadChatSendOnEnter();
                break;
            }
            case "allow.frontend.register": 
            case "allow.soap.register": 
            case "allow.oauth.register": {
                this.reloadRegister();
                break;
            }
            case "send.email.with.verfication": {
                this.reloadSendVerificationEmail();
                break;
            }
            case "send.email.at.register": {
                this.reloadSendRegisterEmail();
                break;
            }
            case "display.name.editable": {
                this.reloadDisplayNameEditable();
                break;
            }
            case "personal.rooms.enabled": {
                this.reloadMyRoomsEnabled();
                break;
            }
            case "google.analytics.code": 
            case "header.csp.font": 
            case "header.csp.frame": 
            case "header.csp.image": 
            case "header.csp.media": 
            case "header.csp.script": 
            case "header.csp.style": 
            case "header.csp.enabled": {
                this.updateCsp();
                break;
            }
            case "mail.smtp.server": 
            case "mail.smtp.port": 
            case "mail.smtp.system.email": 
            case "mail.smtp.user": 
            case "mail.smtp.pass": 
            case "mail.smtp.starttls.enable": 
            case "mail.smtp.ssl.enable": 
            case "inviter.email.as.replyto": 
            case "mail.smtp.connection.timeout": 
            case "mail.smtp.timeout": {
                this.reloadMailSettings();
                break;
            }
            case "number.minutes.reminder.send": 
            case "appointment.pre.start.minutes": {
                this.reloadAppointmentSettings();
                break;
            }
            case "recording.enabled": {
                this.reloadRecordingEnabled();
                break;
            }
            case "ui.theme": {
                this.reloadTheme();
                break;
            }
            case "otp.enabled": {
                this.reloadOtpEnabled();
                break;
            }
        }
        return entity;
    }

    @Override
    public void delete(Configuration entity, Long userId) {
        this.update(entity, userId, true);
    }

    private void reloadMaxUpload() {
        try {
            OpenmeetingsVariables.setMaxUploadSize((long)this.getLong("max.upload.size", 0x6400000L));
        }
        catch (Exception e) {
            log.error("Invalid value saved for max_upload_size conf key: ", (Throwable)e);
        }
    }

    private void reloadCrypt() {
        String cryptClass = this.getString("crypt.class.name", null);
        if (cryptClass != null) {
            OpenmeetingsVariables.setCryptClassName((String)cryptClass);
            CryptProvider.reset();
        }
    }

    private void reloadBaseUrl() {
        Object val = this.getString("application.base.url", "https://localhost:5443/openmeetings/");
        if (val != null && !((String)val).endsWith("/")) {
            val = (String)val + "/";
        }
        OpenmeetingsVariables.setBaseUrl((String)val);
    }

    private void reloadSipEnabled() {
        OpenmeetingsVariables.setSipEnabled((boolean)this.getBool("sip.enable", false));
    }

    private void reloadDefaultLang() {
        OpenmeetingsVariables.setDefaultLang((Long)this.getLong("default.lang.id", 1L));
    }

    private void reloadAudioRate() {
        OpenmeetingsVariables.setAudioRate((int)this.getInt("mp4.audio.rate", 22050));
    }

    private void reloadAudioBitrate() {
        OpenmeetingsVariables.setAudioBitrate((String)this.getString("mp4.audio.bitrate", "32k"));
    }

    private void reloadVideoPreset() {
        OpenmeetingsVariables.setVideoPreset((String)this.getString("mp4.video.preset", "medium"));
    }

    private void reloadTimezone() {
        String defaultTzName = this.getString("default.timezone", "Europe/Berlin");
        TimeZone timeZoneByOmTimeZone = TimeZone.getTimeZone(defaultTzName);
        if (timeZoneByOmTimeZone == null) {
            log.error("There is no correct time zone set in the configuration of OpenMeetings for the key default.timezone or key is missing in table, using default locale!");
            defaultTzName = TimeZone.getDefault().getID();
        }
        OpenmeetingsVariables.setDefaultTimezone((String)defaultTzName);
    }

    private void reloadRestAllowOrigin() {
        OpenmeetingsVariables.setRestAllowOrigin((String)this.getString("rest.allow.origin", null));
    }

    private void reloadLoginPassword() {
        OpenmeetingsVariables.setMinLoginLength((int)this.getInt("user.login.minimum.length", 4));
        OpenmeetingsVariables.setMinPasswdLength((int)this.getInt("user.login.minimum.length", 8));
        OpenmeetingsVariables.setPwdCheckUpper((boolean)this.getBool("user.pass.check.upper", true));
        OpenmeetingsVariables.setPwdCheckDigit((boolean)this.getBool("user.pass.check.digit", true));
        OpenmeetingsVariables.setPwdCheckSpecial((boolean)this.getBool("user.pass.check.special", true));
    }

    private void reloadDefaultGroup() {
        OpenmeetingsVariables.setDefaultGroup((Long)this.getLong("default.group.id", null));
    }

    private void reloadSipContext() {
        OpenmeetingsVariables.setSipContext((String)this.getString("sip.exten.context", "rooms"));
    }

    private void reloadFnameMinLength() {
        OpenmeetingsVariables.setMinFnameLength((int)this.getInt("user.fname.minimum.length", 4));
    }

    private void reloadLnameMinLength() {
        OpenmeetingsVariables.setMinLnameLength((int)this.getInt("user.lname.minimum.length", 4));
    }

    private void reloadChatSendOnEnter() {
        OpenmeetingsVariables.setChatSendOnEnter((boolean)this.getBool("chat.send.on.enter", false));
    }

    private void reloadRegister() {
        OpenmeetingsVariables.setAllowRegisterFrontend((boolean)this.getBool("allow.frontend.register", false));
        OpenmeetingsVariables.setAllowRegisterSoap((boolean)this.getBool("allow.soap.register", false));
        OpenmeetingsVariables.setAllowRegisterOauth((boolean)this.getBool("allow.oauth.register", false));
    }

    private void reloadSendVerificationEmail() {
        OpenmeetingsVariables.setSendVerificationEmail((boolean)this.getBool("send.email.with.verfication", false));
    }

    private void reloadSendRegisterEmail() {
        OpenmeetingsVariables.setSendRegisterEmail((boolean)this.getBool("send.email.at.register", false));
    }

    private void reloadDisplayNameEditable() {
        OpenmeetingsVariables.setDisplayNameEditable((boolean)this.getBool("display.name.editable", false));
    }

    private void reloadMyRoomsEnabled() {
        OpenmeetingsVariables.setMyRoomsEnabled((boolean)this.getBool("personal.rooms.enabled", true));
    }

    private void reloadMailSettings() {
        OpenmeetingsVariables.setSmtpServer((String)this.getString("mail.smtp.server", null));
        OpenmeetingsVariables.setSmtpPort((int)this.getInt("mail.smtp.port", 25));
        OpenmeetingsVariables.setSmtpUser((String)this.getString("mail.smtp.user", null));
        OpenmeetingsVariables.setSmtpPass((String)this.getString("mail.smtp.pass", null));
        OpenmeetingsVariables.setSmtpUseTls((boolean)this.getBool("mail.smtp.starttls.enable", false));
        OpenmeetingsVariables.setSmtpUseSsl((boolean)this.getBool("mail.smtp.ssl.enable", false));
        OpenmeetingsVariables.setSmtpTimeOut((int)this.getInt("mail.smtp.timeout", 30000));
        OpenmeetingsVariables.setSmtpConnectionTimeOut((int)this.getInt("mail.smtp.connection.timeout", 30000));
        OpenmeetingsVariables.setMailFrom((String)this.getString("mail.smtp.system.email", null));
        OpenmeetingsVariables.setMailAddReplyTo((boolean)this.getBool("inviter.email.as.replyto", true));
    }

    private void reloadAppointmentSettings() {
        OpenmeetingsVariables.setAppointmentPreStartMinutes((int)this.getInt("appointment.pre.start.minutes", 5));
        OpenmeetingsVariables.setAppointmentReminderMinutes((int)this.getInt("number.minutes.reminder.send", 15));
    }

    private void reloadRecordingEnabled() {
        OpenmeetingsVariables.setRecordingsEnabled((boolean)this.getBool("recording.enabled", true));
    }

    private void reloadTheme() {
        OpenmeetingsVariables.setTheme((String)this.getString("ui.theme", ""));
        this.app.updateTheme();
    }

    private void reloadOtpEnabled() {
        OpenmeetingsVariables.setOtpEnabled((boolean)this.getBool("otp.enabled", false));
    }

    public void reinit() {
        this.reloadMaxUpload();
        this.reloadCrypt();
        OpenmeetingsVariables.setApplicationName((String)this.getString("application.name", "OpenMeetings"));
        this.reloadDefaultLang();
        this.reloadBaseUrl();
        this.reloadSipEnabled();
        this.reloadAudioRate();
        this.reloadAudioBitrate();
        this.reloadVideoPreset();
        this.reloadTimezone();
        this.reloadRestAllowOrigin();
        this.reloadRoomSettings();
        this.reloadLoginPassword();
        this.reloadDefaultGroup();
        this.reloadSipContext();
        this.reloadFnameMinLength();
        this.reloadLnameMinLength();
        this.reloadChatSendOnEnter();
        this.reloadRegister();
        this.reloadSendVerificationEmail();
        this.reloadSendRegisterEmail();
        this.reloadDisplayNameEditable();
        this.reloadMyRoomsEnabled();
        this.reloadMailSettings();
        this.reloadAppointmentSettings();
        this.reloadRecordingEnabled();
        this.reloadTheme();
        this.reloadOtpEnabled();
        this.updateCsp();
    }

    private static JSONObject getHotkey(String value) {
        List<String> partList = List.of(value.split("\\+"));
        HashSet<String> parts = new HashSet<String>(partList);
        return new JSONObject().put("alt", parts.contains("Alt")).put("shift", parts.contains("Shift")).put("ctrl", parts.contains("Ctrl")).put("code", (Object)partList.get(partList.size() - 1));
    }

    private JSONObject reloadRoomSettings() {
        try {
            OpenmeetingsVariables.setRoomSettings((JSONObject)new JSONObject().put("keycode", (Object)new JSONObject().put("arrange", (Object)ConfigurationDao.getHotkey(this.getString("video.arrange.keycode", "Shift+F8"))).put("arrangeresize", (Object)ConfigurationDao.getHotkey(this.getString("video.arrange.resize.keycode", "Ctrl+Shift+KeyA"))).put("muteothers", (Object)ConfigurationDao.getHotkey(this.getString("mute.others.keycode", "Shift+F12"))).put("mute", (Object)ConfigurationDao.getHotkey(this.getString("mute.keycode", "Shift+F7"))).put("quickpoll", (Object)ConfigurationDao.getHotkey(this.getString("start.quickpoll.keycode", "Ctrl+Alt+KeyQ")))).put("camera", (Object)new JSONObject().put("fps", (Object)this.getLong("cam.fps", 30L))).put("microphone", (Object)new JSONObject().put("rate", (Object)this.getLong("mic.rate", 30L)).put("echo", this.getBool("mic.echo.cancellation", true)).put("noise", this.getBool("mic.noise.suppression", true))).put("autoOpenSharing", this.getBool("auto.open.sharing", false)));
        }
        catch (Exception e) {
            log.error("Unexpected exception while reloading room settings: ", (Throwable)e);
        }
        return OpenmeetingsVariables.getRoomSettings();
    }

    private void addCspRule(CSPHeaderConfiguration cspConfig, CSPDirective key, String val) {
        this.addCspRule(cspConfig, key, val, true);
    }

    private void addCspRule(CSPHeaderConfiguration cspConfig, CSPDirective key, String val, boolean remove) {
        if (!Strings.isEmpty((String)val)) {
            for (String str : val.split(",")) {
                if (Strings.isEmpty((String)str)) continue;
                try {
                    cspConfig.add(key, new String[]{str.trim()});
                }
                catch (Exception e) {
                    log.error("Unexpected error while adding CSP rule: key '{}', value '{}', part '{}'", new Object[]{key, val, str, e});
                }
            }
        } else if (remove) {
            cspConfig.remove(key);
        }
    }

    public void updateCsp() {
        OpenmeetingsVariables.setGaCode((String)this.getString("google.analytics.code", null));
        if (!this.getBool("header.csp.enabled", true)) {
            StringBuilder sb = new StringBuilder("\n");
            OmVersion.getLine((StringBuilder)sb, (String)"", (char)'#');
            OmVersion.getLine((StringBuilder)sb, (String)"CSP headers are DISABLED", (char)' ');
            OmVersion.getLine((StringBuilder)sb, (String)"Disabling CSP can lead to XSS attacks! Use this mode only if you must!", (char)' ');
            OmVersion.getLine((StringBuilder)sb, (String)"", (char)'#');
            log.warn("{}", (Object)sb);
            WebApplication.get().getCspSettings().blocking().disabled();
            return;
        }
        OpenmeetingsVariables.setCspFontSrc((String)this.getString("header.csp.font", "https://fonts.gstatic.com"));
        OpenmeetingsVariables.setCspFrameSrc((String)this.getString("header.csp.frame", CSPDirectiveSrcValue.SELF.getValue()));
        OpenmeetingsVariables.setCspImageSrc((String)this.getString("header.csp.image", OpenmeetingsVariables.DEFAULT_CSP_DATA));
        OpenmeetingsVariables.setCspMediaSrc((String)this.getString("header.csp.media", OpenmeetingsVariables.DEFAULT_CSP_DATA));
        OpenmeetingsVariables.setCspScriptSrc((String)this.getString("header.csp.script", CSPDirectiveSrcValue.STRICT_DYNAMIC.getValue()));
        OpenmeetingsVariables.setCspStyleSrc((String)this.getString("header.csp.style", OpenmeetingsVariables.DEFAULT_CSP_STYLE));
        if (Application.exists()) {
            CSPHeaderConfiguration cspConfig = WebApplication.get().getCspSettings().blocking().strict();
            this.addCspRule(cspConfig, CSPDirective.FONT_SRC, OpenmeetingsVariables.getCspFontSrc());
            this.addCspRule(cspConfig, CSPDirective.FRAME_SRC, OpenmeetingsVariables.getCspFrameSrc());
            this.addCspRule(cspConfig, CSPDirective.IMG_SRC, OpenmeetingsVariables.getCspImageSrc());
            this.addCspRule(cspConfig, CSPDirective.MEDIA_SRC, OpenmeetingsVariables.getCspMediaSrc());
            this.addCspRule(cspConfig, CSPDirective.SCRIPT_SRC, OpenmeetingsVariables.getCspScriptSrc());
            this.addCspRule(cspConfig, CSPDirective.STYLE_SRC, OpenmeetingsVariables.getCspStyleSrc());
            this.app.getWsUrls().forEach(wsUrl -> this.addCspRule(cspConfig, CSPDirective.CONNECT_SRC, (String)wsUrl, false));
            if (!Strings.isEmpty((String)OpenmeetingsVariables.getGaCode())) {
                this.addCspRule(cspConfig, CSPDirective.IMG_SRC, "https://www.google-analytics.com");
                this.addCspRule(cspConfig, CSPDirective.CONNECT_SRC, "https://www.google-analytics.com");
                this.addCspRule(cspConfig, CSPDirective.SCRIPT_SRC, "https://www.googletagmanager.com");
            }
            this.oauthDao.getActive().forEach(oauth -> {
                if (!Strings.isEmpty((String)oauth.getIconUrl())) {
                    this.addCspRule(cspConfig, CSPDirective.IMG_SRC, oauth.getIconUrl(), false);
                }
            });
        }
    }
}

