/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class ReflectionUtil {
    private static final ConcurrentHashMap<Class<?>, Map<String, Method>> setterMap = new ConcurrentHashMap();
    private static final Log logger = LogFactory.getLog(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static Map<String, Method> getGetters(Class<?> clazz) {
        Method[] methods;
        HashMap<String, Method> accessors = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String name = null;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                name = methodName.substring(3);
            } else if (methodName.startsWith("is")) {
                name = methodName.substring(2);
            }
            if (name == null || name.length() == 0 || method.getParameterTypes().length != 0) continue;
            accessors.put(name.toLowerCase(Locale.ENGLISH), method);
        }
        return accessors;
    }

    public static Map<String, Method> getSetters(Class<?> clazz) {
        return setterMap.computeIfAbsent(clazz, c -> ReflectionUtil.getSettersInternal(c));
    }

    private static Map<String, Method> getSettersInternal(Class<?> clazz) {
        Method[] methods;
        HashMap<String, Method> accessors = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String name = methodName.substring("set".length()).toLowerCase(Locale.US);
            Method existing = (Method)accessors.get(name);
            if (existing != null) {
                logger.warn("multiple setters (case insensitive) exist for " + name + " on class(es) " + existing.getDeclaringClass() + " and " + method.getDeclaringClass());
            }
            if (existing == null) {
                accessors.put(name, method);
                continue;
            }
            if (!method.getDeclaringClass().isAssignableFrom(existing.getDeclaringClass())) {
                logger.warn("Preferring setter from extending class " + existing + " -> " + method);
                accessors.put(name, method);
                continue;
            }
            logger.warn("Preferring setter from extending class " + method + " -> " + existing);
        }
        return accessors;
    }

    public static String stripIllegalCharacters(String s) {
        char c;
        int i;
        boolean needsStrip = false;
        if (s == null) {
            return null;
        }
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
            needsStrip = true;
            break;
        }
        if (!needsStrip) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c < 'a' || c > 'z') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isClassAvailable(String s) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass(s);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Object newInstance(String s) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(s);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static <T> Set<Class<T>> loadClasses(String packageName, Class<T> baseClassOrInterface) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        try {
            Set<String> classNames = ReflectionUtil.getClassNamesFromPackage(packageName);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String className : classNames) {
                try {
                    Class<?> clazz = classLoader.loadClass(packageName + "." + className);
                    if (Modifier.isAbstract(clazz.getModifiers()) || !baseClassOrInterface.isAssignableFrom(clazz)) continue;
                    result.add(clazz);
                }
                catch (Throwable e) {
                    logger.error(e, e);
                }
            }
            logger.info("Loaded " + result.size());
        }
        catch (Exception e) {
            logger.error(e, e);
        }
        return result;
    }

    private static Set<String> getClassNamesFromPackage(String packageName) throws IOException, URISyntaxException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashSet<String> names = new HashSet<String>();
        packageName = packageName.replace(".", "/");
        Enumeration<URL> packageURLs = classLoader.getResources(packageName);
        while (packageURLs.hasMoreElements()) {
            URL packageURL = packageURLs.nextElement();
            if (packageURL.getProtocol().equals("jar")) {
                String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
                jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
                logger.info(">" + jarFileName);
                JarFile jf = new JarFile(jarFileName);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> jarEntries = jf.entries();
                    while (jarEntries.hasMoreElements()) {
                        String entryName = jarEntries.nextElement().getName();
                        if (!entryName.startsWith(packageName) || !entryName.endsWith(".class")) continue;
                        entryName = entryName.substring(packageName.length() + 1, entryName.lastIndexOf(46));
                        names.add(entryName);
                    }
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jf == null) continue;
                    if (throwable != null) {
                        try {
                            jf.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jf.close();
                    continue;
                }
            }
            URI uri = new URI(packageURL.toString());
            File folder = new File(uri.getPath());
            File[] files = folder.listFiles();
            if (files == null) continue;
            for (File actual : files) {
                String entryName = actual.getName();
                entryName = entryName.substring(0, entryName.lastIndexOf(46));
                names.add(entryName);
            }
        }
        Iterator itr = names.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            if (!name.equals("package") && !name.endsWith(".") && name.length() != 0) continue;
            itr.remove();
        }
        return names;
    }
}

