/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.scheduler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.apache.openmeetings.db.dao.log.ConferenceLogDao;
import org.apache.openmeetings.db.dao.server.SessiondataDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.service.scheduler.AbstractJob;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="cleanupJob")
public class CleanupJob
extends AbstractJob {
    private static Logger log = LoggerFactory.getLogger(CleanupJob.class);
    @Value(value="${job.cleanup.session.timeout}")
    private long sessionTimeout = 1800000L;
    @Value(value="${job.cleanup.test.setup.timeout}")
    private long testSetupTimeout = 3600000L;
    @Value(value="${job.cleanup.reset.hash.ttl}")
    private long resetHashTtl = 86400000L;
    @Value(value="${job.cleanup.conf.log.ttl}")
    private long confLogTtl = 604800000L;
    @Autowired
    private SessiondataDao sessionDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private ConferenceLogDao confLogDao;

    public void cleanTestSetup() {
        log.trace("CleanupJob.cleanTestSetup");
        long now = System.currentTimeMillis();
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        try {
            File[] folders = OmFileHelper.getStreamsDir().listFiles(File::isDirectory);
            if (folders == null) {
                return;
            }
            for (File folder : folders) {
                File[] files = folder.listFiles(fi -> fi.getName().startsWith("TEST_SETUP_") && fi.isFile() && fi.lastModified() + this.testSetupTimeout < now);
                if (files == null) continue;
                for (File file : files) {
                    log.debug("expired TEST SETUP found: {}", (Object)file.getCanonicalPath());
                    Files.deleteIfExists(file.toPath());
                }
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception while processing tests setup videous.", (Throwable)e);
        }
    }

    public void cleanSessions() {
        log.trace("CleanupJob.cleanSessions");
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        try {
            this.sessionDao.clearSessionTable(this.sessionTimeout);
        }
        catch (Exception err) {
            log.error("execute", (Throwable)err);
        }
    }

    public void cleanExpiredRecordings() {
        log.trace("CleanupJob.cleanExpiredRecordings");
        this.processExpiringRecordings(true, (rec, days) -> {
            if (days < 0L) {
                log.debug("cleanExpiredRecordings:: following recording will be deleted {}", rec);
                File f = rec.getFile("mp4");
                if (f != null) {
                    try {
                        Files.deleteIfExists(f.toPath());
                    }
                    catch (IOException err) {
                        log.error("Unexpected exception while clen-up expired recording", (Throwable)err);
                    }
                }
                this.recordingDao.delete((BaseFileItem)rec);
            }
        });
    }

    public void cleanExpiredResetHash() {
        log.trace("CleanupJob.cleanExpiredResetHash");
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        List users = this.userDao.getByExpiredHash(this.resetHashTtl);
        if (!users.isEmpty()) {
            log.debug("... {} expired hashes were found", (Object)users.size());
            for (User u : users) {
                u.setResetDate(null);
                u.setResethash(null);
                this.userDao.update(u, null);
            }
            log.debug("... DONE CleanupJob.cleanExpiredResetHash");
        }
    }

    public void cleanPersonalData() {
        log.trace("CleanupJob.cleanPersonalData");
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        this.confLogDao.clear(this.confLogTtl);
    }
}

