/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav.methods;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SyncReportInfo
implements XmlSerializable {
    public static final String XML_SYNC_COLLECTION = "sync-collection";
    public static final String XML_SYNC_TOKEN = "sync-token";
    public static final String XML_SYNC_LEVEL = "sync-level";
    public static final String XML_LIMIT = "limit";
    public static final String XML_NRESULTS = "nresults";
    public static final Namespace NAMESPACE = DavConstants.NAMESPACE;
    public static final int SYNC_LEVEL_1 = 1;
    public static final int SYNC_LEVEL_INF = Integer.MAX_VALUE;
    private String syncToken = null;
    private int syncLevel = 1;
    private DavPropertyNameSet properties = new DavPropertyNameSet();
    private int depth = -1;
    private int limit = Integer.MIN_VALUE;

    public SyncReportInfo() {
    }

    public SyncReportInfo(String syncToken, DavPropertyNameSet properties, int syncLevel) {
        this.syncToken = syncToken;
        this.properties.addAll(properties);
        this.syncLevel = syncLevel;
    }

    public SyncReportInfo(String syncToken, DavPropertyNameSet properties, int syncLevel, int depth) {
        this(syncToken, properties, syncLevel);
        this.depth = depth;
    }

    public SyncReportInfo(String syncToken, DavPropertyNameSet properties, int syncLevel, int limit, int depth) {
        this(syncToken, properties, syncLevel, depth);
        this.limit = limit;
    }

    public void setSyncToken(String syncToken) {
        this.syncToken = syncToken;
    }

    public String getSyncToken() {
        return this.syncToken;
    }

    public void addProperty(String name, Namespace namespace) {
        this.addProperty(DavPropertyName.create((String)name, (Namespace)namespace));
    }

    public void addProperty(DavPropertyName name) {
        this.properties.add(name);
    }

    public void addProperties(DavPropertyNameSet set) {
        this.properties.addAll(set);
    }

    public DavPropertyNameSet getProperties() {
        return this.properties;
    }

    public void setProperties(DavPropertyNameSet properties) {
        this.properties = properties;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSyncLevel(int syncLevel) {
        this.syncLevel = syncLevel;
    }

    public int getSyncLevel() {
        return this.syncLevel;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public Element toXml(Document document) {
        Element syncCollection = DomUtil.createElement((Document)document, (String)XML_SYNC_COLLECTION, (Namespace)NAMESPACE);
        DomUtil.addChildElement((Element)syncCollection, (String)XML_SYNC_TOKEN, (Namespace)NAMESPACE, (String)this.syncToken);
        if (this.limit > 0) {
            Element xlimit = DomUtil.addChildElement((Element)syncCollection, (String)XML_LIMIT, (Namespace)NAMESPACE);
            DomUtil.addChildElement((Element)xlimit, (String)XML_NRESULTS, (Namespace)NAMESPACE, (String)Integer.toString(this.limit));
        }
        DomUtil.addChildElement((Element)syncCollection, (String)XML_SYNC_LEVEL, (Namespace)NAMESPACE, (String)(this.syncLevel == Integer.MAX_VALUE ? "infinity" : "1"));
        if (this.properties != null && !this.properties.isEmpty()) {
            syncCollection.appendChild(this.properties.toXml(document));
        }
        return syncCollection;
    }
}

