/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav;

import com.github.caldav4j.CalDAVConstants;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.calendar.OmCalendarDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.service.calendar.caldav.IcalUtils;
import org.apache.openmeetings.service.calendar.caldav.handler.CtagHandler;
import org.apache.openmeetings.service.calendar.caldav.handler.EtagsHandler;
import org.apache.openmeetings.service.calendar.caldav.handler.WebDAVSyncHandler;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Element;

@Component
public class AppointmentManager {
    private static final Logger log = LoggerFactory.getLogger(AppointmentManager.class);
    private static final int IDLE_CONNECTION_TIMEOUT = 30;
    private static final int MAX_HOST_CONNECTIONS = 6;
    private static final int MAX_TOTAL_CONNECTIONS = 10;
    private PoolingHttpClientConnectionManager connmanager = null;
    @Autowired
    private OmCalendarDao calendarDao;
    @Autowired
    private AppointmentDao appointmentDao;
    @Autowired
    private IcalUtils utils;

    public HttpClient createHttpClient() {
        if (this.connmanager == null) {
            this.connmanager = new PoolingHttpClientConnectionManager();
            this.connmanager.setDefaultMaxPerRoute(6);
            this.connmanager.setMaxTotal(10);
        }
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connmanager).build();
    }

    private static String ensureTrailingSlash(String str) {
        return str.endsWith("/") || str.endsWith("\\") ? str : str + "/";
    }

    public void provideCredentials(HttpClientContext context, OmCalendar calendar, Credentials credentials) {
        if (!Strings.isEmpty((String)calendar.getHref()) && credentials != null) {
            URI temp = URI.create(calendar.getHref());
            context.getCredentialsProvider().setCredentials(new AuthScope(temp.getHost(), temp.getPort()), credentials);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection(HttpClient client, HttpClientContext context, OmCalendar calendar) {
        this.cleanupIdleConnections();
        HttpOptions optionsMethod = null;
        try {
            String path = calendar.getHref();
            optionsMethod = new HttpOptions(path);
            optionsMethod.setHeader("Accept", "*/*");
            HttpResponse response = client.execute((HttpUriRequest)optionsMethod, (HttpContext)context);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200 || status == 204) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            log.error("Error executing OptionsMethod during testConnection.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Severe Error in executing OptionsMethod during testConnection.", (Throwable)e);
        }
        finally {
            if (optionsMethod != null) {
                optionsMethod.reset();
            }
        }
        return false;
    }

    public boolean createCalendar(HttpClient client, HttpClientContext context, OmCalendar calendar) {
        if (calendar.getId() == null && calendar.getSyncType() != OmCalendar.SyncType.GOOGLE_CALENDAR) {
            return this.discoverCalendars(client, context, calendar);
        }
        this.calendarDao.update(calendar);
        return true;
    }

    public void deleteCalendar(OmCalendar calendar) {
        this.calendarDao.delete(calendar);
    }

    public List<OmCalendar> getCalendars() {
        return this.calendarDao.get();
    }

    public List<OmCalendar> getCalendars(Long userid) {
        return this.calendarDao.getByUser(userid);
    }

    public List<OmCalendar> getGoogleCalendars(Long userId) {
        return this.calendarDao.getGoogleCalendars(userId);
    }

    public void syncItem(HttpClient client, HttpClientContext context, OmCalendar calendar) {
        this.cleanupIdleConnections();
        if (calendar.getSyncType() != OmCalendar.SyncType.NONE) {
            String path = calendar.getHref();
            (switch (calendar.getSyncType()) {
                case OmCalendar.SyncType.WEBDAV_SYNC -> new WebDAVSyncHandler(path, calendar, client, context, this.appointmentDao, this.utils);
                case OmCalendar.SyncType.CTAG -> new CtagHandler(path, calendar, client, context, this.appointmentDao, this.utils);
                default -> new EtagsHandler(path, calendar, client, context, this.appointmentDao, this.utils);
            }).syncItems();
            this.calendarDao.update(calendar);
        }
    }

    public void syncItems(HttpClient client, HttpClientContext context, Long userId) {
        List<OmCalendar> calendars = this.getCalendars(userId);
        for (OmCalendar calendar : calendars) {
            this.syncItem(client, context, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean discoverCalendars(HttpClient client, HttpClientContext context, OmCalendar calendar) {
        this.cleanupIdleConnections();
        if (calendar.getSyncType() != OmCalendar.SyncType.NONE) {
            return false;
        }
        HttpPropfind propFindMethod = null;
        String userPath = null;
        String homepath = null;
        DavPropertyName curUserPrincipal = DavPropertyName.create((String)"current-user-principal");
        DavPropertyName calHomeSet = DavPropertyName.create((String)"calendar-home-set", (Namespace)CalDAVConstants.NAMESPACE_CALDAV);
        DavPropertyName suppCalCompSet = DavPropertyName.create((String)"supported-calendar-component-set", (Namespace)CalDAVConstants.NAMESPACE_CALDAV);
        try {
            DavPropertyNameSet props;
            String path = calendar.getHref();
            DavPropertyNameSet properties = new DavPropertyNameSet();
            properties.add(curUserPrincipal);
            properties.add(calHomeSet);
            properties.add(DavPropertyName.RESOURCETYPE);
            propFindMethod = new HttpPropfind(path, properties, 0);
            HttpResponse httpResponse = client.execute((HttpUriRequest)propFindMethod, (HttpContext)context);
            if (!propFindMethod.succeeded(httpResponse)) {
                boolean bl = false;
                return bl;
            }
            for (MultiStatusResponse response : propFindMethod.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                DavPropertySet set = response.getProperties(200);
                DavProperty calhome = set.get(calHomeSet);
                DavProperty curPrinci = set.get(curUserPrincipal);
                DavProperty resourcetype = set.get(DavPropertyName.RESOURCETYPE);
                if (AppointmentManager.checkCalendarResourceType(resourcetype)) {
                    boolean bl = this.initCalendar(client, context, calendar);
                    return bl;
                }
                if (calhome != null) {
                    homepath = AppointmentManager.getTextValuefromProperty(calhome);
                    break;
                }
                if (curPrinci == null) continue;
                userPath = AppointmentManager.getTextValuefromProperty(curPrinci);
                break;
            }
            if (homepath == null && userPath != null) {
                props = new DavPropertyNameSet();
                props.add(calHomeSet);
                propFindMethod = new HttpPropfind(userPath, props, 0);
                httpResponse = client.execute((HttpUriRequest)propFindMethod, (HttpContext)context);
                if (!propFindMethod.succeeded(httpResponse)) {
                    int n = 0;
                    return n != 0;
                }
                for (MultiStatusResponse response : propFindMethod.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                    DavPropertySet set = response.getProperties(200);
                    DavProperty calhome = set.get(calHomeSet);
                    if (calhome == null) continue;
                    homepath = AppointmentManager.getTextValuefromProperty(calhome);
                    break;
                }
            }
            if (homepath != null) {
                props = new DavPropertyNameSet();
                props.add(DavPropertyName.RESOURCETYPE);
                props.add(suppCalCompSet);
                props.add(DavPropertyName.DISPLAYNAME);
                propFindMethod = new HttpPropfind(homepath, props, 1);
                httpResponse = client.execute((HttpUriRequest)propFindMethod, (HttpContext)context);
                if (propFindMethod.succeeded(httpResponse)) {
                    boolean success = false;
                    URI resourceUri = propFindMethod.getURI();
                    String host = resourceUri.getScheme() + "://" + resourceUri.getHost() + (String)(resourceUri.getPort() != -1 ? ":" + resourceUri.getPort() : "");
                    for (MultiStatusResponse response : propFindMethod.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                        boolean isVevent = false;
                        DavPropertySet set = response.getProperties(200);
                        DavProperty p = set.get(suppCalCompSet);
                        DavProperty resourcetype = set.get(DavPropertyName.RESOURCETYPE);
                        DavProperty displayname = set.get(DavPropertyName.DISPLAYNAME);
                        boolean isCalendar = AppointmentManager.checkCalendarResourceType(resourcetype);
                        if (p != null) {
                            for (Object o : (Collection)p.getValue()) {
                                Element e;
                                String name;
                                if (!(o instanceof Element) || !"VEVENT".equals(name = DomUtil.getAttribute((Element)(e = (Element)o), (String)"name", null))) continue;
                                isVevent = true;
                            }
                        }
                        if (!isCalendar || !isVevent) continue;
                        success = true;
                        OmCalendar tempCalendar = new OmCalendar();
                        if (displayname != null) {
                            tempCalendar.setTitle(displayname.getValue().toString());
                        }
                        tempCalendar.setHref(host + response.getHref());
                        tempCalendar.setDeleted(false);
                        tempCalendar.setOwner(calendar.getOwner());
                        this.calendarDao.update(tempCalendar);
                        this.initCalendar(client, context, tempCalendar);
                    }
                    boolean bl = success;
                    return bl;
                }
            }
        }
        catch (IOException e) {
            log.error("Error executing PROPFIND Method, during testConnection.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Severe Error in executing PROPFIND Method, during testConnection.", (Throwable)e);
        }
        finally {
            if (propFindMethod != null) {
                propFindMethod.reset();
            }
        }
        return false;
    }

    private static String getTextValuefromProperty(DavProperty<?> property) {
        String value = null;
        if (property != null) {
            for (Object o : (Collection)property.getValue()) {
                if (!(o instanceof Element)) continue;
                Element e = (Element)o;
                value = DomUtil.getTextTrim((Element)e);
                break;
            }
        }
        return value;
    }

    private static boolean checkCalendarResourceType(DavProperty<?> resourcetype) {
        boolean isCalendar = false;
        if (resourcetype != null) {
            DavPropertyName calProp = DavPropertyName.create((String)"calendar", (Namespace)CalDAVConstants.NAMESPACE_CALDAV);
            for (Object o : (Collection)resourcetype.getValue()) {
                Element e;
                if (!(o instanceof Element) || !(e = (Element)o).getLocalName().equals(calProp.getName())) continue;
                isCalendar = true;
            }
        }
        return isCalendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initCalendar(HttpClient client, HttpClientContext context, OmCalendar calendar) {
        if (calendar.getToken() == null || calendar.getSyncType() == OmCalendar.SyncType.NONE) {
            this.calendarDao.update(calendar);
            HttpPropfind propFindMethod = null;
            try {
                String path = calendar.getHref();
                DavPropertyNameSet properties = new DavPropertyNameSet();
                properties.add(DavPropertyName.RESOURCETYPE);
                properties.add(DavPropertyName.DISPLAYNAME);
                properties.add(CtagHandler.DNAME_GETCTAG);
                properties.add(WebDAVSyncHandler.DNAME_SYNCTOKEN);
                propFindMethod = new HttpPropfind(path, properties, 0);
                HttpResponse httpResponse = client.execute((HttpUriRequest)propFindMethod, (HttpContext)context);
                if (propFindMethod.succeeded(httpResponse)) {
                    for (MultiStatusResponse response : propFindMethod.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                        DavPropertySet set = response.getProperties(200);
                        if (calendar.getTitle() == null) {
                            DavProperty property = set.get(DavPropertyName.DISPLAYNAME);
                            calendar.setTitle(property == null ? null : property.getValue().toString());
                        }
                        DavProperty ctag = set.get(CtagHandler.DNAME_GETCTAG);
                        DavProperty syncToken = set.get(WebDAVSyncHandler.DNAME_SYNCTOKEN);
                        if (syncToken != null) {
                            calendar.setSyncType(OmCalendar.SyncType.WEBDAV_SYNC);
                            continue;
                        }
                        if (ctag != null) {
                            calendar.setSyncType(OmCalendar.SyncType.CTAG);
                            continue;
                        }
                        calendar.setSyncType(OmCalendar.SyncType.ETAG);
                    }
                    this.syncItem(client, context, calendar);
                    boolean bl = true;
                    return bl;
                }
                log.error("Error executing PROPFIND Method, with status Code: {}", (Object)httpResponse.getStatusLine().getStatusCode());
                calendar.setSyncType(OmCalendar.SyncType.NONE);
            }
            catch (IOException e) {
                log.error("Error executing OptionsMethod during testConnection.", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Severe Error in executing OptionsMethod during testConnection.", (Throwable)e);
            }
            finally {
                if (propFindMethod != null) {
                    propFindMethod.reset();
                }
            }
        }
        return false;
    }

    public boolean updateItem(HttpClient client, HttpClientContext context, Appointment appointment) {
        this.cleanupIdleConnections();
        OmCalendar calendar = appointment.getCalendar();
        OmCalendar.SyncType type = calendar.getSyncType();
        if (type != OmCalendar.SyncType.NONE && type != OmCalendar.SyncType.GOOGLE_CALENDAR) {
            EtagsHandler calendarHandler;
            String path = AppointmentManager.ensureTrailingSlash(calendar.getHref());
            switch (type) {
                case WEBDAV_SYNC: 
                case CTAG: 
                case ETAG: {
                    calendarHandler = new EtagsHandler(path, calendar, client, context, this.appointmentDao, this.utils);
                    break;
                }
                default: {
                    return false;
                }
            }
            return calendarHandler.updateItem(appointment);
        }
        return false;
    }

    public boolean deleteItem(HttpClient client, HttpClientContext context, Appointment appointment) {
        this.cleanupIdleConnections();
        OmCalendar calendar = appointment.getCalendar();
        OmCalendar.SyncType type = calendar.getSyncType();
        if (type != OmCalendar.SyncType.NONE && type != OmCalendar.SyncType.GOOGLE_CALENDAR) {
            EtagsHandler calendarHandler;
            String path = calendar.getHref();
            switch (type) {
                case WEBDAV_SYNC: 
                case CTAG: 
                case ETAG: {
                    calendarHandler = new EtagsHandler(path, calendar, client, context, this.appointmentDao, this.utils);
                    break;
                }
                default: {
                    return false;
                }
            }
            return calendarHandler.deleteItem(appointment);
        }
        return false;
    }

    public static String getTokenFromProperty(DavProperty<?> property) {
        return property == null ? null : property.getValue().toString();
    }

    public void cleanupIdleConnections() {
        if (this.connmanager != null) {
            this.connmanager.closeIdleConnections(30L, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.connmanager != null) {
            this.connmanager.shutdown();
            this.connmanager = null;
        }
    }
}

