/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.backup.converter;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.openmeetings.db.dto.room.Whiteboard;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.util.OmFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WbConverter {
    private static final Logger log = LoggerFactory.getLogger(WbConverter.class);
    private static final String ATTR_STROKE = "strokeWidth";
    private static final String ATTR_OPACITY = "opacity";
    private static final String TYPE_IMAGE = "image";

    private WbConverter() {
    }

    private static String getColor(int val) {
        return String.format("#%06X", 0xFFFFFF & val);
    }

    private static void add(Whiteboard wb, JSONObject o) {
        if (o != null) {
            String uid = UUID.randomUUID().toString();
            wb.put(uid, o.put("uid", (Object)uid));
        }
    }

    private static JSONObject init(Whiteboard wb, List<?> props) {
        return WbConverter.init(wb, props, true);
    }

    private static JSONObject init(Whiteboard wb, List<?> props, boolean addDim) {
        double left = ((Number)props.get(props.size() - 5)).doubleValue();
        double top = ((Number)props.get(props.size() - 4)).doubleValue();
        double w = ((Number)props.get(props.size() - 3)).doubleValue();
        double h = ((Number)props.get(props.size() - 2)).doubleValue();
        JSONObject o = new JSONObject().put("slide", 0);
        if (addDim) {
            o.put("left", left).put("top", top).put("width", w).put("height", h);
            wb.setWidth((int)Math.max((double)wb.getWidth(), w + left));
            wb.setHeight((int)Math.max((double)wb.getHeight(), h + top));
        }
        return o;
    }

    private static JSONObject setColor(JSONObject o, String stroke, String fill) {
        return o.put("stroke", (Object)stroke).put("fill", (Object)fill);
    }

    private static void processText(Whiteboard wb, List<?> props) {
        if (props.size() < 12) {
            return;
        }
        String color = WbConverter.getColor(WbConverter.getInt(props, 2));
        String style = (String)props.get(4);
        JSONObject o = WbConverter.setColor(WbConverter.init(wb, props), color, color).put("type", (Object)"i-text").put("text", props.get(1)).put("fontSize", props.get(3));
        if (style.indexOf("bold") > -1) {
            o.put("fontWeight", (Object)"bold");
        }
        if (style.indexOf("italic") > -1) {
            o.put("fontStyle", (Object)"inalic");
        }
        WbConverter.add(wb, o);
    }

    private static void processPath(Whiteboard wb, List<?> props) {
        if (props.size() < 13) {
            return;
        }
        String color = WbConverter.getColor(WbConverter.getInt(props, 4));
        JSONObject o = WbConverter.setColor(WbConverter.init(wb, props), color, null).put("type", (Object)"path").put(ATTR_STROKE, props.get(3));
        List points = (List)props.get(1);
        JSONArray path = new JSONArray();
        for (List point : points) {
            if (path.length() == 0) {
                path.put((Object)new JSONArray(List.of("M", Integer.valueOf(WbConverter.getInt(point, 1)), Integer.valueOf(WbConverter.getInt(point, 2)))));
                continue;
            }
            if (path.length() == points.size() - 1) {
                path.put((Object)new JSONArray(List.of("L", Integer.valueOf(WbConverter.getInt(point, 3)), Integer.valueOf(WbConverter.getInt(point, 4)))));
                continue;
            }
            path.put((Object)new JSONArray(List.of("Q", Integer.valueOf(WbConverter.getInt(point, 1)), Integer.valueOf(WbConverter.getInt(point, 2)), Integer.valueOf(WbConverter.getInt(point, 3)), Integer.valueOf(WbConverter.getInt(point, 4)))));
        }
        WbConverter.add(wb, o.put("path", (Object)path).put(ATTR_OPACITY, props.get(5)));
    }

    private static void processLine(Whiteboard wb, List<?> props) {
        if (props.size() < 16) {
            return;
        }
        String color = WbConverter.getColor(WbConverter.getInt(props, 1));
        WbConverter.add(wb, WbConverter.setColor(WbConverter.init(wb, props), color, color).put("type", (Object)"line").put(ATTR_STROKE, props.get(2)).put(ATTR_OPACITY, props.get(3)).put("x1", props.get(4)).put("y1", props.get(5)).put("x2", props.get(6)).put("y2", props.get(7)));
    }

    private static int getInt(List<?> props, int idx) {
        Object o = props.get(idx);
        if (o instanceof Number) {
            Number num = (Number)o;
            return num.intValue();
        }
        if (o instanceof String) {
            String str = (String)o;
            return NumberUtils.toInt((String)str);
        }
        return 0;
    }

    private static JSONObject processRect(Whiteboard wb, List<?> props) {
        if (props.size() < 15) {
            return null;
        }
        return WbConverter.setColor(WbConverter.init(wb, props), 1 == WbConverter.getInt(props, 4) ? WbConverter.getColor(WbConverter.getInt(props, 1)) : null, 1 == WbConverter.getInt(props, 5) ? WbConverter.getColor(WbConverter.getInt(props, 3)) : null).put("type", (Object)"rect").put(ATTR_STROKE, props.get(2)).put(ATTR_OPACITY, props.get(6));
    }

    private static void processEllipse(Whiteboard wb, List<?> props) {
        JSONObject o = WbConverter.processRect(wb, props);
        if (o != null) {
            o.put("type", (Object)"ellipse").put("rx", o.getDouble("width") / 2.0).put("ry", o.getDouble("height") / 2.0);
            WbConverter.add(wb, o);
        }
    }

    private static void processClipart(Whiteboard wb, List<?> props) {
        if (props.size() < 19) {
            return;
        }
        String src = (String)props.get(2);
        int idx = src.indexOf("cliparts");
        if (idx > -1) {
            src = String.format("./public/%s", src.substring(idx));
        }
        WbConverter.add(wb, WbConverter.init(wb, props).put("type", (Object)TYPE_IMAGE).put("omType", (Object)"Clipart").put("_src", (Object)src).put("angle", props.get(3)));
    }

    private static long getFileId(String src) {
        int idx1 = src.lastIndexOf(47);
        int idx2 = src.indexOf(63);
        if (idx1 < 0 || idx2 < 0) {
            return -1L;
        }
        return NumberUtils.toLong((String)src.substring(idx1 + 1, idx2), (long)-1L);
    }

    private static void processImage(Whiteboard wb, List<?> props) {
        if (props.size() < 17) {
            return;
        }
        long fileId = WbConverter.getFileId((String)props.get(2));
        if (fileId < 0L) {
            return;
        }
        WbConverter.add(wb, WbConverter.init(wb, props).put("type", (Object)TYPE_IMAGE).put("fileType", (Object)BaseFileItem.Type.IMAGE.name()).put("fileId", fileId));
    }

    private static void processDoc(Whiteboard wb, List<?> props) {
        if (props.size() < 27) {
            return;
        }
        long fileId = WbConverter.getFileId((String)props.get(2));
        if (fileId < 0L) {
            return;
        }
        WbConverter.add(wb, WbConverter.init(wb, props, false).put("type", (Object)TYPE_IMAGE).put("fileType", (Object)BaseFileItem.Type.PRESENTATION.name()).put("fileId", fileId));
    }

    private static void processVid(Whiteboard wb, List<?> props) {
        if (props.size() < 14) {
            return;
        }
        WbConverter.add(wb, WbConverter.init(wb, props).put("type", (Object)TYPE_IMAGE).put("fileType", (Object)BaseFileItem.Type.VIDEO.name()).put("fileId", props.get(1)));
    }

    public static Whiteboard convert(FileItem fi) {
        Whiteboard wb = new Whiteboard();
        wb.setWidth(0);
        wb.setHeight(0);
        HashSet<String> uids = new HashSet<String>();
        List<?> wml = WbConverter.loadWmlFile(fi.getHash());
        for (Object wo : wml) {
            String uid;
            List props = (List)wo;
            if (props.isEmpty() || uids.contains(uid = (String)props.get(props.size() - 1))) continue;
            uids.add(uid);
            switch ((String)props.get(0)) {
                case "letter": {
                    WbConverter.processText(wb, props);
                    break;
                }
                case "paint": {
                    WbConverter.processPath(wb, props);
                    break;
                }
                case "line": 
                case "uline": {
                    WbConverter.processLine(wb, props);
                    break;
                }
                case "rectangle": 
                case "drawarrow": {
                    WbConverter.add(wb, WbConverter.processRect(wb, props));
                    break;
                }
                case "ellipse": {
                    WbConverter.processEllipse(wb, props);
                    break;
                }
                case "clipart": {
                    WbConverter.processClipart(wb, props);
                    break;
                }
                case "image": {
                    WbConverter.processImage(wb, props);
                    break;
                }
                case "swf": {
                    WbConverter.processDoc(wb, props);
                    break;
                }
                case "flv": {
                    WbConverter.processVid(wb, props);
                    break;
                }
            }
        }
        return wb;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<?> loadWmlFile(String hash) {
        String name = OmFileHelper.getName((String)hash, (String)"wml");
        File file = new File(OmFileHelper.getUploadWmlDir(), name);
        log.debug("filepathComplete: {}", (Object)file);
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver());
        xstream.setMode(1001);
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.allowTypeHierarchy(List.class);
        xstream.allowTypeHierarchy(String.class);
        xstream.ignoreUnknownElements();
        try (FileInputStream is = new FileInputStream(file);){
            List list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
                list = (List)xstream.fromXML((Reader)reader);
            }
            return list;
        }
        catch (Exception err) {
            log.error("loadWmlFile", (Throwable)err);
            return List.of();
        }
    }
}

