/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.settings;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;

public class Theme
implements ITheme {
    private final String name;
    private final List<HeaderItem> headerItems = new ArrayList<HeaderItem>();

    public Theme(String name, ResourceReference ... resourceReferences) {
        this.name = name;
        for (ResourceReference resourceReference : resourceReferences) {
            if (resourceReference instanceof CssResourceReference) {
                this.headerItems.add((HeaderItem)CssHeaderItem.forReference((ResourceReference)resourceReference));
                continue;
            }
            if (!(resourceReference instanceof JavaScriptResourceReference)) continue;
            this.headerItems.add((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)resourceReference));
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<HeaderItem> getDependencies() {
        return this.headerItems;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        if (this.useCdnResources()) {
            Iterable<String> cdnUrls = this.getCdnUrls();
            if (cdnUrls != null && cdnUrls.iterator().hasNext()) {
                for (String cdnUrl : cdnUrls) {
                    response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new UrlResourceReference(Url.parse((CharSequence)cdnUrl))));
                }
            } else {
                this.renderPackageReferences(response);
            }
        } else {
            this.renderPackageReferences(response);
        }
    }

    private boolean useCdnResources() {
        boolean result = false;
        if (Application.exists()) {
            IBootstrapSettings settings = Bootstrap.getSettings();
            result = settings.useCdnResources();
        }
        return result;
    }

    @Override
    public Iterable<String> getCdnUrls() {
        return List.of();
    }

    private void renderPackageReferences(IHeaderResponse response) {
        for (HeaderItem headerItem : this.getDependencies()) {
            response.render(headerItem);
        }
    }

    protected String getVersion() {
        String version = "5.3.2";
        if (Application.exists()) {
            version = Bootstrap.getSettings().getVersion();
        }
        return version;
    }
}

