/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.resource;

import java.util.Locale;
import org.apache.wicket.core.request.handler.logger.ResourceReferenceLogData;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class ResourceReferenceRequestHandler
implements IRequestHandler,
ILoggableRequestHandler {
    private final ResourceReference resourceReference;
    private final PageParameters pageParameters;
    private ResourceReferenceLogData logData;

    public ResourceReferenceRequestHandler(ResourceReference resourceReference) {
        this(resourceReference, null);
    }

    public ResourceReferenceRequestHandler(ResourceReference resourceReference, PageParameters pageParameters) {
        Args.notNull((Object)resourceReference, (String)"resourceReference");
        this.resourceReference = resourceReference;
        this.pageParameters = pageParameters != null ? pageParameters : new PageParameters();
    }

    public ResourceReference getResourceReference() {
        return this.resourceReference;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new ResourceReferenceLogData(this);
        }
    }

    public ResourceReferenceLogData getLogData() {
        return this.logData;
    }

    public void respond(IRequestCycle requestCycle) {
        new ResourceRequestHandler(this.getResourceReference().getResource(), this.getPageParameters()).respond(requestCycle);
    }

    public Locale getLocale() {
        return this.getResourceReference().getLocale();
    }

    public IResource getResource() {
        return this.getResourceReference().getResource();
    }

    public String getStyle() {
        return this.getResourceReference().getStyle();
    }

    public String getVariation() {
        return this.getResourceReference().getVariation();
    }

    public String toString() {
        return "ResourceReferenceRequestHandler{resourceReference=" + this.resourceReference + ", pageParameters=" + this.pageParameters + "}";
    }
}

