/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import com.github.openjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.openmeetings.db.dto.room.Whiteboard;
import org.apache.openmeetings.db.dto.room.Whiteboards;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.web.app.WhiteboardManager;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.resource.FileSystemResource;
import org.apache.wicket.resource.FileSystemResourceReference;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileItemResourceReference<T extends BaseFileItem>
extends FileSystemResourceReference {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(FileItemResourceReference.class);
    @SpringBean
    private WhiteboardManager wbm;

    protected FileItemResourceReference(String name) {
        super(name);
    }

    public IResource getResource() {
        return new FileSystemResource(){
            private static final long serialVersionUID = 1L;
            private File file;
            private T r;

            protected String getMimeType() throws IOException {
                return FileItemResourceReference.this.getMimeType(this.r);
            }

            protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attr) {
                this.r = FileItemResourceReference.this.getFileItem(attr);
                if (this.r != null) {
                    this.file = FileItemResourceReference.this.getFile(this.r, attr);
                }
                if (this.file != null && this.file.exists()) {
                    AbstractResource.ResourceResponse rr = this.createResourceResponse(attr, this.file.toPath());
                    rr.setFileName(FileItemResourceReference.this.getFileName(this.r));
                    return rr;
                }
                log.debug("No file item was found");
                AbstractResource.ResourceResponse rr = new AbstractResource.ResourceResponse();
                rr.setError(Integer.valueOf(404));
                return rr;
            }
        };
    }

    protected abstract String getMimeType(T var1);

    protected abstract String getFileName(T var1);

    protected abstract File getFile(T var1, IResource.Attributes var2);

    protected abstract T getFileItem(IResource.Attributes var1);

    protected boolean isAtWb(Client c, String wbId, String wbItemId, Long fileId) {
        if (c != null && c.getRoom() != null) {
            Whiteboards wbs = this.wbm.get(c.getRoomId());
            if (!Strings.isEmpty((String)wbItemId) && !Strings.isEmpty((String)wbId) && wbId.equals(wbs.getUid())) {
                for (Map.Entry e : wbs.getWhiteboards().entrySet()) {
                    JSONObject file = ((Whiteboard)e.getValue()).get(wbItemId);
                    if (file == null || !fileId.equals(file.optLong("fileId"))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

