/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.record;

import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.util.FileItemResourceReference;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValue;

public abstract class RecordingResourceReference
extends FileItemResourceReference<Recording> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private RecordingDao recDao;
    @SpringBean
    private ClientManager cm;
    @SpringBean
    private GroupUserDao groupUserDao;

    protected RecordingResourceReference(String name) {
        super(name);
        Injector.get().inject((Object)this);
    }

    @Override
    public String getMimeType(Recording r) {
        return this.getMimeType();
    }

    public abstract String getMimeType();

    @Override
    protected Recording getFileItem(IResource.Attributes attributes) {
        PageParameters params = attributes.getParameters();
        StringValue inId = params.get("id");
        String ruid = params.get("ruid").toString();
        String uid = params.get("uid").toString();
        String wbItemId = params.get("wuid").toString();
        Long id = null;
        try {
            id = inId.toOptionalLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        WebSession ws = WebSession.get();
        if (id == null && ws.signIn(inId.toString(), true)) {
            id = WebSession.getRecordingId();
        }
        if (id != null && ws.isSignedIn()) {
            return this.getRecording(id, ruid, uid, wbItemId);
        }
        return null;
    }

    private Recording getRecording(Long id, String ruid, String uid, String wbItemId) {
        log.debug("Recording with id {} is requested", (Object)id);
        Recording r = this.recDao.get(id);
        if (r == null || r.getType() == BaseFileItem.Type.FOLDER || r.isDeleted()) {
            return null;
        }
        if (id.equals(WebSession.getRecordingId())) {
            return r;
        }
        Client c = this.cm.get(uid);
        if (this.isAtWb(c, ruid, wbItemId, r.getId())) {
            return r;
        }
        if (r.getOwnerId() == null && r.getGroupId() == null) {
            return r;
        }
        if (r.getOwnerId() != null && WebSession.getUserId().equals(r.getOwnerId())) {
            return r;
        }
        if (r.getGroupId() != null && this.groupUserDao.isUserInGroup(r.getGroupId().longValue(), WebSession.getUserId().longValue())) {
            return r;
        }
        return null;
    }
}

